/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.AsyncEclipseQueue;
import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.EXDRInputStream;
import com.parctechnologies.eclipse.EXDROutputStream;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseConnectionImpl;
import com.parctechnologies.eclipse.EclipseEngine;
import com.parctechnologies.eclipse.EclipseEngineOptions;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseTerminatedException;
import com.parctechnologies.eclipse.FromEclipseQueue;
import com.parctechnologies.eclipse.NativeEclipse;
import com.parctechnologies.eclipse.Platform;
import com.parctechnologies.eclipse.ToEclipseQueue;
import java.io.File;
import java.io.IOException;

public class EmbeddedEclipse
extends EclipseConnectionImpl
implements EclipseConnection,
EclipseEngine {
    private static EmbeddedEclipse single;
    private FromEclipseQueue embed_info;
    private EXDRInputStream embed_infoEXDRInput;
    ToEclipseQueue stdin;
    FromEclipseQueue stdout;
    FromEclipseQueue stderr;
    private boolean useQueues;

    public static synchronized EmbeddedEclipse getInstance(EclipseEngineOptions eclipseEngineOptions) throws EclipseException, IOException {
        if (single != null) {
            single.testTerminated();
            throw new EclipseException("The embedded ECLiPSe has already been started in this JVM.");
        }
        single = new EmbeddedEclipse(eclipseEngineOptions);
        return single;
    }

    public static synchronized EmbeddedEclipse getInstance() throws EclipseException, IOException {
        if (single != null) {
            single.testTerminated();
            return single;
        }
        throw new EclipseException("The embedded ECLiPSe has not yet been started in this JVM.");
    }

    private EmbeddedEclipse(EclipseEngineOptions eclipseEngineOptions) throws EclipseException, IOException {
        this.processOptions(eclipseEngineOptions);
        int n = NativeEclipse.init();
        if (n != 0) {
            throw new EclipseException("Eclipse init = " + n);
        }
        ToEclipseQueue toEclipseQueue = this.createToEclipseQueue("ec_rpc_in");
        toEclipseQueue.setSystemQueue(true);
        this.toEclipse = new EXDROutputStream(toEclipseQueue);
        FromEclipseQueue fromEclipseQueue = this.createFromEclipseQueue("ec_rpc_out");
        fromEclipseQueue.setSystemQueue(true);
        this.fromEclipse = new EXDRInputStream(fromEclipseQueue);
        this.useQueues = eclipseEngineOptions.isUsingQueues();
        if (eclipseEngineOptions.isUsingQueues()) {
            this.initialiseStandardStreamQueues();
        }
        this.rpc(new CompoundTermImpl(":", new Atom("sepia_kernel"), new CompoundTermImpl("set_embed_peer", new Atom(eclipseEngineOptions.getPeerName()), new Atom("java"))));
        this.embed_info = this.getFromEclipseQueue("embed_info");
        this.embed_info.setSystemQueue(true);
        this.embed_infoEXDRInput = new EXDRInputStream(this.embed_info);
    }

    private void processOptions(EclipseEngineOptions eclipseEngineOptions) throws EclipseException {
        this.setPeerName(new Atom(eclipseEngineOptions.getPeerName()));
        if (eclipseEngineOptions.getEclipseDir() == null) {
            throw new EclipseException("The location of the ECLiPSe installation was not set in the EclipseEngineOptions object supplied.");
        }
        EmbeddedEclipse.loadEclipse(eclipseEngineOptions.getEclipseDir());
        int n = NativeEclipse.setOption(11, eclipseEngineOptions.getEclipseDir());
        if (n != 0) {
            throw new EclipseException("Setting eclipse installation directory to '" + eclipseEngineOptions.getEclipseDir() + "' result = " + n);
        }
        if (eclipseEngineOptions.getCommandLineOptions() != null) {
            n = NativeEclipse.setOption(2, eclipseEngineOptions.getCommandLineOptions().length);
            if (n != 0) {
                throw new EclipseException("Setting eclipse no. of command line arguments to '" + eclipseEngineOptions.getCommandLineOptions().length + "' result = " + n);
            }
            n = NativeEclipse.setOption(3, eclipseEngineOptions.getCommandLineOptions());
            if (n != 0) {
                throw new EclipseException("Setting eclipse command line arguments to '" + eclipseEngineOptions.getCommandLineOptions() + "' result = " + n);
            }
        }
        if (eclipseEngineOptions.getDefaultModule() != null && (n = NativeEclipse.setOption(10, eclipseEngineOptions.getDefaultModule())) != 0) {
            throw new EclipseException("Setting eclipse default module to '" + eclipseEngineOptions.getDefaultModule() + "' result = " + n);
        }
        if (eclipseEngineOptions.getLocalSize() != 0) {
            n = NativeEclipse.setOption(4, eclipseEngineOptions.getLocalSize() * 0x100000);
            if (n != 0) {
                throw new EclipseException("Setting eclipse local stack size to " + eclipseEngineOptions.getLocalSize() + "M result = " + n);
            }
        }
        if (eclipseEngineOptions.getGlobalSize() != 0) {
            n = NativeEclipse.setOption(5, eclipseEngineOptions.getGlobalSize() * 0x100000);
            if (n != 0) {
                throw new EclipseException("Setting eclipse global stack size to " + eclipseEngineOptions.getGlobalSize() + "M result = " + n);
            }
        }
        n = NativeEclipse.setOption(12, eclipseEngineOptions.isUsingQueues() ? 2 : 0);
    }

    private static void loadEclipse(String string) {
        if (!Platform.getInstance().supportsEmbeddedEclipse()) {
            throw new UnsupportedOperationException("The creation of an EmbeddedEclipse is not supported on platform " + System.getProperty("os.name") + "/" + System.getProperty("os.arch") + ".");
        }
        Platform.getInstance().loadEclipseSharedLibrary(new File(string));
    }

    @Override
    synchronized int readFromStream(int n, int n2, int n3, byte[] byArray) throws IOException {
        int n4 = NativeEclipse.QueueRead(n, n2, n3, byArray);
        if (n4 < 0) {
            throw new IOException("NativeEclipse.QueueRead exited with error code " + n4);
        }
        return n4;
    }

    @Override
    synchronized int readByteFromStream(int n) throws IOException {
        int n2 = NativeEclipse.QueueReadByte(n);
        if (n2 == -1) {
            return -1;
        }
        if (n2 < -1) {
            throw new IOException("NativeEclipse.QueueReadByte exited with error code " + n2);
        }
        return n2;
    }

    @Override
    synchronized int availableOnStream(int n) throws IOException {
        int n2 = NativeEclipse.QueueAvailable(n);
        if (n2 < 0) {
            throw new IOException("NativeEclipse.QueueAvailable exited with error code " + n2);
        }
        return n2;
    }

    @Override
    synchronized int writeToStream(int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = NativeEclipse.QueueWrite(n, byArray, n2, n3);
        if (n4 < 0) {
            throw new IOException("NativeEclipse.QueueWrite exited with error code " + n4);
        }
        return n4;
    }

    @Override
    synchronized void writeByteToStream(int n, byte by) throws IOException {
        int n2 = NativeEclipse.QueueWriteByte(n, by);
        if (n2 < 0) {
            throw new IOException("NativeEclipse.QueueWriteByte exited with error code " + n2);
        }
    }

    @Override
    EclipseConnectionImpl.ControlSignal getNextControlSignal(boolean bl, boolean bl2) throws IOException {
        Integer n = new Integer(0);
        int n2 = bl ? NativeEclipse.HandleEvents(n) : NativeEclipse.resumeLong(n);
        if (n2 == 6) {
            return new EclipseConnectionImpl.WaitIOSignal(n);
        }
        if (n2 == 7 && this.lookupFromEclipseQueue(n) == this.embed_info) {
            CompoundTerm compoundTerm = (CompoundTerm)this.embed_infoEXDRInput.readTerm();
            if (compoundTerm.functor().equals("queue_connect") && compoundTerm.arity() == 3 && compoundTerm.arg(1) instanceof Atom && compoundTerm.arg(2) instanceof Integer && compoundTerm.arg(3) instanceof Atom) {
                Atom atom = (Atom)compoundTerm.arg(1);
                n = (Integer)compoundTerm.arg(2);
                Atom atom2 = (Atom)compoundTerm.arg(3);
                return new EclipseConnectionImpl.OpenQueueSignal(atom, n, atom2);
            }
            if (compoundTerm.functor().equals("queue_close") && compoundTerm.arity() == 1 && compoundTerm.arg(1) instanceof Integer) {
                n = (Integer)compoundTerm.arg(1);
                return new CloseQueueSignal(n);
            }
        }
        if (n2 == 7 && this.lookupFromEclipseQueue(n) != this.embed_info) {
            return new FlushIOSignal(n);
        }
        if (n2 == 0) {
            return new EclipseConnectionImpl.YieldSignal();
        }
        if (n2 == 5) {
            return new RunningSignal();
        }
        return null;
    }

    @Override
    void setupFromEclipseQueue(String string) throws IOException, EclipseException {
        this.rpc(":", new Atom("sepia_kernel"), new CompoundTermImpl("ecl_create_embed_queue", new Atom(string), new Atom("fromec"), new Atom("")));
    }

    @Override
    void setupToEclipseQueue(String string) throws IOException, EclipseException {
        this.rpc(":", new Atom("sepia_kernel"), new CompoundTermImpl("ecl_create_embed_queue", new Atom(string), new Atom("toec"), new Atom("")));
    }

    @Override
    public synchronized AsyncEclipseQueue getAsyncEclipseQueue(String string) throws EclipseException, IOException {
        throw new IOException("Asynchronous queues not implemented for this connection type");
    }

    @Override
    void setupAsyncEclipseQueue(String string) throws EclipseException, IOException {
        throw new IOException("Asynchronous queues not implemented for this connection type");
    }

    @Override
    int getStreamNumber(String string) {
        return NativeEclipse.StreamNumber(string);
    }

    @Override
    synchronized void flushStream(int n) {
    }

    @Override
    void sendGoal(Object object) throws IOException {
        this.toEclipse.write(object);
        this.toEclipse.flush();
    }

    @Override
    Object receiveGoal() throws IOException {
        return this.fromEclipse.readTerm();
    }

    protected void finalize() throws IOException {
        this.destroy();
    }

    @Override
    void closeFromEclipseStreamEclipseSide(int n) throws IOException {
        super.closeFromEclipseStreamEclipseSide(n);
        try {
            this.rpc(":", new Atom("sepia_kernel"), new CompoundTermImpl("close_embed_queue_eclipseside", this.getPeerName(), new Integer(n)));
        }
        catch (EclipseException eclipseException) {
            throw new IOException("Problem closing ECLiPSe stream " + n + ": " + eclipseException.toString());
        }
    }

    @Override
    void closeToEclipseStreamEclipseSide(int n) throws IOException {
        super.closeToEclipseStreamEclipseSide(n);
        try {
            this.rpc(":", new Atom("sepia_kernel"), new CompoundTermImpl("close_embed_queue_eclipseside", this.getPeerName(), new Integer(n)));
        }
        catch (EclipseException eclipseException) {
            throw new IOException("Problem closing ECLiPSe stream " + n + ": " + eclipseException.toString());
        }
    }

    void respondRunning() throws IOException {
        throw new IOException("NativeEclipse.HandleEvents reports that an asynchronous ECLiPSe thread is already running: cannot handle events in this case.");
    }

    @Override
    void respondWaitIO(Integer n) throws IOException {
        ToEclipseQueue toEclipseQueue = this.lookupToEclipseQueue(n);
        if (toEclipseQueue == null) {
            System.err.println("ECLiPSe yielded after flushing stream " + n + " which is not registered as a ToEclipseQueue.");
        } else {
            toEclipseQueue.notifyRequest();
        }
    }

    void respondFlushIO(Integer n) throws IOException {
        FromEclipseQueue fromEclipseQueue = this.lookupFromEclipseQueue(n);
        if (fromEclipseQueue == null) {
            System.err.println("ECLiPSe yielded after reading empty stream " + n + " which is not registered as a FromEclipseQueue.");
        } else {
            fromEclipseQueue.notifyAvailable();
        }
    }

    public synchronized void destroy() throws IOException {
        this.testTerminated();
        this.closeAllQueues(true);
        this.terminated = true;
        NativeEclipse.Cleanup();
    }

    @Override
    public synchronized ToEclipseQueue getEclipseStdin() throws EclipseTerminatedException {
        this.testTerminated();
        return this.stdin;
    }

    @Override
    public synchronized FromEclipseQueue getEclipseStdout() throws EclipseTerminatedException {
        this.testTerminated();
        return this.stdout;
    }

    @Override
    public synchronized FromEclipseQueue getEclipseStderr() throws EclipseTerminatedException {
        this.testTerminated();
        return this.stderr;
    }

    void initialiseStandardStreamQueues() throws EclipseException, IOException {
        this.stdin = this.createToEclipseQueue("input");
        this.stdin.setSystemQueue(true);
        this.stdout = this.createFromEclipseQueue("output");
        this.stdout.setSystemQueue(true);
        this.stderr = this.createFromEclipseQueue("error");
        this.stderr.setSystemQueue(true);
    }

    @Override
    public synchronized boolean isUsingQueues() {
        return this.useQueues;
    }

    class FlushIOSignal
    extends EclipseConnectionImpl.ControlSignal {
        private Integer streamID;

        FlushIOSignal(Integer n) {
            this.streamID = n;
        }

        @Override
        void respond() throws IOException {
            EmbeddedEclipse.this.respondFlushIO(this.streamID);
        }
    }

    class CloseQueueSignal
    extends EclipseConnectionImpl.ControlSignal {
        private Integer streamID;

        CloseQueueSignal(Integer n) {
            this.streamID = n;
        }

        @Override
        void respond() throws IOException {
            EmbeddedEclipse.this.respondCloseQueue(this.streamID);
        }
    }

    class RunningSignal
    extends EclipseConnectionImpl.ControlSignal {
        RunningSignal() {
        }

        @Override
        void respond() throws IOException {
            EmbeddedEclipse.this.respondRunning();
        }
    }

    private static interface IntOption {
        public static final int LOCALSIZE = 4;
        public static final int GLOBALSIZE = 5;
        public static final int PRIVATESIZE = 6;
        public static final int SHAREDSIZE = 7;
        public static final int IO = 12;
        public static final int OPTION_ARGC = 2;
    }

    private static interface StringArrayOption {
        public static final int OPTION_ARGV = 3;
    }

    private static interface StringOption {
        public static final int DEFAULT_MODULE = 10;
        public static final int ECLIPSEDIR = 11;
    }

    private static interface resume_result {
        public static final int PSUCCEED = 0;
        public static final int PFAIL = 1;
        public static final int PTHROW = 2;
        public static final int PYIELD = 4;
        public static final int PRUNNING = 5;
        public static final int PWAITIO = 6;
        public static final int PFLUSHIO = 7;
    }
}

