/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import java.awt.geom.Rectangle2D;

public class GrappaBox
extends Rectangle2D.Double {
    private boolean dimensioned = true;

    public GrappaBox() {
    }

    public GrappaBox(Rectangle2D rectangle2D) {
        this(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public GrappaBox(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public GrappaBox(String string, boolean bl) {
        this.dimensioned = bl;
        double[] dArray = null;
        try {
            dArray = GrappaSupport.arrayForTuple(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("coordinate string (" + string + ") has a bad number format (" + numberFormatException.getMessage() + ")");
        }
        if (dArray == null || dArray.length != 4) {
            throw new IllegalArgumentException("coordinate string (" + string + ") does not contain 4 valid coordinates");
        }
        if (bl) {
            this.x = dArray[0];
            this.y = Grappa.negateStringYCoord ? -dArray[1] : dArray[1];
            this.width = dArray[2];
            this.height = dArray[3];
        } else {
            double d;
            if (Grappa.negateStringYCoord) {
                dArray[1] = -dArray[1];
                dArray[3] = -dArray[3];
            }
            if (dArray[0] > dArray[2]) {
                d = dArray[0];
                dArray[0] = dArray[2];
                dArray[2] = d;
            }
            if (dArray[1] > dArray[3]) {
                d = dArray[1];
                dArray[1] = dArray[3];
                dArray[3] = d;
            }
            this.x = dArray[0];
            this.y = dArray[1];
            this.width = dArray[2] - dArray[0];
            this.height = dArray[3] - dArray[1];
        }
    }

    public GrappaBox(String string) {
        this(string, true);
    }

    public String toAttributeString() {
        return this.toFormattedString("%b");
    }

    public String toFormattedString(String string) {
        return GrappaSupportPrintf.sprintf(new Object[]{string, this});
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.width + "," + this.height;
    }

    public boolean isDimensioned() {
        return this.dimensioned;
    }
}

