/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.GrappaPoint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GrappaLine
implements GrappaConstants,
Cloneable,
Shape {
    public static final double arrowLength = 10.0;
    public static final double arrowWidth = 5.0;
    public static final int NONE_ARROW_EDGE = 0;
    public static final int HEAD_ARROW_EDGE = 1;
    public static final int TAIL_ARROW_EDGE = 2;
    public static final int BOTH_ARROW_EDGE = 3;
    private GeneralPath path = null;
    private GeneralPath testpath = null;
    private int arrow = 0;
    private GrappaPoint[] gpts = null;
    private int windingRule = Grappa.windingRule;

    public GrappaLine(GrappaPoint[] grappaPointArray, int n) {
        this.updateLine(grappaPointArray, n);
    }

    public GrappaLine(String string) {
        this.updateLine(string);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GrappaLine)) {
            return false;
        }
        GrappaLine grappaLine = (GrappaLine)object;
        if (grappaLine == this) {
            return true;
        }
        if (grappaLine.getArrowType() != this.arrow) {
            return false;
        }
        return grappaLine.gpts.length == this.gpts.length && this.gpts.equals(grappaLine.gpts);
    }

    public int getArrowType() {
        return this.arrow;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public boolean startsNear(Point2D point2D) {
        return this.gpts[0].distance(point2D) < this.gpts[this.gpts.length - 1].distance(point2D);
    }

    public String toAttributeString() {
        return this.toFormattedString("%p");
    }

    public String toFormattedString(String string) {
        int n = 0;
        int n2 = this.gpts.length - 1;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.arrow & 1) != 0) {
            stringBuffer.append("s,");
            stringBuffer.append(this.gpts[n++].toFormattedString(string));
            bl = true;
        }
        if ((this.arrow & 2) != 0) {
            if (bl) {
                stringBuffer.append(" e,");
            } else {
                stringBuffer.append("e,");
                bl = true;
            }
            stringBuffer.append(this.gpts[n2--].toFormattedString(string));
        }
        while (n <= n2) {
            if (bl) {
                stringBuffer.append(" ");
            } else {
                bl = true;
            }
            stringBuffer.append(this.gpts[n++].toFormattedString(string));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        int n = 0;
        int n2 = this.gpts.length - 1;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.arrow & 1) != 0) {
            stringBuffer.append("s,");
            stringBuffer.append(this.gpts[n].x);
            stringBuffer.append(",");
            stringBuffer.append(this.gpts[n++].y);
            bl = true;
        }
        if ((this.arrow & 2) != 0) {
            if (bl) {
                stringBuffer.append(" e,");
            } else {
                stringBuffer.append("e,");
                bl = true;
            }
            stringBuffer.append(this.gpts[n2].x);
            stringBuffer.append(",");
            stringBuffer.append(this.gpts[n2--].y);
        }
        while (n <= n2) {
            if (bl) {
                stringBuffer.append(" ");
            } else {
                bl = true;
            }
            stringBuffer.append(this.gpts[n].x);
            stringBuffer.append(",");
            stringBuffer.append(this.gpts[n++].y);
        }
        return stringBuffer.toString();
    }

    public boolean changeArrowType(int n) {
        boolean bl = false;
        if (this.arrow != n && (n & 0xFFFFFFFC) == 0) {
            bl = true;
            this.updateLine(this.gpts, n);
        }
        return bl;
    }

    private void addArrow(GeneralPath generalPath, GeneralPath generalPath2, GrappaPoint grappaPoint, GrappaPoint grappaPoint2, double d, double d2) {
        double d3 = Math.atan2(grappaPoint.y - grappaPoint2.y, grappaPoint.x - grappaPoint2.x);
        double d4 = d2 / 2.0;
        float f = (float)(grappaPoint.x - (d * Math.cos(d3) - d4 * Math.sin(d3)));
        float f2 = (float)(grappaPoint.y - (d * Math.sin(d3) + d4 * Math.cos(d3)));
        generalPath.lineTo(f, f2);
        generalPath2.lineTo(f, f2);
        f = (float)(grappaPoint.x - (d * Math.cos(d3) + d4 * Math.sin(d3)));
        f2 = (float)(grappaPoint.y - (d * Math.sin(d3) - d4 * Math.cos(d3)));
        generalPath.lineTo(f, f2);
        generalPath2.lineTo(f, f2);
        f = (float)grappaPoint.x;
        f2 = (float)grappaPoint.y;
        generalPath.lineTo(f, f2);
        generalPath2.lineTo(f, f2);
    }

    private void updateLine(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 1;
        boolean bl = true;
        GrappaPoint[] grappaPointArray = null;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n3) {
            switch (string.charAt(n5)) {
                case 's': {
                    bl = false;
                    ++n2;
                    break;
                }
                case 'e': {
                    bl = false;
                    n2 += 2;
                    break;
                }
                case ' ': {
                    if (bl) break;
                    if (n6 == n3) {
                        n6 = n5;
                    }
                    ++n4;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            ++n5;
        }
        if (bl) {
            --n4;
        }
        if (n4 < 2 || n2 > 3) {
            throw new IllegalArgumentException("bad curve specifier string (" + string + ")");
        }
        grappaPointArray = new GrappaPoint[n4];
        n5 = 0;
        while (n5 < n3) {
            if (string.charAt(n5) != ' ') break;
            ++n5;
        }
        n4 = 0;
        if (string.charAt(n5) == 's') {
            grappaPointArray[n4++] = new GrappaPoint(string.substring(n5 + 2, n6));
            n5 = ++n6;
            while (n5 < n3) {
                if (string.charAt(n5) != ' ') break;
                ++n5;
            }
            n = n6;
            n6 = n3;
            while (n < n6) {
                if (string.charAt(n) == ' ') {
                    n6 = n;
                    break;
                }
                ++n;
            }
        }
        if (string.charAt(n5) == 'e') {
            grappaPointArray[grappaPointArray.length - 1] = new GrappaPoint(string.substring(n5 + 2, n6));
            n5 = ++n6;
            while (n5 < n3) {
                if (string.charAt(n5) != ' ') break;
                ++n5;
            }
            n = n6;
            n6 = n3;
            while (n < n6) {
                if (string.charAt(n) == ' ') {
                    n6 = n;
                    break;
                }
                ++n;
            }
        }
        if (string.charAt(n5) == 's') {
            grappaPointArray[n4++] = new GrappaPoint(string.substring(n5 + 2, n6));
            n5 = ++n6;
            while (n5 < n3) {
                if (string.charAt(n5) != ' ') break;
                ++n5;
            }
            n = n6;
            n6 = n3;
            while (n < n6) {
                if (string.charAt(n) == ' ') {
                    n6 = n;
                    break;
                }
                ++n;
            }
        }
        block13: while (n5 < n3) {
            grappaPointArray[n4++] = new GrappaPoint(string.substring(n5, n6));
            n5 = ++n6;
            while (n5 < n3) {
                if (string.charAt(n5) != ' ') break;
                ++n5;
            }
            n = n6;
            n6 = n3;
            while (n < n6) {
                if (string.charAt(n) == ' ') {
                    n6 = n;
                    continue block13;
                }
                ++n;
            }
        }
        this.updateLine(grappaPointArray, n2);
    }

    private void updateLine(GrappaPoint[] grappaPointArray, int n) {
        float f;
        float f2;
        float f3;
        float f4;
        int n2 = 0;
        int n3 = 0;
        float f5 = -2.0f;
        if ((n & 1) != 0) {
            n3 += 3;
        }
        if ((n & 2) != 0) {
            n3 += 3;
        }
        GeneralPath generalPath = new GeneralPath(this.windingRule, grappaPointArray.length + n3 + grappaPointArray.length - 1);
        GeneralPath generalPath2 = new GeneralPath(this.windingRule, grappaPointArray.length + n3 + grappaPointArray.length - 1);
        if (grappaPointArray.length < 2) {
            throw new IllegalArgumentException("need at least two supplied points");
        }
        float f6 = (float)grappaPointArray[n2].x;
        float f7 = (float)grappaPointArray[n2++].y;
        generalPath.moveTo(f6, f7);
        generalPath2.moveTo(f6 + f5, f7 + f5);
        if ((n & 1) != 0) {
            generalPath2.moveTo(f6 + f5, f7 + f5);
            this.addArrow(generalPath, generalPath2, grappaPointArray[n2 - 1], grappaPointArray[n2], 10.0, 5.0);
            f6 = (float)grappaPointArray[n2].x;
            f7 = (float)grappaPointArray[n2++].y;
            generalPath.lineTo(f6, f7);
            generalPath2.lineTo(f6 - f5, f7 - f5);
        } else {
            generalPath2.lineTo(f6 - f5, f7 - f5);
        }
        boolean bl = false;
        while (n2 < grappaPointArray.length) {
            bl = false;
            if (n2 + 3 <= grappaPointArray.length) {
                f6 = (float)grappaPointArray[n2].x;
                f7 = (float)grappaPointArray[n2++].y;
                f4 = (float)grappaPointArray[n2].x;
                f3 = (float)grappaPointArray[n2++].y;
                f2 = (float)grappaPointArray[n2].x;
                f = (float)grappaPointArray[n2++].y;
                generalPath.curveTo(f6, f7, f4, f3, f2, f);
                generalPath2.curveTo(f6 - f5, f7 - f5, f4 - f5, f3 - f5, f2 - f5, f - f5);
                continue;
            }
            bl = true;
            f6 = (float)grappaPointArray[n2].x;
            f7 = (float)grappaPointArray[n2++].y;
            generalPath.lineTo(f6, f7);
            generalPath2.lineTo(f6 - f5, f7 - f5);
        }
        if ((n & 2) != 0) {
            this.addArrow(generalPath, generalPath2, grappaPointArray[n2 - 1], grappaPointArray[n2 - 2], 10.0, 5.0);
        }
        --n2;
        while (n2 > 0) {
            if (!bl && n2 - 3 >= 0) {
                f6 = (float)grappaPointArray[--n2].x;
                f7 = (float)grappaPointArray[n2].y;
                f4 = (float)grappaPointArray[--n2].x;
                f3 = (float)grappaPointArray[n2].y;
                f2 = (float)grappaPointArray[--n2].x;
                f = (float)grappaPointArray[n2].y;
                generalPath.curveTo(f6, f7, f4, f3, f2, f);
                generalPath2.curveTo(f6 + f5, f7 + f5, f4 + f5, f3 + f5, f2 + f5, f + f5);
                continue;
            }
            bl = false;
            f6 = (float)grappaPointArray[--n2].x;
            f7 = (float)grappaPointArray[n2].y;
            generalPath.lineTo(f6, f7);
            generalPath2.lineTo(f6 + f5, f7 + f5);
        }
        this.gpts = grappaPointArray;
        this.path = generalPath;
        this.testpath = generalPath2;
        this.arrow = n;
    }

    public Object clone() {
        try {
            GrappaLine grappaLine = (GrappaLine)super.clone();
            grappaLine.path = (GeneralPath)this.path.clone();
            if (this.gpts != null) {
                grappaLine.gpts = (GrappaPoint[])this.gpts.clone();
            }
            return grappaLine;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean contains(double d, double d2) {
        return this.testpath.contains(d, d2);
    }

    public final boolean contains(double d, double d2, double d3, double d4) {
        return this.testpath.contains(d, d2, d3, d4);
    }

    public final boolean contains(Point2D point2D) {
        return this.testpath.contains(point2D);
    }

    public final boolean contains(Rectangle2D rectangle2D) {
        return this.testpath.contains(rectangle2D);
    }

    public final Rectangle getBounds() {
        return this.path.getBounds2D().getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public final PathIterator getPathIterator() {
        return this.path.getPathIterator(null);
    }

    public final PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.path.getPathIterator(affineTransform);
    }

    public final PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.path.getPathIterator(affineTransform), d);
    }

    public final boolean intersects(double d, double d2, double d3, double d4) {
        return this.testpath.intersects(d, d2, d3, d4);
    }

    public final boolean intersects(Rectangle2D rectangle2D) {
        return this.testpath.intersects(rectangle2D);
    }
}

