/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.GraphEnumeration;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaNexus;
import att.grappa.GrappaPanel;
import att.grappa.Node;
import att.grappa.Parser;
import att.grappa.Subgraph;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JViewport;

public abstract class GrappaSupport
implements GrappaConstants {
    private static final short CN = 1;
    private static final short WS = 2;
    private static final short SP = 4;
    private static final short PU = 8;
    private static final short DG = 16;
    private static final short OD = 32;
    private static final short UC = 64;
    private static final short HD = 128;
    private static final short LC = 256;
    private static final short[] ctype = new short[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 48, 48, 48, 48, 48, 48, 48, 48, 16, 16, 8, 8, 8, 8, 8, 8, 8, 192, 192, 192, 192, 192, 192, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 8, 8, 8, 8, 8, 8, 384, 384, 384, 384, 384, 384, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 8, 8, 8, 8, 1};
    private static final short ALPHA = 320;
    private static final short ALNUM = 336;
    private static final short GRAPH = 344;
    private static final short PRINT = 348;
    private static final short ODIGIT = 32;
    private static final short XDIGIT = 144;
    private static final short LOWERTOUPPER = -32;
    private static final short UPPERTOLOWER = 32;

    static boolean isalnum(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x150) != 0;
    }

    static boolean isalpha(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x140) != 0;
    }

    static boolean isascii(int n) {
        return n >= 0 && n < 128;
    }

    static boolean iscntrl(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 1) != 0;
    }

    static boolean isdigit(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x10) != 0;
    }

    static boolean isgraph(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x10) != 0;
    }

    static boolean islower(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x100) != 0;
    }

    static boolean isoctal(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x20) != 0;
    }

    static boolean isprint(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x15C) != 0;
    }

    static boolean ispunct(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 8) != 0;
    }

    static boolean isspace(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 2) != 0;
    }

    static boolean isupper(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x40) != 0;
    }

    static boolean isxdigit(int n) {
        return GrappaSupport.isascii(n) && (ctype[n] & 0x90) != 0;
    }

    static int tolower(int n) {
        return GrappaSupport.isupper(n) ? n + 32 : n;
    }

    static int toupper(int n) {
        return GrappaSupport.islower(n) ? n + -32 : n;
    }

    static String[] strsplit(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("supplied split string is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    static float[] floatArrayForTuple(String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null) {
            throw new IllegalArgumentException("supplied tuple string is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t", false);
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            fArray[n++] = Float.valueOf(stringTokenizer.nextToken()).floatValue();
        }
        return fArray;
    }

    static double[] arrayForTuple(String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null) {
            throw new IllegalArgumentException("supplied tuple string is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t", false);
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            dArray[n++] = Double.valueOf(stringTokenizer.nextToken());
        }
        return dArray;
    }

    public static int xlateDirString(String string) {
        if (string != null) {
            String string2 = GrappaSupport.canonize(string);
            if (string2.equals("forward")) {
                return 2;
            }
            if (string2.equals("back")) {
                return 1;
            }
            if (string2.equals("both")) {
                return 3;
            }
        }
        return 0;
    }

    public static String xlateDir(int n) {
        String string = null;
        string = n == 2 ? "forward" : (n == 1 ? "back" : (n == 3 ? "both" : "none"));
        return string;
    }

    public static int xlateFontStyleString(String string) {
        if (string != null) {
            String string2 = GrappaSupport.canonize(string);
            if (string2.equals("italic")) {
                return 2;
            }
            if (string2.equals("bold")) {
                return 1;
            }
            if (string2.equals("bolditalic")) {
                return 3;
            }
        }
        return 0;
    }

    public static String xlateFontStyle(int n) {
        String string = null;
        string = n == 2 ? "italic" : (n == 1 ? "bold" : (n == 3 ? "bolditalic" : "normal"));
        return string;
    }

    public static String canonize(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (Character.isLetterOrDigit(cArray[n2])) {
                cArray[n++] = Character.toLowerCase(cArray[n2]);
            }
            ++n2;
        }
        if (n == 0) {
            return "";
        }
        return new String(cArray, 0, n);
    }

    public static GrappaBox boxFromCorners(double d, double d2, double d3, double d4) {
        return GrappaSupport.boxFromCorners(null, d, d2, d3, d4);
    }

    public static GrappaBox boxFromCorners(GrappaBox grappaBox, double d, double d2, double d3, double d4) {
        if (grappaBox == null) {
            grappaBox = new GrappaBox();
        }
        grappaBox.x = d < d3 ? d : d3;
        grappaBox.y = d2 < d4 ? d2 : d4;
        grappaBox.width = d < d3 ? d3 - d : d - d3;
        grappaBox.height = d2 < d4 ? d4 - d2 : d2 - d4;
        return grappaBox;
    }

    public static Element findContainingElement(Subgraph subgraph, Point2D point2D) {
        Element element = null;
        Rectangle2D rectangle2D = subgraph.getBoundingBox();
        GrappaNexus grappaNexus = null;
        if (rectangle2D.contains(point2D)) {
            element = subgraph;
            Element element2 = null;
            Enumeration enumeration = subgraph.subgraphElements();
            while (enumeration.hasMoreElements()) {
                element2 = GrappaSupport.findContainingElement((Subgraph)enumeration.nextElement(), point2D);
                if (element2 == null) continue;
                element = element2;
            }
            enumeration = subgraph.edgeElements();
            while (enumeration.hasMoreElements()) {
                Edge edge = (Edge)enumeration.nextElement();
                grappaNexus = edge.grappaNexus;
                if (grappaNexus == null || !grappaNexus.rawBounds2D().contains(point2D) || !grappaNexus.contains(point2D)) continue;
                element = edge;
            }
            enumeration = subgraph.nodeElements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                grappaNexus = node.grappaNexus;
                if (grappaNexus == null || !grappaNexus.rawBounds2D().contains(point2D) || !grappaNexus.contains(point2D)) continue;
                element = node;
            }
        }
        return element;
    }

    public static Vector findContainedElements(Subgraph subgraph, GrappaBox grappaBox) {
        Vector<Element> vector = null;
        Rectangle2D rectangle2D = subgraph.getBoundingBox();
        GrappaNexus grappaNexus = null;
        if (grappaBox.contains(rectangle2D)) {
            return subgraph.vectorOfElements(7);
        }
        if (grappaBox.intersects(rectangle2D)) {
            Vector vector2 = null;
            Enumeration enumeration = subgraph.subgraphElements();
            while (enumeration.hasMoreElements()) {
                vector2 = GrappaSupport.findContainedElements((Subgraph)enumeration.nextElement(), grappaBox);
                if (vector2 == null) continue;
                if (vector == null) {
                    vector = new Vector<Element>();
                }
                vector.add((Element)((Object)vector2));
            }
            enumeration = subgraph.edgeElements();
            while (enumeration.hasMoreElements()) {
                Edge edge = (Edge)enumeration.nextElement();
                grappaNexus = edge.grappaNexus;
                if (grappaNexus == null || !grappaBox.contains(grappaNexus.rawBounds2D())) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(edge);
            }
            enumeration = subgraph.nodeElements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                grappaNexus = node.grappaNexus;
                if (grappaNexus == null || !grappaBox.contains(grappaNexus.rawBounds2D())) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(node);
            }
        }
        return vector;
    }

    public static void setHighlight(Element element, int n, int n2) {
        block16: {
            block15: {
                block17: {
                    if (element == null) {
                        return;
                    }
                    if (n != 0) break block15;
                    boolean bl = (element.highlight & 2) == 2;
                    element.highlight = 0;
                    if (!bl) break block16;
                    if (!element.isNode()) break block17;
                    Enumeration enumeration = ((Node)element).edgeElements();
                    while (enumeration.hasMoreElements()) {
                        ((Element)enumeration.nextElement()).highlight = 0;
                    }
                    break block16;
                }
                if (!element.isSubgraph()) break block16;
                GraphEnumeration graphEnumeration = ((Subgraph)element).elements();
                while (graphEnumeration.hasMoreElements()) {
                    ((Element)graphEnumeration.nextElement()).highlight = 0;
                }
                break block16;
            }
            element.highlight = n2 == 16 ? (element.highlight ^= n) : (n2 == 4 ? (element.highlight |= n) : (element.highlight &= ~(n &= 3)));
            if ((n & 2) == 2) {
                if (element.isNode()) {
                    if ((element.highlight & 2) == 2) {
                        Enumeration enumeration = ((Node)element).edgeElements();
                        while (enumeration.hasMoreElements()) {
                            ((Element)enumeration.nextElement()).highlight |= 2;
                        }
                    } else {
                        Enumeration enumeration = ((Node)element).edgeElements();
                        while (enumeration.hasMoreElements()) {
                            ((Element)enumeration.nextElement()).highlight &= 0xFFFFFFFD;
                        }
                    }
                } else if (element.isSubgraph()) {
                    if ((element.highlight & 2) == 2) {
                        GraphEnumeration graphEnumeration = ((Subgraph)element).elements();
                        while (graphEnumeration.hasMoreElements()) {
                            ((Element)graphEnumeration.nextElement()).highlight |= 2;
                        }
                    } else {
                        GraphEnumeration graphEnumeration = ((Subgraph)element).elements();
                        while (graphEnumeration.hasMoreElements()) {
                            ((Element)graphEnumeration.nextElement()).highlight &= 0xFFFFFFFD;
                        }
                    }
                }
            }
        }
    }

    public static boolean filterGraph(Graph graph, Object object) {
        return GrappaSupport.filterGraph(graph, object, null);
    }

    public static boolean filterGraph(Graph graph, Object object, String string) {
        StringBuffer stringBuffer;
        BufferedReader bufferedReader;
        Object object2;
        boolean bl;
        String string2;
        block33: {
            Closeable closeable;
            block32: {
                OutputStream outputStream;
                block30: {
                    if (object == null) {
                        return false;
                    }
                    outputStream = null;
                    try {
                        if (object instanceof Process) {
                            outputStream = ((Process)object).getOutputStream();
                            break block30;
                        }
                        if (object instanceof URLConnection) {
                            outputStream = ((URLConnection)object).getOutputStream();
                            break block30;
                        }
                        return false;
                    }
                    catch (IOException iOException) {
                        Grappa.displayException(iOException);
                        return false;
                    }
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                string2 = null;
                bl = true;
                graph.filterMode = true;
                try {
                    try {
                        closeable = new StringWriter();
                        graph.printGraph((Writer)closeable);
                        closeable.flush();
                        string2 = closeable.toString();
                        closeable.close();
                    }
                    catch (Exception exception) {
                        Grappa.displayException(exception);
                        boolean bl2 = false;
                        Object var10_12 = null;
                        graph.filterMode = false;
                        return bl2;
                    }
                    object2 = null;
                    graph.filterMode = false;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    graph.filterMode = false;
                    throw throwable;
                }
                try {
                    if (string != null) {
                        bufferedWriter.write(string, 0, string.length());
                        bufferedWriter.flush();
                    }
                    bufferedWriter.write(string2, 0, string2.length());
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    Grappa.displayException(exception);
                    return false;
                }
                closeable = null;
                try {
                    if (object instanceof Process) {
                        closeable = ((Process)object).getInputStream();
                        break block32;
                    }
                    if (object instanceof URLConnection) {
                        closeable = ((URLConnection)object).getInputStream();
                        break block32;
                    }
                    return false;
                }
                catch (IOException iOException) {
                    Grappa.displayException(iOException);
                    return false;
                }
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)closeable));
            stringBuffer = new StringBuffer(string2.length() + 128);
            try {
                object2 = null;
                while ((object2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append((String)object2);
                    if (!((String)object2).equals("}") && !((String)object2).equals("}\r")) {
                        stringBuffer.append(GrappaConstants.NEW_LINE);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                Grappa.displayException(exception);
                bl = false;
                if (stringBuffer.length() != 0) break block33;
                stringBuffer.append(string2);
                string2 = null;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = null;
        try {
            object2 = new StringReader(stringBuffer.toString());
        }
        catch (Exception exception) {
            Grappa.displayException(exception);
            return false;
        }
        graph.reset();
        Parser parser = new Parser((Reader)object2, graph.getErrorWriter(), graph);
        try {
            parser.parse();
        }
        catch (Exception exception) {
            Grappa.displayException(exception);
            bl = false;
            try {
                ((Reader)object2).close();
                object2 = new StringReader(string2);
            }
            catch (Exception exception2) {
                Grappa.displayException(exception2);
                return false;
            }
            parser = new Parser((Reader)object2, graph.getErrorWriter(), graph);
            try {
                parser.parse();
            }
            catch (Exception exception3) {
                Grappa.displayException(exception3);
                return false;
            }
        }
        return bl;
    }

    public static boolean centerPanel(Point2D point2D, GrappaPanel grappaPanel) {
        if (point2D == null || grappaPanel == null) {
            return false;
        }
        if (!grappaPanel.getSubgraph().getBoundingBox().contains(point2D.getX(), point2D.getY())) {
            return false;
        }
        Container container = grappaPanel.getParent();
        if (!(container instanceof JViewport)) {
            Grappa.displayException(new RuntimeException("the parent of the supplied GrappaPanel is not a JViewport"));
            return false;
        }
        JViewport jViewport = (JViewport)container;
        Rectangle rectangle = grappaPanel.getBounds();
        Dimension dimension = jViewport.getExtentSize();
        AffineTransform affineTransform = grappaPanel.getTransform();
        if (affineTransform == null) {
            return false;
        }
        Point2D point2D2 = affineTransform.transform(point2D, null);
        Rectangle2D rectangle2D = new Rectangle2D.Double(point2D2.getX() + (double)rectangle.x - (double)dimension.width / 2.0, point2D2.getY() + (double)rectangle.y - (double)dimension.height / 2.0, dimension.width, dimension.height);
        rectangle2D = rectangle2D.createIntersection(rectangle);
        jViewport.scrollRectToVisible(rectangle2D.getBounds());
        return true;
    }
}

