/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JToggleButton;

public class BooleanPropertyModel
extends JToggleButton.ToggleButtonModel
implements PropertyChangeListener {
    private PropertyDescriptor propertyDescriptor;
    private Object propertyHolder;

    public BooleanPropertyModel(String string, Object object, PropertyChangeSupport propertyChangeSupport) {
        PropertyDescriptor propertyDescriptor;
        try {
            propertyDescriptor = new PropertyDescriptor(string, object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException("Exception thrown: " + introspectionException);
        }
        this.propertyHolder = object;
        this.setSelected(this.getValue(propertyDescriptor));
        this.propertyDescriptor = propertyDescriptor;
        propertyChangeSupport.addPropertyChangeListener(string, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        if (this.isSelected() != bl) {
            this.setSelected(bl);
        }
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.propertyDescriptor != null) {
            Method method = this.propertyDescriptor.getWriteMethod();
            Object[] objectArray = new Object[]{new Boolean(bl)};
            try {
                method.invoke(this.propertyHolder, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Exception thrown: " + illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Exception thrown: " + invocationTargetException.getTargetException());
            }
        }
    }

    private boolean getValue(PropertyDescriptor propertyDescriptor) {
        Boolean bl;
        Method method = propertyDescriptor.getReadMethod();
        Object[] objectArray = new Object[]{};
        try {
            bl = (Boolean)method.invoke(this.propertyHolder, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Exception thrown: " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Exception thrown: " + invocationTargetException);
        }
        return bl;
    }
}

