/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import att.grappa.Element;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.viewers.AbstractViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewletType;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class ChartBarViewletType
extends BoundsViewletType {
    double xScale = 1.0;
    double yScale = 1.0;
    final Color DEFAULT_COLOR = Color.blue;
    Color color;

    public ChartBarViewletType(String string) {
        super(string);
    }

    @Override
    public ViewletData build() {
        return new Data();
    }

    @Override
    public String getDescription() {
        return "ChartBar viewlet";
    }

    void fixBounds(ViewletDataStore viewletDataStore) {
        Data data;
        double d = 1.0;
        for (List list : viewletDataStore.getEntireViewletRange()) {
            data = (Data)viewletDataStore.getViewletDataAt(list);
            if (!(data.absoluteMax > d)) continue;
            d = data.absoluteMax;
        }
        for (List list : viewletDataStore.getEntireViewletRange()) {
            data = (Data)viewletDataStore.getViewletDataAt(list);
            data.absoluteMin = 0.0;
            data.absoluteMax = d;
            viewletDataStore.setViewletDataAt(list, data);
        }
    }

    @Override
    public void startBuild(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list) {
        super.startBuild(viewer, viewletDataStore, viewletRange, list);
        this.fixBounds(viewletDataStore);
    }

    @Override
    public Class getCustomRendererClass() {
        return BarRenderer.class;
    }

    public void setXScale(double d) {
        this.xScale = d;
    }

    public void setYScale(double d) {
        this.yScale = d;
    }

    public void setFillColor(Color color) {
        this.color = color;
    }

    protected int calcIndex(List list, List list2) {
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Integer n3 = (Integer)list.get(i);
            Integer n4 = (Integer)list2.get(i);
            n2 += n4 * n;
            n *= n3 + 1;
        }
        return n2;
    }

    @Override
    public void customizeElement(ViewletDataStore viewletDataStore, List list, Element element) {
        if (element == null) {
            return;
        }
        Data data = (Data)viewletDataStore.getViewletDataAt(list);
        data.vertical = true;
        List list2 = viewletDataStore.getSize();
        int n = this.calcIndex(list2, list);
        double d = 1.0 * this.xScale / 72.0;
        double d2 = (data.absoluteMax - data.absoluteMin) * this.yScale / 72.0;
        double d3 = ((double)n + 0.5) * this.xScale;
        double d4 = -((data.absoluteMax - data.absoluteMin) * this.yScale / 2.0);
        element.setAttribute("pos", (Object)(d3 + "," + d4));
        element.setAttribute("width", (Object)("" + d));
        element.setAttribute("height", (Object)("" + d2));
        element.getGrappaNexus().updateShape();
        element.setAttribute("shape", (Object)new Integer(27));
        element.setAttribute("custom", (Object)this.getCustomRendererClass().getName());
        Color color = this.color == null ? this.DEFAULT_COLOR : this.color;
        element.setAttribute("style", (Object)"filled");
        if (data.getHoldsOnUpdates()) {
            element.setAttribute("color", (Object)color.darker());
        } else {
            element.setAttribute("color", (Object)color);
        }
        element.object = data;
        element.setAttribute("label", (Object)"");
        element.getGrappaNexus().updateText();
        element.getGrappaNexus().updateShape();
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        LinkedList<ViewletAction> linkedList = new LinkedList<ViewletAction>();
        if (viewletRange != null & !viewletRange.isEmpty()) {
            linkedList.add(new AbstractViewletType.ToggleHoldAction(this).createCompoundAction(viewletDataStore, viewletRange));
        }
        if (viewletRange != null & viewletRange.size() == 1) {
            List list = (List)viewletRange.iterator().next();
            linkedList.add(new BoundsViewletType.DisplayBoundsInDetailAction(viewletDataStore, list));
        }
        return linkedList;
    }

    @Override
    public double getMin(ViewletDataStore viewletDataStore, List list) {
        return ((Data)viewletDataStore.getViewletDataAt((List)list)).min;
    }

    @Override
    public double getMax(ViewletDataStore viewletDataStore, List list) {
        return ((Data)viewletDataStore.getViewletDataAt((List)list)).max;
    }

    public static class PointRenderer
    extends BoundsViewletType.Renderer {
        public PointRenderer(Element element, double d, double d2, double d3, double d4) {
            super(element, d, d2, d3, d4);
        }

        @Override
        public void configure(Rectangle2D rectangle2D, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
            float[][] fArrayArray;
            float f;
            float f2;
            float f3;
            float f4;
            if (bl) {
                f4 = (float)rectangle2D.getMinY();
                f3 = (float)rectangle2D.getMaxY();
            } else {
                f3 = (float)rectangle2D.getMinX();
                f4 = (float)rectangle2D.getMaxX();
            }
            if (d2 == d) {
                d2 += 1.0;
            }
            float f5 = (f4 - f3) / (float)(d2 - d);
            float f6 = f3 + (float)d5 * f5;
            float f7 = f3 + (float)d6 * f5;
            if (bl) {
                f2 = (float)rectangle2D.getMinX();
                f = (float)rectangle2D.getMaxX();
            } else {
                f2 = (float)rectangle2D.getMinY();
                f = (float)rectangle2D.getMaxY();
            }
            float f8 = (f - f2) / 16.0f;
            float f9 = f2 + 8.0f * f8;
            float f10 = f9 - 4.0f * f8;
            float f11 = f9 + 4.0f * f8;
            float[][] fArrayArray2 = bl ? (fArrayArray = new float[][]{{f10, f6}, {f10, f7}, {f11, f7}, {f11, f6}}) : (fArrayArray = new float[][]{{f6, f10}, {f7, f10}, {f7, f11}, {f6, f11}});
            this.path.moveTo(fArrayArray2[0][0], fArrayArray2[0][1]);
            for (int i = 1; i < fArrayArray2.length; ++i) {
                this.path.lineTo(fArrayArray2[i][0], fArrayArray2[i][1]);
            }
            this.path.closePath();
        }
    }

    public static class BarRenderer
    extends BoundsViewletType.Renderer {
        public BarRenderer(Element element, double d, double d2, double d3, double d4) {
            super(element, d, d2, d3, d4);
        }

        @Override
        public void configure(Rectangle2D rectangle2D, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
            float[][] fArrayArray;
            float f;
            float f2;
            float f3;
            float f4;
            if (bl) {
                f4 = (float)rectangle2D.getMinY();
                f3 = (float)rectangle2D.getMaxY();
            } else {
                f3 = (float)rectangle2D.getMinX();
                f4 = (float)rectangle2D.getMaxX();
            }
            if (d2 == d) {
                d2 += 1.0;
            }
            float f5 = (f4 - f3) / (float)(d2 - d);
            float f6 = f3 + (float)d3 * f5;
            float f7 = f3 + (float)d5 * f5;
            float f8 = f3 + (float)d6 * f5;
            float f9 = f3 + (float)d4 * f5;
            if (bl) {
                f2 = (float)rectangle2D.getMinX();
                f = (float)rectangle2D.getMaxX();
            } else {
                f2 = (float)rectangle2D.getMinY();
                f = (float)rectangle2D.getMaxY();
            }
            float f10 = (f - f2) / 16.0f;
            float f11 = f2 + 8.0f * f10;
            float f12 = f11 - 4.0f * f10;
            float f13 = f11 - 1.0f * f10;
            float f14 = f11 + 1.0f * f10;
            float f15 = f11 + 4.0f * f10;
            float[][] fArrayArray2 = bl ? (fArrayArray = new float[][]{{f2, f3}, {f2, f7}, {f12, f7}, {f12, f8}, {f15, f8}, {f15, f7}, {f, f7}, {f, f3}}) : (fArrayArray = new float[][]{{f3, f2}, {f7, f2}, {f7, f12}, {f8, f12}, {f8, f15}, {f7, f15}, {f7, f}, {f3, f}});
            this.path.moveTo(fArrayArray2[0][0], fArrayArray2[0][1]);
            for (int i = 1; i < fArrayArray2.length; ++i) {
                this.path.lineTo(fArrayArray2[i][0], fArrayArray2[i][1]);
            }
            this.path.closePath();
        }
    }

    public static class Data
    extends BoundsViewletType.Data {
        @Override
        public String toString() {
            return Double.toString(this.max);
        }
    }
}

