/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.CompoundTerm;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class EXDROutputStream
extends FilterOutputStream {
    DataOutputStream out;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private HashMap stringReferenceMap = null;
    private boolean compressStrings = false;

    public EXDROutputStream(OutputStream outputStream) {
        super(outputStream);
        this.out = new DataOutputStream(this.buf);
    }

    public EXDROutputStream(OutputStream outputStream, boolean bl) {
        this(outputStream);
        this.compressStrings = bl;
    }

    private void writeVersion() throws IOException {
        this.out.writeByte(86);
        this.out.writeByte(2);
    }

    public synchronized void write(Object object) throws IOException {
        this.writeVersion();
        if (this.compressStrings) {
            this.out.writeByte(67);
            this.stringReferenceMap = new HashMap();
        } else {
            this.stringReferenceMap = null;
        }
        this.writeSub(object);
        this.flush_buffer();
        this.stringReferenceMap = null;
    }

    private void flush_buffer() throws IOException {
        ((FilterOutputStream)this).out.write(this.buf.toByteArray());
        this.buf.reset();
    }

    void writeSub(Object object) throws IOException {
        if (object == null) {
            this.writeVar();
        } else if (object instanceof Collection) {
            this.writeList((Collection)object);
        } else if (object instanceof CompoundTerm) {
            this.writeStructure((CompoundTerm)object);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Float) {
            this.writeDouble(((Float)object).doubleValue());
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else {
            throw new IllegalArgumentException("Attempt to write EXDR for non-recognised class " + object.getClass().getName());
        }
    }

    void writeDouble(double d) throws IOException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("NaN cannot be written in EXDR format.");
        }
        this.out.writeByte(68);
        this.out.writeDouble(d);
    }

    void writeString(String string) throws IOException {
        int n;
        boolean bl = false;
        if (this.stringReferenceMap != null) {
            Integer n2 = (Integer)this.stringReferenceMap.get(string);
            if (n2 == null) {
                this.stringReferenceMap.put(string, new Integer(this.stringReferenceMap.size()));
                this.out.writeByte(83);
                n = string.length();
            } else {
                this.out.writeByte(82);
                n = n2;
                bl = true;
            }
        } else {
            this.out.writeByte(83);
            n = string.length();
        }
        if (n == (byte)n) {
            this.out.writeByte(n | 0x80);
        } else {
            this.out.writeInt(n);
        }
        if (!bl) {
            this.out.writeBytes(string);
        }
    }

    void writeInt(int n) throws IOException {
        if (n == (byte)n) {
            this.out.writeByte(66);
            this.out.writeByte((byte)n);
        } else {
            this.out.writeByte(73);
            this.out.writeInt(n);
        }
    }

    void writeLong(long l) throws IOException {
        if (l == (long)((int)l)) {
            this.writeInt((int)l);
        } else {
            this.out.writeByte(74);
            this.out.writeLong(l);
        }
    }

    void writeVar() throws IOException {
        this.out.writeByte(95);
    }

    void writeStructure(CompoundTerm compoundTerm) throws IOException {
        this.out.writeByte(70);
        this.out.writeInt(compoundTerm.arity());
        this.writeString(compoundTerm.functor());
        for (int i = 1; i <= compoundTerm.arity(); ++i) {
            this.writeSub(compoundTerm.arg(i));
        }
    }

    void writeList(Collection collection) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.out.writeByte(91);
            this.writeSub(iterator.next());
        }
        this.out.writeByte(93);
    }

    @Override
    public void flush() throws IOException {
        this.flush_buffer();
        ((FilterOutputStream)this).out.flush();
    }

    public void enableCompression(boolean bl) {
        this.compressStrings = bl;
    }
}

