/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Element;
import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Edge
extends Element {
    public static final String defaultNamePrefix = "E";
    private Node headNode;
    private String headPortId = null;
    private Node tailNode;
    private String tailPortId = null;
    private String key = null;
    int direction = 0;

    public Edge(Subgraph subgraph, Node node, Node node2) {
        this(subgraph, node, null, node2, null, null, null);
    }

    public Edge(Subgraph subgraph, Node node, String string, Node node2, String string2) {
        this(subgraph, node, string, node2, string2, null, null);
    }

    public Edge(Subgraph subgraph, Node node, String string, Node node2, String string2, String string3) throws RuntimeException {
        this(subgraph, node, string, node2, string2, string3, null);
    }

    public Edge(Subgraph subgraph, Node node, Node node2, String string) throws RuntimeException {
        this(subgraph, node, null, node2, null, null, string);
    }

    public Edge(Subgraph subgraph, Node node, String string, Node object, String string2, String string3, String string4) throws RuntimeException {
        super(2, subgraph);
        Object object2;
        Object object3;
        boolean bl = subgraph.getGraph().isDirected();
        this.direction = bl ? 2 : 0;
        if (subgraph.getGraph().isStrict()) {
            if (node == object) {
                throw new RuntimeException("cannot create self-looping edge in a strict graph (" + node.getName() + (bl ? "->" : "--") + ((Element)object).getName() + ")");
            }
            object3 = Edge.findEdgesByEnds(node, (Node)object);
            if (object3.hasMoreElements()) {
                if (!bl) {
                    throw new RuntimeException("cannot create multiple edges between the same nodes in a strict graph");
                }
                object2 = null;
                while (object3.hasMoreElements()) {
                    object2 = (Edge)object3.nextElement();
                    if (((Edge)object2).getHead() != object || ((Edge)object2).getTail() != node) continue;
                    throw new RuntimeException("cannot create multiple edges between the same nodes in the same direction in a strict directed graph");
                }
            }
        }
        if (!bl && node.getId() > ((Element)object).getId()) {
            object3 = node;
            node = object;
            object = object3;
            object2 = string;
            string = string2;
            string2 = object2;
        }
        this.tailNode = node;
        if (string != null) {
            this.tailPortId = new String(string);
        }
        this.headNode = object;
        if (string2 != null) {
            this.headPortId = new String(string2);
        }
        if (string4 != null) {
            if (subgraph.getGraph().findEdgeByName(string4) != null) {
                throw new RuntimeException("cannot create edge with duplicate name '" + string4 + "'");
            }
            this.name = string4;
            subgraph.addEdge(this);
            if (string3 == null) {
                string3 = string4;
            }
        } else {
            this.setName();
        }
        this.key = string3 == null ? (string2 != null && string != null ? string + "::" + string2 : (string2 != null ? "::" + string2 : (string != null ? string + "::" : string4))) : string3;
        if (this.key != null && Edge.findEdgeByKey(this.tailNode, this.headNode, this.key) != null) {
            subgraph.removeEdge(this.name);
            throw new RuntimeException("cannot create duplicate edge (" + this.tailNode.getName() + (bl ? "->" : "--") + this.headNode.getName() + ") with key '" + this.key + "'");
        }
        this.tailNode.addEdge(this, false);
        this.headNode.addEdge(this, true);
        this.edgeAttrsOfInterest();
    }

    private void edgeAttrsOfInterest() {
        this.attrOfInterest("pos");
        this.attrOfInterest("dir");
        this.attrOfInterest("lp");
        this.attrOfInterest("style");
    }

    public static Edge findEdgeByKey(Node node, Node node2, String string) {
        if (node == null || node2 == null || string == null) {
            return null;
        }
        return node.findOutEdgeByKey(node2, string);
    }

    public boolean isEdge() {
        return true;
    }

    public int getType() {
        return 2;
    }

    void setName() {
        String string = this.name;
        do {
            this.name = defaultNamePrefix + this.getId() + "_" + System.currentTimeMillis();
        } while (this.getGraph().findEdgeByName(this.name) != null);
        if (string != null) {
            this.getSubgraph().removeEdge(string);
        }
        this.getSubgraph().addEdge(this);
        this.canonName = null;
    }

    public String getKey() {
        return this.key;
    }

    public Node getHead() {
        return this.headNode;
    }

    public String getHeadPortId() {
        return this.headPortId;
    }

    public Node getTail() {
        return this.tailNode;
    }

    public String getTailPortId() {
        return this.tailPortId;
    }

    public String toString() {
        if (this.canonName == null) {
            String string = null;
            String string2 = null;
            string = this.tailPortId == null ? this.tailNode.toString() : this.tailNode.toString() + ":" + Element.canonString(this.tailPortId);
            string2 = this.headPortId == null ? this.headNode.toString() : this.headNode.toString() + ":" + Element.canonString(this.headPortId);
            this.canonName = this.getGraph().isDirected() ? string + " -> " + string2 : string + " -- " + string2;
        }
        return this.canonName;
    }

    public void printEdge(PrintWriter printWriter) {
        this.printElement(printWriter);
    }

    public boolean goesForward() {
        return this.direction != 1;
    }

    public boolean goesReverse() {
        return this.direction != 2;
    }

    public static int attributeType(String string) {
        int n = -1;
        if (string != null) {
            int n2 = string.hashCode();
            if (n2 == GrappaConstants.POS_HASH && string.equals("pos")) {
                n = 8;
            } else if (n2 == GrappaConstants.MINLEN_HASH && string.equals("minlen")) {
                n = 7;
            } else if (n2 == GrappaConstants.DIR_HASH && string.equals("dir")) {
                n = 3;
            } else if (n2 == GrappaConstants.WEIGHT_HASH && string.equals("weight")) {
                n = 4;
            } else {
                return Element.attributeType(string);
            }
        }
        return n;
    }

    public static Enumeration findEdgesByEnds(Node node, Node node2) {
        if (node == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return new Enumerator(node, node2);
    }

    static class Enumerator
    implements Enumeration {
        Node node1 = null;
        Node node2 = null;
        Edge next = null;
        Enumeration outEdges = null;
        Enumeration inEdges = null;

        Enumerator(Node node, Node node2) {
            this.node1 = node;
            this.node2 = node2;
            if (node != null) {
                this.outEdges = node.outEdgeElements();
                this.inEdges = node.inEdgeElements();
                this.next = this.getNext();
            }
        }

        private Edge getNext() {
            Edge edge = null;
            if (this.outEdges != null) {
                while (this.outEdges.hasMoreElements()) {
                    edge = (Edge)this.outEdges.nextElement();
                    if (this.node2 != null && edge.getHead() != this.node2) continue;
                    return edge;
                }
                this.outEdges = null;
            }
            if (this.inEdges != null) {
                while (this.inEdges.hasMoreElements()) {
                    edge = (Edge)this.inEdges.nextElement();
                    if (this.node2 != null && edge.getTail() != this.node2) continue;
                    return edge;
                }
                this.inEdges = null;
            }
            return null;
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException("Node$Enumerator");
            }
            Edge edge = this.next;
            this.next = this.getNext();
            return edge;
        }
    }
}

