/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Graph;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaNexus;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Element
implements GrappaConstants {
    private Graph graph = null;
    private Subgraph subgraph = null;
    long visastamp = -1L;
    private boolean deleteCalled = false;
    private boolean busy = false;
    private static Hashtable userAttributeTypeMap = null;
    public Object object;
    public boolean visible = true;
    public int linewidth = 0;
    public static boolean usePrintList = false;
    public int counter = 0;
    public int highlight = 0;
    private Long idKey = null;
    String name = null;
    Hashtable attributes = null;
    Hashtable attrsOfInterest = null;
    GrappaNexus grappaNexus = null;
    public boolean printAllAttributes = false;
    public boolean printDefaultAttributes = false;
    String canonName = null;
    private double patchSize = 0.0;
    private Rectangle2D.Double patch = null;

    protected Element() {
    }

    protected Element(int n, Subgraph subgraph) {
        this.setSubgraph(subgraph);
        this.setGraph(subgraph.getGraph());
        this.setIdKey(n);
        this.getGraph().addIdMapping(this);
        this.elementAttrsOfInterest();
    }

    private void elementAttrsOfInterest() {
        this.attrOfInterest("color");
        this.attrOfInterest("fontcolor");
        this.attrOfInterest("fontname");
        this.attrOfInterest("fontsize");
        this.attrOfInterest("fontstyle");
        this.attrOfInterest("label");
    }

    public abstract int getType();

    public boolean isNode() {
        return false;
    }

    public boolean isEdge() {
        return false;
    }

    public boolean isSubgraph() {
        return false;
    }

    abstract void setName();

    public String getName() {
        return this.name;
    }

    boolean reserve() {
        return this.setReserved(true, false);
    }

    void release() {
        this.setReserved(false, false);
    }

    boolean setDelete(boolean bl) {
        return this.setReserved(bl, true);
    }

    private synchronized boolean setReserved(boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                this.deleteCalled = true;
                if (this.busy) {
                    return false;
                }
                this.busy = true;
                return true;
            }
            this.busy = false;
            this.deleteCalled = false;
            return true;
        }
        if (bl) {
            if (this.deleteCalled) {
                return false;
            }
            this.busy = true;
            return true;
        }
        if (!this.deleteCalled) {
            this.busy = false;
        } else {
            this.deleteCalled = false;
            this.busy = false;
            this.delete();
        }
        return true;
    }

    protected void attrOfInterest(String string) {
        Attribute attribute;
        if (string == null || this.isOfInterest(string)) {
            return;
        }
        if (this.attrsOfInterest == null) {
            this.attrsOfInterest = new Hashtable();
        }
        this.attrsOfInterest.put(string, string);
        if (this.grappaNexus != null && (attribute = this.getAttribute(string)) != null) {
            attribute.addObserver(this.grappaNexus);
        }
    }

    protected void attrNotOfInterest(String string) {
        Attribute attribute;
        if (string == null || !this.isOfInterest(string)) {
            return;
        }
        if (this.grappaNexus != null && (attribute = this.getAttribute(string)) != null) {
            attribute.deleteObserver(this.grappaNexus);
        }
        this.attrsOfInterest.remove(string);
    }

    public Enumeration listAttrsOfInterest() {
        if (this.attrsOfInterest == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.attrsOfInterest.elements();
    }

    public boolean isOfInterest(String string) {
        if (string == null || this.attrsOfInterest == null) {
            return false;
        }
        return this.attrsOfInterest.contains(string);
    }

    public Object setAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        return this.setAttribute(attribute.getName(), attribute.getValue());
    }

    public Object setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        if (string == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Object object2 = null;
        Attribute attribute = this.getLocalAttribute(string);
        if (attribute == null) {
            if (object == null) {
                return null;
            }
            if (object instanceof String && ((String)object).trim().length() == 0 && Attribute.attributeType(this.getType(), string) != 12) {
                return null;
            }
            attribute = new Attribute(this.getType(), string, object);
            this.attributes.put(string, attribute);
            if (this.grappaNexus != null && this.isOfInterest(string)) {
                attribute.addObserver(this.grappaNexus);
            }
        } else {
            object2 = attribute.getValue();
            if (object == null) {
                this.removeAttribute(string);
                return object2;
            }
            if (object instanceof String && ((String)object).trim().length() == 0 && Attribute.attributeType(this.getType(), string) != 12) {
                this.removeAttribute(string);
                return object2;
            }
            attribute.setValue(object);
        }
        if (attribute.hasChanged()) {
            attribute.notifyObservers(new Long(System.currentTimeMillis()));
        }
        return object2;
    }

    private Attribute removeAttribute(String string) {
        if (string == null) {
            return null;
        }
        Attribute attribute = this.getDefaultAttribute(string);
        Attribute attribute2 = null;
        if (this.attributes != null) {
            attribute2 = (Attribute)this.attributes.remove(string);
        }
        if (attribute2 == null) {
            return attribute;
        }
        if (attribute == null) {
            attribute2.setValue("");
        }
        attribute2.setChanged();
        attribute2.notifyObservers(new Object[]{attribute, new Long(System.currentTimeMillis())});
        return attribute;
    }

    public Object setDefaultAttribute(String string, Object object) {
        return this.setDefaultAttribute(this.getType(), string, object);
    }

    public Object setDefaultAttribute(int n, String string, Object object) {
        Object object2 = null;
        Subgraph subgraph = this.getSubgraph();
        switch (n) {
            case 1: {
                object2 = subgraph.setNodeAttribute(string, object);
                break;
            }
            case 2: {
                object2 = subgraph.setEdgeAttribute(string, object);
                break;
            }
            case 4: {
                if (subgraph == null) break;
                object2 = subgraph.setAttribute(string, object);
            }
        }
        return object2;
    }

    public Object setDefaultAttribute(Attribute attribute) {
        return this.setDefaultAttribute(this.getType(), attribute);
    }

    public Object setDefaultAttribute(int n, Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        Object object = null;
        Subgraph subgraph = this.getSubgraph();
        switch (n) {
            case 1: {
                object = subgraph.setNodeAttribute(attribute);
                break;
            }
            case 2: {
                object = subgraph.setEdgeAttribute(attribute);
                break;
            }
            case 4: {
                if (subgraph == null) break;
                object = subgraph.setAttribute(attribute);
            }
        }
        return object;
    }

    public Enumeration getLocalAttributeKeys() {
        if (this.attributes == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.attributes.keys();
    }

    public Enumeration getLocalAttributePairs() {
        if (this.attributes == null) {
            return Grappa.emptyEnumeration.elements();
        }
        return this.attributes.elements();
    }

    public Enumeration getAttributePairs() {
        Hashtable<String, Attribute> hashtable = null;
        Attribute attribute = null;
        Enumeration enumeration = this.getLocalAttributePairs();
        if (enumeration.hasMoreElements()) {
            hashtable = new Hashtable<String, Attribute>(32);
        }
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            hashtable.put(attribute.getName(), attribute);
        }
        switch (this.getType()) {
            case 1: {
                enumeration = this.getSubgraph().getNodeAttributePairs();
                break;
            }
            case 2: {
                enumeration = this.getSubgraph().getEdgeAttributePairs();
                break;
            }
            case 4: {
                enumeration = this.getLocalAttributePairs();
            }
        }
        if (hashtable != null) {
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                if (hashtable.containsKey(attribute.getName())) continue;
                hashtable.put(attribute.getName(), attribute);
            }
            return hashtable.elements();
        }
        return enumeration;
    }

    public Attribute getLocalAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attribute)this.attributes.get(string);
    }

    public Attribute getThisAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        Attribute attribute = (Attribute)this.attributes.get(string);
        if (attribute == null) {
            return null;
        }
        Subgraph subgraph = this.getSubgraph();
        if (subgraph == null) {
            return attribute;
        }
        if (attribute == subgraph.getAttribute(string)) {
            return null;
        }
        return attribute;
    }

    public Object getThisAttributeValue(String string) {
        Attribute attribute = this.getThisAttribute(string);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public Attribute getDefaultAttribute(int n, String string) {
        Attribute attribute = null;
        Subgraph subgraph = null;
        subgraph = this.isSubgraph() ? (Subgraph)this : this.getSubgraph();
        if (subgraph == null) {
            return Graph.getGlobalAttribute(n, string);
        }
        switch (n) {
            case 1: {
                attribute = subgraph.getNodeAttribute(string);
                break;
            }
            case 2: {
                attribute = subgraph.getEdgeAttribute(string);
                break;
            }
            case 4: {
                attribute = subgraph.getLocalAttribute(string);
            }
        }
        return attribute;
    }

    public Attribute getDefaultAttribute(String string) {
        return this.getDefaultAttribute(this.getType(), string);
    }

    public Attribute getAttribute(String string) {
        Attribute attribute = null;
        attribute = this.getLocalAttribute(string);
        if (attribute == null) {
            attribute = this.getDefaultAttribute(string);
        }
        return attribute;
    }

    public Object getAttributeValue(String string) {
        Object object = null;
        Attribute attribute = this.getAttribute(string);
        if (attribute != null) {
            object = attribute.getValue();
        }
        return object;
    }

    public boolean hasAttributeForKey(String string) {
        return this.getAttribute(string) != null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Subgraph getSubgraph() {
        return this.subgraph;
    }

    void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setSubgraph(Subgraph subgraph) {
        if (this.subgraph != null && this.subgraph != subgraph) {
            switch (this.getType()) {
                case 1: {
                    this.subgraph.removeNode(((Node)this).getName());
                    subgraph.addNode((Node)this);
                    break;
                }
                case 2: {
                    this.subgraph.removeEdge(((Edge)this).getName());
                    subgraph.addEdge((Edge)this);
                    break;
                }
                case 4: {
                    this.subgraph.removeSubgraph(((Subgraph)this).getName());
                    subgraph.addSubgraph((Subgraph)this);
                }
            }
        }
        if (this.subgraph != subgraph) {
            if (this.subgraph != null && this.subgraph.grappaNexus != null) {
                this.subgraph.clearBBox();
            }
            if (subgraph != null && subgraph.grappaNexus != null) {
                subgraph.clearBBox();
            }
        }
        this.subgraph = subgraph;
    }

    protected void clearBBox() {
        if (this.grappaNexus != null) {
            this.grappaNexus.bbox = null;
        }
        Subgraph subgraph = this.getSubgraph();
        while (subgraph != null) {
            if (subgraph.grappaNexus != null) {
                subgraph.grappaNexus.bbox = null;
            }
            subgraph = subgraph.getSubgraph();
        }
    }

    public int getId() {
        return (int)(this.getIdKey() >> 3);
    }

    public Long getIdKey() {
        return this.idKey;
    }

    protected void setIdKey(int n) {
        this.idKey = Graph.idMapKey(n, this.getGraph().nextId(n));
    }

    public void printElement(PrintWriter printWriter) {
        String string = new String(this.getGraph().getIndent());
        if (Grappa.printVisibleOnly && (!this.visible || this.grappaNexus.style.invis)) {
            return;
        }
        printWriter.print(string + this.toString());
        this.getGraph().incrementIndent();
        this.printAttributes(printWriter, string);
        this.getGraph().decrementIndent();
        printWriter.println();
    }

    private void printAttributes(PrintWriter printWriter, String string) {
        String string2 = new String(this.getGraph().getIndent());
        String string3 = " [";
        String string4 = GrappaConstants.NEW_LINE + string + "];";
        boolean bl = true;
        Hashtable hashtable = null;
        if (Grappa.usePrintList || usePrintList) {
            hashtable = (Hashtable)this.getAttributeValue("printlist");
        }
        Enumeration enumeration = null;
        if (Grappa.elementPrintAllAttributes || this.printAllAttributes) {
            enumeration = this.getAttributePairs();
        } else if (this.attributes != null && !this.attributes.isEmpty()) {
            enumeration = this.attributes.elements();
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                String string5 = attribute.getName();
                if (hashtable != null && hashtable.get(string5) == null || attribute == null || !Grappa.elementPrintAllAttributes && !this.printAllAttributes && attribute.equalsValue(this.getDefaultAttribute(string5))) continue;
                if (bl) {
                    bl = false;
                    printWriter.println(string3);
                } else {
                    printWriter.println(",");
                }
                printWriter.print(string2 + string5 + " = " + Element.canonString(attribute.getStringValue()));
            }
            if (this.getGraph().filterMode && this.isEdge()) {
                if (bl) {
                    bl = false;
                    printWriter.println(string3);
                } else {
                    printWriter.println(",");
                }
                printWriter.print(string2 + "__nAmE__ = " + Element.canonString(this.getName()));
            }
        }
        if (!bl) {
            printWriter.print(string4);
        }
    }

    public String toString() {
        if (this.canonName == null) {
            this.canonName = Element.canonString(this.name);
        }
        return this.canonName;
    }

    public static String canonString(String string) {
        String string2;
        int n;
        if (string == null || (n = string.length()) == 0) {
            return "\"\"";
        }
        StringBuffer stringBuffer = new StringBuffer(n + 8);
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\"') {
                stringBuffer.append('\\');
                bl = true;
            } else if (!bl && (cArray[n2] < '0' || cArray[n2] > '9' && cArray[n2] < 'A' || cArray[n2] > 'Z' && cArray[n2] < 'a' && cArray[n2] != '_' || cArray[n2] > 'z')) {
                bl = true;
            }
            stringBuffer.append(cArray[n2]);
            ++n2;
        }
        if (!bl && n <= 8 && ((string2 = string.toLowerCase()).equals("node") || string2.equals("edge") || string2.equals("graph") || string2.equals("digraph") || string2.equals("subgraph") || string2.equals("strict"))) {
            bl = true;
        }
        if (bl) {
            stringBuffer.append('\"');
            stringBuffer.insert(0, '\"');
        }
        return stringBuffer.toString();
    }

    public static final String typeString(int n, boolean bl) {
        String string = null;
        switch (n) {
            case 1: {
                string = bl ? "Node" : "node";
                break;
            }
            case 2: {
                string = bl ? "Edge" : "edge";
                break;
            }
            case 4: {
                string = bl ? "Subgraph" : "subgraph";
                break;
            }
            case 8: {
                string = bl ? "Grappa" : "grappa";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static String canonValue(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (Character.isUpperCase(cArray[n2])) {
                cArray[n++] = Character.toLowerCase(cArray[n2]);
                bl = false;
            } else if (Character.isLowerCase(cArray[n2])) {
                cArray[n++] = cArray[n2];
                bl = false;
            } else if (Character.isDigit(cArray[n2])) {
                cArray[n++] = cArray[n2];
            }
            ++n2;
        }
        if (n == 0 || bl) {
            return null;
        }
        return new String(cArray, 0, n);
    }

    boolean deleteCalled() {
        return this.deleteCalled;
    }

    public final boolean delete() {
        if (!this.setDelete(true)) {
            return false;
        }
        String string = this.getName();
        Enumeration enumeration = null;
        if (this.attributes != null && this.grappaNexus != null) {
            enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                ((Attribute)enumeration.nextElement()).deleteObserver(this.grappaNexus);
            }
        }
        Element element = null;
        Subgraph subgraph = null;
        if (this.grappaNexus != null) {
            this.grappaNexus.bbox = null;
        }
        subgraph = this.getSubgraph();
        while (subgraph != null) {
            if (subgraph.grappaNexus != null) {
                subgraph.grappaNexus.bbox = null;
            }
            subgraph = subgraph.getSubgraph();
        }
        switch (this.getType()) {
            case 1: {
                enumeration = ((Node)this).edgeElements();
                while (enumeration.hasMoreElements()) {
                    element = (Element)enumeration.nextElement();
                    subgraph = element.getSubgraph();
                    while (subgraph != null) {
                        if (subgraph.grappaNexus != null) {
                            subgraph.grappaNexus.bbox = null;
                        }
                        subgraph = subgraph.getSubgraph();
                    }
                    ((Edge)element).delete();
                }
                this.getSubgraph().removeNode(string);
                break;
            }
            case 2: {
                ((Edge)this).getTail().removeEdge((Edge)this, false);
                ((Edge)this).getHead().removeEdge((Edge)this, true);
                this.getSubgraph().removeEdge(string);
                break;
            }
            case 4: {
                enumeration = ((Subgraph)this).nodeElements();
                element = null;
                while (enumeration.hasMoreElements()) {
                    element = (Element)enumeration.nextElement();
                    element.delete();
                }
                enumeration = ((Subgraph)this).edgeElements();
                element = null;
                while (enumeration.hasMoreElements()) {
                    element = (Element)enumeration.nextElement();
                    element.delete();
                }
                enumeration = ((Subgraph)this).subgraphElements();
                element = null;
                while (enumeration.hasMoreElements()) {
                    element = (Element)enumeration.nextElement();
                    element.delete();
                }
                if (this.getSubgraph() == null) break;
                this.getSubgraph().removeSubgraph(string);
            }
        }
        this.getGraph().removeIdMapping(this);
        if (this.grappaNexus != null) {
            this.grappaNexus.element = null;
            this.grappaNexus = null;
        }
        return true;
    }

    public void addTag(String string) {
        if (string == null || string.indexOf(44) >= 0) {
            throw new RuntimeException("tag value null or contains a comma (" + string + ")");
        }
        Attribute attribute = this.getLocalAttribute("tag");
        if (attribute == null) {
            attribute = new Attribute(this.getType(), "tag", new Hashtable());
            this.setAttribute(attribute);
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        hashtable.put(string, string);
    }

    public boolean hasTag(String string) {
        if (string == null || string.indexOf(44) >= 0) {
            throw new RuntimeException("tag value null or contains a comma (" + string + ")");
        }
        Attribute attribute = this.getLocalAttribute("tag");
        if (attribute == null) {
            return this.hasDefaultTag(string);
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return false;
        }
        return hashtable.containsKey(string);
    }

    public boolean hasLocalTag(String string) {
        Attribute attribute = this.getLocalAttribute("tag");
        if (attribute == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return false;
        }
        return hashtable.containsKey(string);
    }

    public boolean hasDefaultTag(String string) {
        Attribute attribute = this.getDefaultAttribute("tag");
        if (attribute == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return false;
        }
        return hashtable.containsKey(string);
    }

    public boolean hasTags() {
        Attribute attribute = this.getLocalAttribute("tag");
        if (attribute == null) {
            return this.hasDefaultTags();
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        return hashtable != null && hashtable.size() != 0;
    }

    public boolean hasLocalTags() {
        Attribute attribute = this.getLocalAttribute("tag");
        if (attribute == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        return hashtable != null && hashtable.size() != 0;
    }

    public boolean hasDefaultTags() {
        Attribute attribute = this.getDefaultAttribute("tag");
        if (attribute == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        return hashtable != null && hashtable.size() != 0;
    }

    public void removeTags() {
        Attribute attribute = this.getLocalAttribute("tag");
        if (attribute == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        hashtable.clear();
    }

    public void removeTag(String string) {
        Attribute attribute = this.getLocalAttribute("tag");
        if (attribute == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)attribute.getValue();
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        hashtable.remove(string);
    }

    public static int setUserAttributeType(String string, int n) {
        Integer n2;
        int n3 = 0;
        Integer n4 = null;
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("supplied attribute name should be non-null and contain some non-blank characters");
        }
        if (n < 0) {
            n4 = new Integer(n);
        } else {
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n4 = new Integer(n);
                }
            }
        }
        if (n4 == null) {
            throw new IllegalArgumentException("supplied type for attribute (" + string + ") should be less than zero or a recognized type value");
        }
        if (userAttributeTypeMap == null) {
            userAttributeTypeMap = new Hashtable();
        }
        if ((n2 = (Integer)userAttributeTypeMap.get(string)) != null) {
            n3 = n2;
        }
        userAttributeTypeMap.put(string, n4);
        return n3;
    }

    public static int attributeType(String string) {
        int n = -1;
        if (string != null) {
            int n2 = string.hashCode();
            if (n2 == GrappaConstants.BBOX_HASH && string.equals("bb")) {
                n = 1;
            } else if (n2 == GrappaConstants.COLOR_HASH && string.equals("color")) {
                n = 2;
            } else if (n2 == GrappaConstants.FONTCOLOR_HASH && string.equals("fontcolor")) {
                n = 2;
            } else if (n2 == GrappaConstants.FONTSIZE_HASH && string.equals("fontsize")) {
                n = 7;
            } else if (n2 == GrappaConstants.FONTSTYLE_HASH && string.equals("fontstyle")) {
                n = 5;
            } else if (n2 == GrappaConstants.HEIGHT_HASH && string.equals("height")) {
                n = 4;
            } else if (n2 == GrappaConstants.LABEL_HASH && string.equals("label")) {
                n = 12;
            } else if (n2 == GrappaConstants.LP_HASH && string.equals("lp")) {
                n = 9;
            } else if (n2 == GrappaConstants.PATCH_HASH && string.equals("patch")) {
                n = 4;
            } else if (n2 == GrappaConstants.PRINTLIST_HASH && string.equals("printlist")) {
                n = 6;
            } else if (n2 == GrappaConstants.STYLE_HASH && string.equals("style")) {
                n = 13;
            } else if (n2 == GrappaConstants.TAG_HASH && string.equals("tag")) {
                n = 6;
            } else if (n2 != GrappaConstants.STYLE_HASH || !string.equals("style")) {
                Integer n3;
                n = n2 == GrappaConstants.WIDTH_HASH && string.equals("width") ? 4 : (userAttributeTypeMap != null ? ((n3 = (Integer)userAttributeTypeMap.get(string)) == null ? 12 : n3) : 12);
            }
        }
        return n;
    }

    public void buildShape() {
        if (this.grappaNexus == null) {
            this.grappaNexus = new GrappaNexus(this);
            Attribute attribute = null;
            Enumeration enumeration = this.listAttrsOfInterest();
            while (enumeration.hasMoreElements()) {
                attribute = this.getAttribute((String)enumeration.nextElement());
                if (attribute == null) continue;
                attribute.addObserver(this.grappaNexus);
            }
        }
        if (this.grappaNexus == null) {
            throw new InternalError("grappaNexus did not get created");
        }
    }

    public GrappaNexus getGrappaNexus() {
        if (this.grappaNexus == null) {
            this.buildShape();
        }
        return this.grappaNexus;
    }

    public Vector bdfs(int n) {
        Vector<Element> vector = new Vector<Element>(1);
        vector.addElement(this);
        Vector vector2 = new Vector();
        Graph graph = this.getGraph();
        synchronized (graph) {
            Element.doBDFS(this.getType(), n, System.currentTimeMillis(), 0, vector, vector2);
        }
        return vector2;
    }

    private static void doBDFS(int n, int n2, long l, int n3, Vector vector, Vector vector2) {
        int n4 = vector.size();
        if (n4 == 0) {
            return;
        }
        vector2.addElement(vector);
        if (n2 >= 0 && ++n3 > n2) {
            return;
        }
        Vector<Element> vector3 = new Vector<Element>();
        int n5 = 0;
        while (n5 < n4) {
            Edge edge;
            Enumeration enumeration;
            Element element = (Element)vector.elementAt(n5);
            if (element.visastamp == l) {
                throw new RuntimeException("impossible re-visit during doBDFS");
            }
            element.visastamp = l;
            if (n == 4) {
                if (n2 < 0 || n3 <= n2) {
                    enumeration = ((Subgraph)element).subgraphElements();
                    while (enumeration.hasMoreElements()) {
                        Subgraph subgraph = (Subgraph)enumeration.nextElement();
                        if (subgraph.visastamp == l) continue;
                        vector3.addElement(subgraph);
                    }
                }
            } else if (n == 1) {
                if (n2 < 0 || n3 <= n2) {
                    enumeration = ((Node)element).outEdgeElements();
                    while (enumeration.hasMoreElements()) {
                        edge = (Edge)enumeration.nextElement();
                        if (!edge.goesForward() || edge.getHead().visastamp == l) continue;
                        vector3.addElement(edge.getHead());
                    }
                    enumeration = ((Node)element).inEdgeElements();
                    while (enumeration.hasMoreElements()) {
                        edge = (Edge)enumeration.nextElement();
                        if (!edge.goesReverse() || edge.getTail().visastamp == l) continue;
                        vector3.addElement(edge.getTail());
                    }
                }
            } else if (n2 < 0 || n3 <= n2) {
                if (((Edge)element).goesForward()) {
                    enumeration = ((Edge)element).getHead().outEdgeElements();
                    while (enumeration.hasMoreElements()) {
                        edge = (Edge)enumeration.nextElement();
                        if (!edge.goesForward() || edge.visastamp == l) continue;
                        vector3.addElement(edge);
                    }
                    enumeration = ((Edge)element).getHead().inEdgeElements();
                    while (enumeration.hasMoreElements()) {
                        edge = (Edge)enumeration.nextElement();
                        if (!edge.goesReverse() || edge.visastamp == l) continue;
                        vector3.addElement(edge);
                    }
                }
                if (((Edge)element).goesReverse()) {
                    enumeration = ((Edge)element).getTail().outEdgeElements();
                    while (enumeration.hasMoreElements()) {
                        edge = (Edge)enumeration.nextElement();
                        if (!edge.goesForward() || edge.visastamp == l) continue;
                        vector3.addElement(edge);
                    }
                    enumeration = ((Edge)element).getTail().inEdgeElements();
                    while (enumeration.hasMoreElements()) {
                        edge = (Edge)enumeration.nextElement();
                        if (!edge.goesReverse() || edge.visastamp == l) continue;
                        vector3.addElement(edge);
                    }
                }
            }
            ++n5;
        }
        if (vector3.size() > 0) {
            Element.doBDFS(n, n2, l, n3, vector3, vector2);
        }
    }

    double getPatchSize() {
        return this.patchSize;
    }

    void setPatchSize(double d) {
        this.patchSize = d;
    }

    Rectangle2D.Double getPatch() {
        return this.patch;
    }

    void setPatch(Rectangle2D.Double double_) {
        if (double_ == null) {
            this.patch = double_;
        } else if (this.patch == null) {
            this.patch = new GrappaBox(double_.getX(), double_.getY(), double_.getWidth(), double_.getHeight());
        } else {
            this.patch.setRect(double_.getX(), double_.getY(), double_.getWidth(), double_.getHeight());
        }
    }

    void setPatch(double d, double d2, double d3, double d4) {
        if (this.patch == null) {
            this.patch = new GrappaBox(d, d2, d3, d4);
        } else {
            this.patch.setRect(d, d2, d3, d4);
        }
    }
}

