/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaListener;
import att.grappa.GrappaPanel;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSupport;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class GrappaAdapter
implements GrappaConstants,
GrappaListener,
ActionListener {
    public void grappaClicked(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, int n2, GrappaPanel grappaPanel) {
        if ((n & 0x10) == 16 && n2 == 1 && subgraph.getGraph().isSelectable()) {
            if (n == 16) {
                if (element == null) {
                    if (subgraph.currentSelection != null) {
                        if (subgraph.currentSelection instanceof Element) {
                            ((Element)subgraph.currentSelection).highlight &= 0xFFFFFFFC;
                        } else {
                            Vector vector = (Vector)subgraph.currentSelection;
                            int n3 = 0;
                            while (n3 < vector.size()) {
                                ((Element)vector.elementAt((int)n3)).highlight &= 0xFFFFFFFC;
                                ++n3;
                            }
                        }
                        subgraph.currentSelection = null;
                        subgraph.getGraph().repaint();
                    }
                } else {
                    if (subgraph.currentSelection != null) {
                        if (subgraph.currentSelection == element) {
                            return;
                        }
                        if (subgraph.currentSelection instanceof Element) {
                            ((Element)subgraph.currentSelection).highlight &= 0xFFFFFFFC;
                        } else {
                            Vector vector = (Vector)subgraph.currentSelection;
                            int n4 = 0;
                            while (n4 < vector.size()) {
                                ((Element)vector.elementAt((int)n4)).highlight &= 0xFFFFFFFC;
                                ++n4;
                            }
                        }
                        subgraph.currentSelection = null;
                    }
                    element.highlight |= 1;
                    subgraph.currentSelection = element;
                    subgraph.getGraph().repaint();
                }
            } else if (n == 18 && element != null) {
                if ((element.highlight & 1) == 1) {
                    element.highlight &= 0xFFFFFFFE;
                    if (subgraph.currentSelection == null) {
                        throw new InternalError("currentSelection improperly maintained");
                    }
                    if (subgraph.currentSelection instanceof Element) {
                        if ((Element)subgraph.currentSelection != element) {
                            throw new InternalError("currentSelection improperly maintained");
                        }
                        subgraph.currentSelection = null;
                    } else {
                        Vector vector = (Vector)subgraph.currentSelection;
                        boolean bl = true;
                        int n5 = 0;
                        while (n5 < vector.size()) {
                            if ((Element)vector.elementAt(n5) == element) {
                                vector.removeElementAt(n5);
                                bl = false;
                                break;
                            }
                            ++n5;
                        }
                        if (bl) {
                            throw new InternalError("currentSelection improperly maintained");
                        }
                    }
                } else {
                    element.highlight |= 1;
                    if (subgraph.currentSelection == null) {
                        subgraph.currentSelection = element;
                    } else if (subgraph.currentSelection instanceof Element) {
                        Object object = subgraph.currentSelection;
                        subgraph.currentSelection = new Vector();
                        ((Vector)subgraph.currentSelection).add(object);
                        ((Vector)subgraph.currentSelection).add(element);
                    } else {
                        ((Vector)subgraph.currentSelection).add(element);
                    }
                }
                subgraph.getGraph().repaint();
            }
        }
    }

    public void grappaPressed(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, GrappaPanel grappaPanel) {
        if ((n & 0xC) != 0 && (n & 0xC) == n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = null;
            if (grappaPanel.getToolTipText() == null) {
                jMenuItem = new JMenuItem("ToolTips On");
                jPopupMenu.add(jMenuItem);
            } else {
                jMenuItem = new JMenuItem("ToolTips Off");
                jPopupMenu.add(jMenuItem);
            }
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Print");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            if (subgraph.currentSelection != null) {
                jMenuItem = new JMenuItem("Clear Selection");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(this);
                jPopupMenu.addSeparator();
                if (subgraph.currentSelection instanceof Element) {
                    jMenuItem = new JMenuItem("Select Siblings in Subgraph");
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(this);
                    jPopupMenu.addSeparator();
                }
                jMenuItem = new JMenuItem("Enclose Selected Items in a new Subgraph");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(this);
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Preview Deletion");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(this);
                jMenuItem = new JMenuItem("Cancel Preview");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(this);
                jMenuItem = new JMenuItem("Perform Deletion");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(this);
                jPopupMenu.addSeparator();
            }
            if (grappaPanel.hasOutline()) {
                jMenuItem = new JMenuItem("Zoom to Sweep");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(this);
            }
            jMenuItem = new JMenuItem("Zoom In");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Zoom Out");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Reset Zoom");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Scale to Fit");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            if (subgraph.hasEmptySubgraphs()) {
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Remove Empty Subgraphs");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(this);
            }
            Point2D point2D = grappaPanel.getTransform().transform(grappaPoint, null);
            jPopupMenu.show(grappaPanel, (int)point2D.getX(), (int)point2D.getY());
        }
    }

    public void grappaReleased(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, Element element2, GrappaPoint grappaPoint2, int n2, GrappaBox grappaBox, GrappaPanel grappaPanel) {
        if (n == 16 && subgraph.getGraph().isSelectable()) {
            if (grappaBox != null) {
                Vector vector;
                boolean bl = false;
                if (subgraph.currentSelection != null) {
                    if (subgraph.currentSelection instanceof Element) {
                        ((Element)subgraph.currentSelection).highlight = 0;
                    } else {
                        vector = (Vector)subgraph.currentSelection;
                        int n3 = 0;
                        while (n3 < vector.size()) {
                            ((Element)vector.elementAt((int)n3)).highlight = 0;
                            ++n3;
                        }
                    }
                    subgraph.currentSelection = null;
                }
                if ((vector = GrappaSupport.findContainedElements(subgraph, grappaBox)) != null) {
                    this.drillDown(subgraph, vector, 1, 4);
                    bl = false;
                }
                if (!bl) {
                    subgraph.getGraph().paintImmediately();
                }
                if (bl) {
                    Graphics2D graphics2D = (Graphics2D)grappaPanel.getGraphics();
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.setTransform(grappaPanel.getTransform());
                    graphics2D.setXORMode(Color.darkGray);
                    graphics2D.draw(grappaBox);
                    graphics2D.setPaintMode();
                    graphics2D.setTransform(affineTransform);
                }
            }
        } else if (n == 18 && subgraph.getGraph().isSelectable()) {
            if (grappaBox != null) {
                Vector vector = GrappaSupport.findContainedElements(subgraph, grappaBox);
                if (vector != null) {
                    this.drillDown(subgraph, vector, 1, 16);
                    subgraph.getGraph().repaint();
                } else {
                    Graphics2D graphics2D = (Graphics2D)grappaPanel.getGraphics();
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.setTransform(grappaPanel.getTransform());
                    graphics2D.setXORMode(Color.darkGray);
                    graphics2D.draw(grappaBox);
                    graphics2D.setPaintMode();
                    graphics2D.setTransform(affineTransform);
                }
            }
        } else if (n == 17 && subgraph.getGraph().isEditable() && element != null && element2 != null && n2 == n && grappaBox == null) {
            if (element2 == element && grappaPoint.distance(grappaPoint2) < 5.0) {
                Attribute[] attributeArray = null;
                Attribute attribute = subgraph.getNodeAttribute("label");
                attributeArray = attribute == null || attribute.getValue().equals("\\N") ? new Attribute[]{new Attribute(1, "pos", grappaPoint), new Attribute(1, "label", "Node" + subgraph.getGraph().getId(1))} : new Attribute[]{new Attribute(1, "pos", grappaPoint)};
                Element element3 = subgraph.createElement(1, null, attributeArray);
                if (element3 != null) {
                    element3.buildShape();
                    subgraph.getGraph().repaint();
                }
                subgraph.getGraph().repaint();
            } else if (element2 != element && element2.isNode() && element.isNode()) {
                Object[] objectArray = new Object[]{element, null, element2};
                Attribute[] attributeArray = new Attribute[]{new Attribute(2, "pos", new GrappaLine(new GrappaPoint[]{((Node)element2).getCenterPoint(), ((Node)element).getCenterPoint()}, subgraph.getGraph().isDirected() ? 2 : 0))};
                Element element4 = subgraph.createElement(2, objectArray, attributeArray);
                if (element4 != null) {
                    element4.buildShape();
                    subgraph.getGraph().repaint();
                }
            }
        }
    }

    public void grappaDragged(Subgraph subgraph, GrappaPoint grappaPoint, int n, Element element, GrappaPoint grappaPoint2, int n2, GrappaBox grappaBox, GrappaPanel grappaPanel) {
        if ((n & 0x10) == 16 && (n == 16 || n == 18)) {
            Graphics2D graphics2D = (Graphics2D)grappaPanel.getGraphics();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setTransform(grappaPanel.getTransform());
            graphics2D.setXORMode(Color.darkGray);
            if (grappaBox != null) {
                graphics2D.draw(grappaBox);
            }
            GrappaBox grappaBox2 = GrappaSupport.boxFromCorners(grappaPoint2.x, grappaPoint2.y, grappaPoint.x, grappaPoint.y);
            graphics2D.draw(grappaBox2);
            graphics2D.setPaintMode();
            graphics2D.setTransform(affineTransform);
        }
    }

    public String grappaTip(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, GrappaPanel grappaPanel) {
        String string = null;
        if (element == null) {
            string = grappaPanel.getToolTipText();
            if (string == null && (string = subgraph.getGraph().getToolTipText()) == null) {
                string = Grappa.getToolTipText();
            }
        } else {
            switch (element.getType()) {
                case 4: {
                    Subgraph subgraph2 = (Subgraph)element;
                    string = (String)subgraph2.getAttributeValue("tip");
                    if (string != null) break;
                    if (subgraph.getShowSubgraphLabels()) {
                        string = subgraph2.getName();
                    } else {
                        string = (String)subgraph2.getAttributeValue("label");
                        if (string == null) {
                            string = subgraph2.getName();
                        }
                    }
                    string = "Subgraph: " + string;
                    break;
                }
                case 2: {
                    Edge edge = (Edge)element;
                    string = (String)edge.getAttributeValue("tip");
                    if (string != null) break;
                    if (subgraph.getShowEdgeLabels()) {
                        string = edge.toString();
                    } else {
                        string = (String)edge.getAttributeValue("label");
                        if (string == null) {
                            string = edge.toString();
                        }
                    }
                    string = "Edge: " + string;
                    break;
                }
                case 1: {
                    Node node = (Node)element;
                    string = (String)node.getAttributeValue("tip");
                    if (string != null) break;
                    if (subgraph.getShowNodeLabels()) {
                        string = node.getName();
                    } else {
                        string = (String)node.getAttributeValue("label");
                        if (string == null || string.equals("\\N")) {
                            string = node.getName();
                        }
                    }
                    string = "Node: " + string;
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected type (" + element.getType() + ")");
                }
            }
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component;
        Container container;
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem && (container = ((JMenuItem)object).getParent()) instanceof JPopupMenu && (component = ((JPopupMenu)((JMenuItem)object).getParent()).getInvoker()) instanceof GrappaPanel) {
            GrappaPanel grappaPanel = (GrappaPanel)component;
            Subgraph subgraph = grappaPanel.getSubgraph();
            String string = ((JMenuItem)object).getText();
            if (string.startsWith("Cancel")) {
                if (subgraph.currentSelection == null) {
                    return;
                }
                if (subgraph.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subgraph.currentSelection, 2, 8);
                } else {
                    Vector vector = (Vector)subgraph.currentSelection;
                    int n = 0;
                    while (n < vector.size()) {
                        GrappaSupport.setHighlight((Element)vector.elementAt(n), 2, 8);
                        ++n;
                    }
                }
                subgraph.getGraph().repaint();
            } else if (string.startsWith("Clear")) {
                if (subgraph.currentSelection == null) {
                    return;
                }
                if (subgraph.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subgraph.currentSelection, 0, 8);
                } else {
                    Vector vector = (Vector)subgraph.currentSelection;
                    int n = 0;
                    while (n < vector.size()) {
                        GrappaSupport.setHighlight((Element)vector.elementAt(n), 0, 8);
                        ++n;
                    }
                }
                subgraph.currentSelection = null;
                subgraph.getGraph().repaint();
            } else if (string.startsWith("Select")) {
                if (subgraph.currentSelection == null) {
                    return;
                }
                if (!(subgraph.currentSelection instanceof Element)) {
                    return;
                }
                Subgraph subgraph2 = ((Element)subgraph.currentSelection).getSubgraph();
                if (subgraph2 == null || subgraph.currentSelection == subgraph2 || !(subgraph2 instanceof Subgraph)) {
                    return;
                }
                ((Element)subgraph.currentSelection).highlight &= 0xFFFFFFFC;
                Vector vector = new Vector();
                Enumeration enumeration = subgraph2.nodeElements();
                while (enumeration.hasMoreElements()) {
                    vector.add(enumeration.nextElement());
                }
                enumeration = subgraph2.edgeElements();
                while (enumeration.hasMoreElements()) {
                    vector.add(enumeration.nextElement());
                }
                subgraph.currentSelection = null;
                if (vector != null && vector.size() > 0) {
                    this.drillDown(subgraph, vector, 1, 4);
                }
                subgraph.getGraph().repaint();
            } else if (string.startsWith("Enclose")) {
                if (subgraph.currentSelection == null || subgraph.currentSelection == subgraph) {
                    return;
                }
                Subgraph subgraph3 = new Subgraph(subgraph);
                if (subgraph.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subgraph.currentSelection, 0, 8);
                    ((Element)subgraph.currentSelection).setSubgraph(subgraph3);
                } else {
                    Vector vector = (Vector)subgraph.currentSelection;
                    int n = 0;
                    while (n < vector.size()) {
                        GrappaSupport.setHighlight((Element)vector.elementAt(n), 0, 8);
                        if ((Element)vector.elementAt(n) != subgraph) {
                            ((Element)vector.elementAt(n)).setSubgraph(subgraph3);
                        }
                        ++n;
                    }
                }
                subgraph.currentSelection = null;
                subgraph.getGraph().repaint();
            } else if (string.startsWith("Preview")) {
                if (subgraph.currentSelection == null) {
                    return;
                }
                if (subgraph.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subgraph.currentSelection, 2, 4);
                } else {
                    Vector vector = (Vector)subgraph.currentSelection;
                    int n = 0;
                    while (n < vector.size()) {
                        GrappaSupport.setHighlight((Element)vector.elementAt(n), 2, 4);
                        ++n;
                    }
                }
                subgraph.getGraph().repaint();
            } else if (string.startsWith("Perform")) {
                if (subgraph.currentSelection == null) {
                    return;
                }
                if (subgraph.currentSelection instanceof Element) {
                    ((Element)subgraph.currentSelection).delete();
                } else {
                    Vector vector = (Vector)subgraph.currentSelection;
                    int n = 0;
                    while (n < vector.size()) {
                        ((Element)vector.elementAt(n)).delete();
                        ++n;
                    }
                }
                subgraph.currentSelection = null;
                subgraph.getGraph().repaint();
            } else if (string.startsWith("Remove")) {
                subgraph.removeEmptySubgraphs();
            } else if (string.startsWith("Reset")) {
                grappaPanel.setScaleToFit(false);
                grappaPanel.setScaleToSize(null);
                grappaPanel.resetZoom();
                grappaPanel.clearOutline();
            } else if (string.startsWith("Scale")) {
                grappaPanel.setScaleToFit(true);
            } else if (string.startsWith("Print")) {
                PageFormat pageFormat = new PageFormat();
                Rectangle2D rectangle2D = subgraph.getBoundingBox();
                if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                    pageFormat.setOrientation(0);
                }
                try {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(grappaPanel, pageFormat);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
                catch (Exception exception) {
                    Grappa.displayException(exception, "Problem with print request");
                }
            } else if (string.startsWith("ToolTips")) {
                if (string.indexOf("Off") > 0) {
                    grappaPanel.setToolTipText(null);
                } else {
                    String string2 = subgraph.getGraph().getToolTipText();
                    if (string2 == null) {
                        string2 = Grappa.getToolTipText();
                    }
                    grappaPanel.setToolTipText(string2);
                }
            } else if (string.startsWith("Zoom In")) {
                grappaPanel.setScaleToFit(false);
                grappaPanel.setScaleToSize(null);
                grappaPanel.multiplyScaleFactor(1.25);
                grappaPanel.clearOutline();
            } else if (string.startsWith("Zoom Out")) {
                grappaPanel.setScaleToFit(false);
                grappaPanel.setScaleToSize(null);
                grappaPanel.multiplyScaleFactor(0.8);
                grappaPanel.clearOutline();
            } else if (string.startsWith("Zoom to")) {
                grappaPanel.setScaleToFit(false);
                grappaPanel.setScaleToSize(null);
                grappaPanel.zoomToOutline();
                grappaPanel.clearOutline();
            }
        }
    }

    protected void drillDown(Subgraph subgraph, Vector vector, int n, int n2) {
        Object e = null;
        int n3 = 0;
        while (n3 < vector.size()) {
            e = vector.elementAt(n3);
            if (e instanceof Vector) {
                this.drillDown(subgraph, (Vector)e, n, n2);
            } else {
                GrappaSupport.setHighlight((Element)e, n, n2);
                switch (n2) {
                    case 16: {
                        Object object;
                        if ((((Element)e).highlight & n) == n) {
                            if (subgraph.currentSelection == null) {
                                subgraph.currentSelection = e;
                                break;
                            }
                            if (subgraph.currentSelection instanceof Element) {
                                object = subgraph.currentSelection;
                                subgraph.currentSelection = new Vector();
                                ((Vector)subgraph.currentSelection).add(object);
                                ((Vector)subgraph.currentSelection).add(e);
                                break;
                            }
                            ((Vector)subgraph.currentSelection).add(e);
                            break;
                        }
                        if (subgraph.currentSelection == e) {
                            subgraph.currentSelection = null;
                            break;
                        }
                        if (!(subgraph.currentSelection instanceof Vector)) break;
                        ((Vector)subgraph.currentSelection).remove(e);
                        break;
                    }
                    case 4: {
                        Object object;
                        if (subgraph.currentSelection == null) {
                            subgraph.currentSelection = e;
                            break;
                        }
                        if (subgraph.currentSelection instanceof Element) {
                            object = subgraph.currentSelection;
                            subgraph.currentSelection = new Vector();
                            ((Vector)subgraph.currentSelection).add(object);
                            ((Vector)subgraph.currentSelection).add(e);
                            break;
                        }
                        ((Vector)subgraph.currentSelection).add(e);
                        break;
                    }
                    case 8: {
                        if (subgraph.currentSelection == null) break;
                        if (subgraph.currentSelection == e) {
                            subgraph.currentSelection = null;
                            break;
                        }
                        if (!(subgraph.currentSelection instanceof Vector)) break;
                        ((Vector)subgraph.currentSelection).remove(e);
                    }
                }
            }
            ++n3;
        }
    }
}

