/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.CustomRenderer;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.GraphEnumeration;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaPathIterator;
import att.grappa.GrappaPoint;
import att.grappa.GrappaShape;
import att.grappa.GrappaSize;
import att.grappa.GrappaStyle;
import att.grappa.GrappaSupportRects;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;

public class GrappaNexus
implements GrappaConstants,
Cloneable,
ImageObserver,
Observer,
Shape {
    public static double arcHeightFactor = 0.05;
    public static double arcWidthFactor = 0.05;
    Area textArea = null;
    Shape shape = null;
    int shapeType = 0;
    Rectangle2D bbox = null;
    GrappaStyle style = null;
    Color color = null;
    Image image = null;
    boolean imageLoading = false;
    boolean dirty = false;
    Stroke stroke = null;
    private Object[] objs = null;
    private Object custom_shape = null;
    public boolean boundText = true;
    public boolean clearText = false;
    public boolean drawText = true;
    Element element = null;
    long lastUpdate = 0L;
    private long lastShapeUpdate = 0L;
    private long lastTextUpdate = 0L;
    private long lastStyleUpdate = 0L;
    private long lastDecorationUpdate = 0L;
    private long lastImageUpdate = 0L;
    AffineTransform xform = null;
    Font font = null;
    String[] lstr = null;
    GrappaPoint[] lpos = null;
    Color font_color = null;
    private int windingRule = Grappa.windingRule;
    static /* synthetic */ Class class$att$grappa$GrappaShape;
    static /* synthetic */ Class class$att$grappa$Element;

    public GrappaNexus(Element element) {
        this.element = element;
        this.rebuild();
    }

    public Element getElement() {
        return this.element;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isImageLoading() {
        return this.imageLoading;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public void rebuild() {
        this.updateStyle();
        this.updateDecoration();
        this.updateShape();
        this.updateText();
        this.updateImage();
    }

    public void updateShape() {
        long l = System.currentTimeMillis();
        block3 : switch (this.element.getType()) {
            case 1: {
                double d;
                this.custom_shape = null;
                this.objs = null;
                if (this.element.getSubgraph().isCluster() && this.element.getSubgraph().grappaNexus != null) {
                    this.element.getSubgraph().grappaNexus.dirty = true;
                }
                Node node = (Node)this.element;
                GrappaPoint grappaPoint = (GrappaPoint)node.getAttributeValue("pos");
                Double d2 = (Double)node.getAttributeValue("width");
                Double d3 = (Double)node.getAttributeValue("height");
                Integer n = (Integer)node.getAttributeValue("shape");
                double d4 = 72.0 * d2;
                double d5 = 72.0 * d3;
                int n2 = n;
                Integer n3 = (Integer)node.getAttributeValue("peripheries");
                Integer n4 = (Integer)node.getAttributeValue("sides");
                Double d6 = (Double)node.getAttributeValue("distortion");
                Double d7 = (Double)node.getAttributeValue("skew");
                Double d8 = (Double)node.getAttributeValue("orientation");
                Double d9 = (Double)node.getAttributeValue("rotation");
                int n5 = n3 == null ? -1 : n3;
                int n6 = n4 == null ? -1 : n4;
                double d10 = d6 == null ? 0.0 : d6;
                double d11 = d7 == null ? 0.0 : d7;
                double d12 = d8 == null ? 0.0 : d8;
                double d13 = d = d9 == null ? 0.0 : d9;
                if (d8 != null && d12 != 0.0 && Grappa.orientationInDegrees) {
                    d12 = Math.PI * d12 / 180.0;
                }
                if (d9 != null && d != 0.0) {
                    double d14 = d;
                    if (Grappa.rotationInDegrees) {
                        d14 = Math.PI * d14 / 180.0;
                    }
                    this.appendTransform(AffineTransform.getRotateInstance(d14, grappaPoint.x, grappaPoint.y));
                }
                switch (n2) {
                    case 27: {
                        Constructor<?> constructor;
                        Class<?> clazz;
                        String string = (String)node.getAttributeValue("custom");
                        if (string == null) {
                            throw new IllegalArgumentException("custom attibuted null for node (" + node.getName() + ") with custom shape");
                        }
                        try {
                            clazz = Class.forName(string);
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException("custom class unavailable for custom shape '" + string + "'");
                        }
                        if (!(class$att$grappa$GrappaShape == null ? (class$att$grappa$GrappaShape = GrappaNexus.class$("att.grappa.GrappaShape")) : class$att$grappa$GrappaShape).isAssignableFrom(clazz)) {
                            throw new IllegalArgumentException("custom class '" + string + "' does not extend the GrappaShape class");
                        }
                        try {
                            constructor = clazz.getConstructor(class$att$grappa$Element == null ? (class$att$grappa$Element = GrappaNexus.class$("att.grappa.Element")) : class$att$grappa$Element, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException("constructor for custom class shape '" + string + "' not found");
                        }
                        try {
                            if (Grappa.centerPointNodes) {
                                this.custom_shape = constructor.newInstance(node, new Double(grappaPoint.x - d4 / 2.0), new Double(grappaPoint.y - d5 / 2.0), new Double(d4), new Double(d5));
                                this.shape = (Shape)this.custom_shape;
                            } else {
                                this.custom_shape = constructor.newInstance(node, new Double(grappaPoint.x), new Double(grappaPoint.y), new Double(d4), new Double(d5));
                                this.shape = (Shape)this.custom_shape;
                            }
                        }
                        catch (Exception exception) {
                            if (exception instanceof InvocationTargetException) {
                                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                                Grappa.displayException((Exception)throwable);
                            }
                            if (exception instanceof UndeclaredThrowableException) {
                                throw new IllegalArgumentException("cannot instantiate custom shape '" + string + "' for node '" + node.getName() + "' because2: " + ((UndeclaredThrowableException)exception).getUndeclaredThrowable().getMessage());
                            }
                            throw new IllegalArgumentException("cannot instantiate custom shape '" + string + "' for node '" + node.getName() + "' because3: " + exception.getMessage());
                        }
                        this.shapeType = 27;
                        break block3;
                    }
                    case 2: {
                        if (!(d6 != null && d10 != 0.0 || d7 != null && d11 != 0.0 || d8 != null && d12 != 0.0)) {
                            this.shapeType = 2;
                            this.shape = Grappa.centerPointNodes ? new Rectangle2D.Double(grappaPoint.x - d4 / 2.0, grappaPoint.y - d5 / 2.0, d4, d5) : new Rectangle2D.Double(grappaPoint.x, grappaPoint.y, d4, d5);
                            if (n3 == null || n5 <= 1) break block3;
                            GeneralPath generalPath = new GeneralPath(this.shape);
                            int n7 = 1;
                            while (n7 < n5) {
                                if (Grappa.centerPointNodes) {
                                    generalPath.append(new Rectangle2D.Double(grappaPoint.x - d4 / 2.0 + (double)(n7 * 4), grappaPoint.y - d5 / 2.0 + (double)(n7 * 4), d4 - (double)(2 * n7 * 4), d5 - (double)(2 * n7 * 4)), false);
                                } else {
                                    generalPath.append(new Rectangle2D.Double(grappaPoint.x + (double)(n7 * 4), grappaPoint.y + (double)(n7 * 4), d4 - (double)(2 * n7 * 4), d5 - (double)(2 * n7 * 4)), false);
                                }
                                ++n7;
                            }
                            this.shape = generalPath;
                            break block3;
                        }
                        this.shapeType = 1026;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, grappaPoint.x, grappaPoint.y, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                            break block3;
                        }
                        this.shape = new GrappaShape(this.shapeType, grappaPoint.x + d4 / 2.0, grappaPoint.y + d5 / 2.0, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                        break block3;
                    }
                    case 19: {
                        if (!(d6 != null && d10 != 0.0 || d7 != null && d11 != 0.0 || d8 != null && d12 != 0.0)) {
                            this.shapeType = 19;
                            this.shape = Grappa.centerPointNodes ? new RoundRectangle2D.Double(grappaPoint.x - d4 / 2.0, grappaPoint.y - d5 / 2.0, d4, d5, arcWidthFactor * d4, arcHeightFactor * d5) : new RoundRectangle2D.Double(grappaPoint.x, grappaPoint.y, d4, d5, arcWidthFactor * d4, arcHeightFactor * d5);
                            if (n3 == null || n5 <= 1) break block3;
                            GeneralPath generalPath = new GeneralPath(this.shape);
                            int n8 = 1;
                            while (n8 < n5) {
                                if (Grappa.centerPointNodes) {
                                    generalPath.append(new RoundRectangle2D.Double(grappaPoint.x - d4 / 2.0 + (double)(n8 * 4), grappaPoint.y - d5 / 2.0 + (double)(n8 * 4), d4 - (double)(2 * n8 * 4), d5 - (double)(2 * n8 * 4), arcWidthFactor * (d4 - (double)(2 * n8 * 4)), arcHeightFactor * (d5 - (double)(2 * n8 * 4))), false);
                                } else {
                                    generalPath.append(new RoundRectangle2D.Double(grappaPoint.x + (double)(n8 * 4), grappaPoint.y + (double)(n8 * 4), d4 - (double)(2 * n8 * 4), d5 - (double)(2 * n8 * 4), arcWidthFactor * (d4 - (double)(2 * n8 * 4)), arcHeightFactor * (d5 - (double)(2 * n8 * 4))), false);
                                }
                                ++n8;
                            }
                            this.shape = generalPath;
                            break block3;
                        }
                        this.shapeType = 1043;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, grappaPoint.x, grappaPoint.y, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                            break block3;
                        }
                        this.shape = new GrappaShape(this.shapeType, grappaPoint.x + d4 / 2.0, grappaPoint.y + d5 / 2.0, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                        break block3;
                    }
                    case 13: {
                        if (!(d6 != null && d10 != 0.0 || d7 != null && d11 != 0.0 || d8 != null && d12 != 0.0)) {
                            this.shapeType = 13;
                            this.shape = Grappa.centerPointNodes ? new Ellipse2D.Double(grappaPoint.x - d4 / 2.0, grappaPoint.y - d5 / 2.0, d4, d5) : new Ellipse2D.Double(grappaPoint.x, grappaPoint.y, d4, d5);
                            if (n3 == null || n5 <= 1) break block3;
                            GeneralPath generalPath = new GeneralPath(this.shape);
                            int n9 = 1;
                            while (n9 < n5) {
                                if (Grappa.centerPointNodes) {
                                    generalPath.append(new Ellipse2D.Double(grappaPoint.x - d4 / 2.0 + (double)(n9 * 4), grappaPoint.y - d5 / 2.0 + (double)(n9 * 4), d4 - (double)(2 * n9 * 4), d5 - (double)(2 * n9 * 4)), false);
                                } else {
                                    generalPath.append(new Ellipse2D.Double(grappaPoint.x + (double)(n9 * 4), grappaPoint.y + (double)(n9 * 4), d4 - (double)(2 * n9 * 4), d5 - (double)(2 * n9 * 4)), false);
                                }
                                ++n9;
                            }
                            this.shape = generalPath;
                            break block3;
                        }
                        this.shapeType = 1037;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, grappaPoint.x, grappaPoint.y, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                            break block3;
                        }
                        this.shape = new GrappaShape(this.shapeType, grappaPoint.x + d4 / 2.0, grappaPoint.y + d5 / 2.0, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                        break block3;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: {
                        this.shapeType = n2 | 0x400;
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, grappaPoint.x, grappaPoint.y, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                            break block3;
                        }
                        this.shape = new GrappaShape(this.shapeType, grappaPoint.x + d4 / 2.0, grappaPoint.y + d5 / 2.0, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, null);
                        break block3;
                    }
                    case 18: 
                    case 25: {
                        this.shapeType = n2 | 0x400;
                        this.objs = GrappaSupportRects.parseRecordInfo(node);
                        String string = null;
                        if (this.objs != null) {
                            string = (String)this.objs[2];
                        }
                        if (Grappa.centerPointNodes) {
                            this.shape = new GrappaShape(this.shapeType, grappaPoint.x, grappaPoint.y, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, string);
                            break block3;
                        }
                        this.shape = new GrappaShape(this.shapeType, grappaPoint.x + d4 / 2.0, grappaPoint.y + d5 / 2.0, d4, d5, n6, n5, d10, d11, d12, this.style.rounded, this.style.diagonals, string);
                        break block3;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported type for this constructor (" + n2 + ")");
                    }
                }
            }
            case 2: {
                Edge edge = (Edge)this.element;
                this.shapeType = 1;
                if (this.element.getSubgraph().isCluster() && this.element.getSubgraph().grappaNexus != null) {
                    this.element.getSubgraph().grappaNexus.dirty = true;
                }
                if ((this.shape = (Shape)edge.getAttributeValue("pos")) != null) break;
                Integer n = (Integer)edge.getAttributeValue("dir");
                edge.direction = n != null ? n : (edge.getGraph().isDirected() ? 2 : 0);
                edge.setAttribute("pos", new GrappaLine(new GrappaPoint[]{(GrappaPoint)edge.getTail().getAttributeValue("pos"), (GrappaPoint)edge.getHead().getAttributeValue("pos")}, edge.direction));
                this.shape = (Shape)edge.getAttributeValue("pos");
                break;
            }
            case 4: {
                GrappaBox grappaBox;
                Subgraph subgraph = (Subgraph)this.element;
                this.shapeType = 2;
                this.dirty = false;
                RectangularShape rectangularShape = null;
                Element element = null;
                GraphEnumeration graphEnumeration = subgraph.elements();
                while (graphEnumeration.hasMoreElements()) {
                    element = graphEnumeration.nextGraphElement();
                    if (element == this.element) continue;
                    switch (element.getType()) {
                        case 1: 
                        case 2: {
                            element.buildShape();
                            if (rectangularShape == null) {
                                rectangularShape = element.grappaNexus.getBounds2D();
                                break;
                            }
                            ((Rectangle2D)rectangularShape).add(element.grappaNexus.rawBounds2D());
                            break;
                        }
                        case 4: {
                            if (rectangularShape == null) {
                                rectangularShape = ((Subgraph)element).getBoundingBox();
                                break;
                            }
                            ((Rectangle2D)rectangularShape).add(((Subgraph)element).getBoundingBox());
                            break;
                        }
                        default: {
                            throw new InternalError("unknown type (" + element.getType() + ")");
                        }
                    }
                }
                GrappaSize grappaSize = (GrappaSize)this.element.getAttributeValue("minsize");
                if (grappaSize != null) {
                    if (rectangularShape == null) {
                        rectangularShape = new Rectangle2D.Double(0.0, 0.0, grappaSize.getWidth(), grappaSize.getHeight());
                    } else {
                        ((Rectangle2D)rectangularShape).add(new Rectangle2D.Double(rectangularShape.getCenterX() - grappaSize.getWidth() / 2.0, rectangularShape.getCenterY() - grappaSize.getHeight() / 2.0, grappaSize.getWidth(), grappaSize.getHeight()));
                    }
                }
                if ((grappaBox = (GrappaBox)this.element.getAttributeValue("minbox")) != null) {
                    if (rectangularShape == null) {
                        rectangularShape = new Rectangle2D.Double(grappaBox.x, grappaBox.y, grappaBox.width, grappaBox.height);
                    } else {
                        ((Rectangle2D)rectangularShape).add(new Rectangle2D.Double(grappaBox.x, grappaBox.y, grappaBox.width, grappaBox.height));
                    }
                }
                if (rectangularShape == null) {
                    rectangularShape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                }
                this.shape = rectangularShape;
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized element type (" + this.element.getType() + ") for " + this.element.getName());
            }
        }
        this.bboxCheckSet();
        this.lastUpdate = this.lastShapeUpdate = l;
    }

    public void updateStyle() {
        long l = System.currentTimeMillis();
        this.style = (GrappaStyle)this.element.getAttributeValue("style");
        if (this.style == null) {
            throw new InternalError("style defaults not properly set in Graph.java");
        }
        if (this.style.font_style != null && this.style.font_style != (Integer)this.element.getAttributeValue("fontstyle")) {
            this.element.setAttribute("fontstyle", this.style.font_style);
            this.style.font_style = null;
        }
        this.lastUpdate = this.lastStyleUpdate = l;
    }

    public void updateText() {
        long l;
        Font font;
        Area area;
        GrappaPoint[] grappaPointArray;
        String[] stringArray;
        block32: {
            GrappaPoint[] grappaPointArray2;
            GrappaPoint[] grappaPointArray3;
            String[] stringArray2;
            stringArray = null;
            grappaPointArray = null;
            area = null;
            font = null;
            boolean bl = false;
            double d = -1.0;
            int n = 0;
            l = System.currentTimeMillis();
            String string = (String)this.element.getAttributeValue("label");
            if (string != null && string.equals("\\N")) {
                string = this.element.getName();
            }
            if (string == null || string.length() <= 0) break block32;
            if (this.element.isNode() && (this.shapeType == 1042 || this.shapeType == 1049) && string.indexOf(124) < 0 && string.indexOf(123) == 0 && string.lastIndexOf(125) == string.length() - 1) {
                string = string.substring(1, string.length() - 1).trim();
            }
            if (string.length() <= 0) break block32;
            String string2 = (String)this.element.getAttributeValue("fontname");
            Integer n2 = (Integer)this.element.getAttributeValue("fontstyle");
            Integer n3 = (Integer)this.element.getAttributeValue("fontsize");
            Integer n4 = (Integer)this.element.getGraph().getGrappaAttributeValue("grappaFontsizeAdjustment");
            font = new Font(string2, (int)n2, n3 + n4);
            Object var18_14 = null;
            Attribute attribute = null;
            if (this.element.isNode() && (this.shapeType == 1042 || this.shapeType == 1049) && string.indexOf(124) >= 0) {
                if (this.objs == null) {
                    this.updateShape();
                }
                if (this.objs != null && this.objs[0] != null && this.objs[1] != null) {
                    stringArray2 = (String[])this.objs[0];
                    grappaPointArray3 = (GrappaPoint[])this.objs[1];
                } else {
                    stringArray2 = new String[]{string};
                    grappaPointArray3 = new GrappaPoint[]{((Node)this.element).getCenterPoint()};
                }
            } else {
                stringArray2 = new String[]{string};
                grappaPointArray3 = new GrappaPoint[1];
                if (Grappa.autoPositionNodeLabel && this.element.isNode()) {
                    grappaPointArray3[0] = ((Node)this.element).getCenterPoint();
                } else {
                    Subgraph subgraph;
                    attribute = this.element.getLocalAttribute("lp");
                    if (attribute == null || (subgraph = this.element.getSubgraph()) != null && attribute == subgraph.getLocalAttribute("lp")) {
                        grappaPointArray2 = (GrappaPoint[])this.element.getAttributeValue("bb");
                        if (grappaPointArray2 == null) {
                            grappaPointArray2 = this.bbox;
                        }
                        if (this.element.isSubgraph() && grappaPointArray2 != null) {
                            grappaPointArray3[0] = new GrappaPoint(grappaPointArray2.getX() + grappaPointArray2.getWidth() / 2.0, Grappa.labelGraphBottom ? grappaPointArray2.getMaxY() : grappaPointArray2.getMinY());
                            this.element.setAttribute("lp", grappaPointArray3[0].clone());
                        } else {
                            grappaPointArray3[0] = null;
                        }
                    } else {
                        grappaPointArray3[0] = (GrappaPoint)attribute.getValue();
                    }
                }
                if (this.element.isSubgraph() && attribute == null) {
                    d = Grappa.labelGraphBottom ? 1.0 : -1.0;
                    bl = true;
                }
            }
            int n5 = 0;
            while (n5 < stringArray2.length) {
                block33: {
                    block34: {
                        if (stringArray2[n5] == null || grappaPointArray3[n5] == null || stringArray2[n5].length() <= 0) break block33;
                        if (!stringArray2[n5].equals("\\N")) break block34;
                        stringArray2[n5] = this.element.getName();
                        if (stringArray2[n5] == null) break block33;
                    }
                    int n6 = 1;
                    char[] cArray = stringArray2[n5].toCharArray();
                    int n7 = 0;
                    while (n7 < cArray.length) {
                        if (cArray[n7] == '\\' && ++n7 < cArray.length && (cArray[n7] == 'l' || cArray[n7] == 'r' || cArray[n7] == 'n') && n7 + 1 < cArray.length) {
                            ++n6;
                        }
                        ++n7;
                    }
                    if (grappaPointArray == null) {
                        n = 0;
                        grappaPointArray = new GrappaPoint[n6];
                        stringArray = new String[n6];
                    } else {
                        n = grappaPointArray.length;
                        grappaPointArray2 = new GrappaPoint[n + n6];
                        String[] stringArray3 = new String[n + n6];
                        System.arraycopy(grappaPointArray, 0, grappaPointArray2, 0, n);
                        System.arraycopy(stringArray, 0, stringArray3, 0, n);
                        grappaPointArray = grappaPointArray2;
                        stringArray = stringArray3;
                    }
                    int[] nArray = new int[n6];
                    Rectangle2D[] rectangle2DArray = new Rectangle2D[n6];
                    LineMetrics[] lineMetricsArray = new LineMetrics[n6];
                    n6 = 0;
                    int n8 = 0;
                    int n9 = 110;
                    Object var27_29 = null;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    n7 = 0;
                    while (n7 < cArray.length) {
                        if (cArray[n7] == '\\' && ++n7 < cArray.length && ((n9 = cArray[n7]) == 108 || cArray[n7] == 'r' || cArray[n7] == 'n')) {
                            stringArray[n + n6] = new String(cArray, n8, n7 - 1 - n8);
                            rectangle2DArray[n6] = font.getStringBounds(stringArray[n + n6], this.element.getGraph().REFCNTXT);
                            lineMetricsArray[n6] = font.getLineMetrics(stringArray[n + n6], this.element.getGraph().REFCNTXT);
                            if (rectangle2DArray[n6].getWidth() > d3) {
                                d3 = rectangle2DArray[n6].getWidth();
                            }
                            d2 += (double)(2 + font.getSize());
                            nArray[n6++] = n9 == 108 ? -1 : (n9 == 114 ? 1 : 0);
                            n8 = n7 + 1;
                        }
                        ++n7;
                    }
                    if (n8 < cArray.length) {
                        stringArray[n + n6] = new String(cArray, n8, cArray.length - n8);
                        rectangle2DArray[n6] = font.getStringBounds(stringArray[n + n6], this.element.getGraph().REFCNTXT);
                        lineMetricsArray[n6] = font.getLineMetrics(stringArray[n + n6], this.element.getGraph().REFCNTXT);
                        if (rectangle2DArray[n6].getWidth() > d3) {
                            d3 = rectangle2DArray[n6].getWidth();
                        }
                        d2 += (double)(2 + font.getSize());
                        nArray[n6] = n9 == 108 ? -1 : (n9 == 114 ? 1 : 0);
                    }
                    if (bl) {
                        grappaPointArray3[n5].y = Grappa.labelGraphOutside ? (grappaPointArray3[n5].y += d * d2) : (grappaPointArray3[n5].y -= d * d2);
                    }
                    d3 /= 2.0;
                    double d4 = grappaPointArray3[n5].y - (d2 /= 2.0);
                    double d5 = 0.0;
                    n7 = 0;
                    while (n7 < rectangle2DArray.length) {
                        d5 = nArray[n7] < 0 ? grappaPointArray3[n5].x - d3 : (nArray[n7] > 0 ? grappaPointArray3[n5].x + d3 - rectangle2DArray[n7].getWidth() : grappaPointArray3[n5].x - rectangle2DArray[n7].getWidth() / 2.0);
                        rectangle2DArray[n7].setRect(d5, d4, rectangle2DArray[n7].getWidth(), rectangle2DArray[n7].getHeight());
                        if (area == null) {
                            area = new Area(rectangle2DArray[n7]);
                        } else {
                            area.add(new Area(rectangle2DArray[n7]));
                        }
                        grappaPointArray[n + n7] = new GrappaPoint(d5, d4 + (double)font.getSize() - 1.0);
                        d4 += (double)(2 + font.getSize());
                        ++n7;
                    }
                }
                ++n5;
            }
        }
        this.font = font;
        this.lpos = grappaPointArray;
        this.lstr = stringArray;
        this.textArea = area;
        this.bboxCheckSet();
        this.lastUpdate = this.lastTextUpdate = l;
    }

    public void updateDecoration() {
        long l = System.currentTimeMillis();
        this.color = (Color)this.element.getAttributeValue("color");
        this.font_color = (Color)this.element.getAttributeValue("fontcolor");
        if (this.element.isEdge() && this.shape != null && this.shape instanceof GrappaLine) {
            int n;
            int n2;
            Edge edge = (Edge)this.element;
            int n3 = n2 = edge.getGraph().isDirected() ? 2 : 0;
            Integer n4 = (Integer)edge.getThisAttributeValue("dir");
            if (n4 != null) {
                n3 = n4;
            }
            edge.direction = n3;
            GrappaLine grappaLine = (GrappaLine)this.shape;
            boolean bl = grappaLine.startsNear((Point2D)edge.getTail().getAttributeValue("pos"));
            if (!bl && edge.getHead() == edge.getTail()) {
                bl = true;
            }
            if (bl) {
                n = grappaLine.getArrowType();
            } else {
                switch (grappaLine.getArrowType()) {
                    case 1: {
                        n = 2;
                    }
                    case 2: {
                        n = 1;
                        break;
                    }
                    default: {
                        n = grappaLine.getArrowType();
                    }
                }
            }
            if (n != n3) {
                if (bl) {
                    n = n3;
                } else {
                    switch (n3) {
                        case 1: {
                            n = 2;
                        }
                        case 2: {
                            n = 1;
                            break;
                        }
                        default: {
                            n = n3;
                        }
                    }
                }
                grappaLine.changeArrowType(n);
                edge.setAttribute("pos", grappaLine);
            }
        }
        this.lastUpdate = this.lastDecorationUpdate = l;
    }

    public void updateImage() {
        long l = System.currentTimeMillis();
        String string = (String)this.element.getAttributeValue("image");
        if (string != null && Grappa.toolkit != null) {
            this.image = null;
            this.imageLoading = true;
            Image image = null;
            try {
                URL uRL = new URL(string);
                image = Grappa.toolkit.getImage(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (image == null) {
                try {
                    image = Grappa.toolkit.getImage(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (image != null) {
                if (Grappa.toolkit.prepareImage(image, -1, -1, this)) {
                    this.image = image;
                    this.imageLoading = false;
                }
            } else {
                this.imageLoading = false;
            }
        } else {
            this.image = null;
            this.imageLoading = false;
        }
        this.lastUpdate = this.lastImageUpdate = l;
    }

    public final boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = true;
        GrappaNexus grappaNexus = this;
        synchronized (grappaNexus) {
            if ((n & 0x20) == 32) {
                bl = false;
                this.image = image;
                this.imageLoading = false;
                this.notifyAll();
            } else if ((n & 0xC0) != 0) {
                bl = false;
                this.imageLoading = false;
                this.notifyAll();
            }
        }
        return bl;
    }

    private void bboxCheckSet() {
        Rectangle2D rectangle2D = this.bbox;
        this.bbox = null;
        Rectangle2D rectangle2D2 = null;
        try {
            try {
                rectangle2D2 = this.rawBounds2D();
            }
            catch (Exception exception) {
                throw (RuntimeException)exception.fillInStackTrace();
            }
            Object var5_3 = null;
            this.bbox = rectangle2D;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.bbox = rectangle2D;
            throw throwable;
        }
        if (rectangle2D2 == null) {
            if (this.element.isSubgraph() && ((Subgraph)this.element).countOfElements(7) == 0) {
                rectangle2D2 = new Rectangle2D.Double();
            } else {
                throw new InternalError("new bounding box of \"" + this.element.getName() + "\" is null");
            }
        }
        if (rectangle2D == null && rectangle2D2 != null || rectangle2D != null && rectangle2D2 == null || rectangle2D2 != null && !rectangle2D2.equals(rectangle2D)) {
            Subgraph subgraph = this.element.getSubgraph();
            while (subgraph != null) {
                if (subgraph.grappaNexus != null) {
                    subgraph.grappaNexus.bbox = null;
                }
                subgraph = subgraph.getSubgraph();
            }
            this.bbox = rectangle2D2;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    private void appendTransform(AffineTransform affineTransform) {
        if (this.xform == null) {
            this.xform = affineTransform;
        } else {
            this.xform.concatenate(affineTransform);
        }
    }

    public Object clone() {
        try {
            GrappaNexus grappaNexus = (GrappaNexus)super.clone();
            if (this.shape != null) {
                grappaNexus.shape = this.shapeType == 1 ? (Shape)((GrappaLine)this.shape).clone() : (this.shapeType == 2 ? (Shape)((Rectangle2D)this.shape).clone() : (this.shapeType == 19 ? (Shape)((RoundRectangle2D)this.shape).clone() : (this.shapeType == 13 ? (Shape)((Ellipse2D)this.shape).clone() : ((this.shapeType & 0x400) != 0 ? (Shape)((GrappaShape)this.shape).clone() : (Shape)((GeneralPath)this.shape).clone()))));
            }
            if (this.textArea != null) {
                grappaNexus.textArea = (Area)this.textArea.clone();
            }
            return grappaNexus;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(double d, double d2) {
        boolean bl = false;
        if (this.shape != null) {
            bl = this.shape.contains(d, d2);
        }
        if (this.textArea != null && !bl && !this.clearText && this.drawText && (this.element.isNode() && this.element.getGraph().getShowNodeLabels() || this.element.isEdge() && this.element.getGraph().getShowEdgeLabels() || this.element.isSubgraph() && this.element.getGraph().getShowSubgraphLabels())) {
            bl = this.textArea.contains(d, d2);
        }
        return bl;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        boolean bl = false;
        if (this.shape != null) {
            bl = this.shape.contains(d, d2, d3, d4);
        }
        if (this.textArea != null && !bl && !this.clearText && this.drawText && (this.element.isNode() && this.element.getGraph().getShowNodeLabels() || this.element.isEdge() && this.element.getGraph().getShowEdgeLabels() || this.element.isSubgraph() && this.element.getGraph().getShowSubgraphLabels())) {
            bl = this.textArea.contains(d, d2, d3, d4);
        }
        return bl;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        if (this.dirty) {
            this.bbox = null;
            this.updateShape();
        }
        if (this.bbox == null) {
            if (this.shape != null) {
                this.bbox = this.shape.getBounds2D();
            }
            if (this.textArea != null && Grappa.shapeBoundText && this.boundText) {
                if (this.bbox == null) {
                    this.bbox = this.textArea.getBounds();
                } else {
                    this.bbox.add(this.textArea.getBounds());
                }
            }
            if (this.bbox.getHeight() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), this.bbox.getWidth(), 0.01);
            }
            if (this.bbox.getWidth() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), 0.01, this.bbox.getHeight());
            }
        }
        return (Rectangle2D)this.bbox.clone();
    }

    Rectangle2D rawBounds2D() {
        if (this.dirty) {
            this.bbox = null;
            this.updateShape();
        }
        if (this.bbox == null) {
            if (this.shape != null) {
                this.bbox = this.shape.getBounds2D();
            }
            if (this.textArea != null && Grappa.shapeBoundText && this.boundText) {
                if (this.bbox == null) {
                    this.bbox = this.textArea.getBounds();
                } else {
                    this.bbox.add(this.textArea.getBounds());
                }
            }
            if (this.bbox.getHeight() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), this.bbox.getWidth(), 0.01);
            }
            if (this.bbox.getWidth() == 0.0) {
                this.bbox.setRect(this.bbox.getX(), this.bbox.getY(), 0.01, this.bbox.getHeight());
            }
        }
        return this.bbox;
    }

    public PathIterator getPathIterator() {
        return new GrappaPathIterator(this, null);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new GrappaPathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(new GrappaPathIterator(this, affineTransform), d);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        boolean bl = false;
        if (this.shape != null) {
            bl = this.shape.intersects(d, d2, d3, d4);
        }
        if (this.textArea != null && !bl && !this.clearText && this.drawText && (this.element.isNode() && this.element.getGraph().getShowNodeLabels() || this.element.isEdge() && this.element.getGraph().getShowEdgeLabels() || this.element.isSubgraph() && this.element.getGraph().getShowSubgraphLabels())) {
            bl = this.textArea.intersects(d, d2, d3, d4);
        }
        return bl;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void update(Observable observable, Object object) {
        Object object2;
        if (!(observable instanceof Attribute)) {
            throw new IllegalArgumentException("expected to be observing attributes only (obs) for \"" + this.element.getName() + "\"");
        }
        Attribute attribute = (Attribute)observable;
        if (object instanceof Object[]) {
            object2 = (Object[])object;
            if (((Object[])object2).length == 2 && object2[0] instanceof Attribute && object2[1] instanceof Long) {
                attribute.deleteObserver(this);
                attribute = (Attribute)object2[0];
                attribute.addObserver(this);
                observable = attribute;
                object = object2[1];
            } else {
                throw new IllegalArgumentException("badly formated update information for \"" + this.element.getName() + "\"");
            }
        }
        if (object instanceof Long) {
            object2 = attribute.getName();
            int n = attribute.getNameHash();
            long l = (Long)object + 1L;
            if (this.element == null || !this.element.reserve()) {
                return;
            }
            this.objs = null;
            switch (this.element.getType()) {
                case 1: {
                    if (GrappaConstants.POS_HASH == n && "pos".equals(object2) || GrappaConstants.WIDTH_HASH == n && "width".equals(object2) || GrappaConstants.HEIGHT_HASH == n && "height".equals(object2) || GrappaConstants.SHAPE_HASH == n && "shape".equals(object2)) {
                        if (this.lastShapeUpdate >= l) break;
                        this.updateShape();
                        if (!Grappa.autoPositionNodeLabel) break;
                        this.updateText();
                        break;
                    }
                    if (GrappaConstants.LABEL_HASH == n && "label".equals(object2) || !Grappa.autoPositionNodeLabel && GrappaConstants.LP_HASH == n && "lp".equals(object2) || GrappaConstants.FONTSIZE_HASH == n && "fontsize".equals(object2) || GrappaConstants.FONTNAME_HASH == n && "fontname".equals(object2) || GrappaConstants.FONTSTYLE_HASH == n && "fontstyle".equals(object2)) {
                        if (this.lastTextUpdate >= l) break;
                        this.updateText();
                        break;
                    }
                    if (GrappaConstants.STYLE_HASH == n && "style".equals(object2)) {
                        if (this.lastStyleUpdate >= l) break;
                        this.updateStyle();
                        break;
                    }
                    if (GrappaConstants.COLOR_HASH == n && "color".equals(object2) || GrappaConstants.FONTCOLOR_HASH == n && "fontcolor".equals(object2)) {
                        if (this.lastDecorationUpdate >= l) break;
                        this.updateDecoration();
                        break;
                    }
                    if (GrappaConstants.IMAGE_HASH == n && "image".equals(object2)) {
                        if (this.lastImageUpdate >= l) break;
                        this.updateImage();
                        break;
                    }
                    throw new InternalError("update called for \"" + this.element.getName() + "\" with an unmonitored attribute: " + (String)object2);
                }
                case 2: {
                    if (GrappaConstants.POS_HASH == n && "pos".equals(object2)) {
                        if (this.lastShapeUpdate >= l) break;
                        this.updateShape();
                        break;
                    }
                    if (GrappaConstants.LABEL_HASH == n && "label".equals(object2) || GrappaConstants.LP_HASH == n && "lp".equals(object2) || GrappaConstants.FONTSIZE_HASH == n && "fontsize".equals(object2) || GrappaConstants.FONTNAME_HASH == n && "fontname".equals(object2) || GrappaConstants.FONTSTYLE_HASH == n && "fontstyle".equals(object2)) {
                        if (this.lastTextUpdate >= l) break;
                        this.updateText();
                        break;
                    }
                    if (GrappaConstants.STYLE_HASH == n && "style".equals(object2)) {
                        if (this.lastStyleUpdate >= l) break;
                        this.updateStyle();
                        break;
                    }
                    if (GrappaConstants.COLOR_HASH == n && "color".equals(object2) || GrappaConstants.DIR_HASH == n && "dir".equals(object2) || GrappaConstants.FONTCOLOR_HASH == n && "fontcolor".equals(object2)) {
                        if (this.lastDecorationUpdate >= l) break;
                        this.updateDecoration();
                        break;
                    }
                    if (GrappaConstants.IMAGE_HASH == n && "image".equals(object2)) {
                        if (this.lastImageUpdate >= l) break;
                        this.updateImage();
                        break;
                    }
                    throw new InternalError("update called for \"" + this.element.getName() + "\" with an unmonitored attribute: " + (String)object2);
                }
                case 4: {
                    if (GrappaConstants.LABEL_HASH == n && "label".equals(object2) || GrappaConstants.LP_HASH == n && "lp".equals(object2) || GrappaConstants.FONTSIZE_HASH == n && "fontsize".equals(object2) || GrappaConstants.FONTNAME_HASH == n && "fontname".equals(object2) || GrappaConstants.FONTSTYLE_HASH == n && "fontstyle".equals(object2)) {
                        if (this.lastTextUpdate >= l) break;
                        this.updateText();
                        break;
                    }
                    if (GrappaConstants.STYLE_HASH == n && "style".equals(object2)) {
                        if (this.lastStyleUpdate >= l) break;
                        this.updateStyle();
                        break;
                    }
                    if (GrappaConstants.COLOR_HASH == n && "color".equals(object2) || GrappaConstants.FONTCOLOR_HASH == n && "fontcolor".equals(object2)) {
                        if (this.lastDecorationUpdate >= l) break;
                        this.updateDecoration();
                        break;
                    }
                    if (GrappaConstants.IMAGE_HASH == n && "image".equals(object2)) {
                        if (this.lastImageUpdate >= l) break;
                        this.updateImage();
                        break;
                    }
                    if (GrappaConstants.MINBOX_HASH == n && "minbox".equals(object2) || GrappaConstants.MINSIZE_HASH == n && "minsize".equals(object2)) {
                        this.bbox = null;
                        break;
                    }
                    throw new InternalError("update called for \"" + this.element.getName() + "\" with an unmonitored attribute: " + (String)object2);
                }
            }
        } else {
            throw new InternalError("update called for shape of element \"" + this.element.getName() + "\" without proper format");
        }
        this.element.release();
    }

    void draw(Graphics2D graphics2D) {
        if (this.shape instanceof CustomRenderer) {
            ((CustomRenderer)((Object)this.shape)).draw(graphics2D);
        } else {
            graphics2D.draw(this);
        }
    }

    void fill(Graphics2D graphics2D) {
        if (this.shape instanceof CustomRenderer) {
            ((CustomRenderer)((Object)this.shape)).fill(graphics2D);
        } else {
            graphics2D.fill(this);
        }
    }

    void drawImage(Graphics2D graphics2D) {
        Shape shape;
        if (Grappa.waitForImages && this.imageLoading) {
            shape = this;
            synchronized (shape) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.image != null) {
            if (this.shape instanceof CustomRenderer) {
                ((CustomRenderer)((Object)this.shape)).drawImage(graphics2D);
            } else {
                shape = this.shape.getBounds();
                Shape shape2 = graphics2D.getClip();
                graphics2D.clip(this.shape);
                graphics2D.drawImage(this.image, ((Rectangle)shape).x, ((Rectangle)shape).y, ((Rectangle)shape).width, ((Rectangle)shape).height, null);
                graphics2D.setClip(shape2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

