/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GrappaColor;
import att.grappa.GrappaConstants;
import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Hashtable;

public class GrappaStyle
implements GrappaConstants,
Cloneable {
    private int elementType;
    public static final String DEFAULT_SET_STRING = "__default__";
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DASHED = 1;
    public static final int STYLE_DOTTED = 2;
    public static final int STYLE_DASH = 3;
    public static final int STYLE_DASH_PHASE = 4;
    public static final int STYLE_LINE_WIDTH = 5;
    public static final int STYLE_LINE_COLOR = 6;
    public static final int STYLE_FILLED = 7;
    public static final int STYLE_DIAGONALS = 8;
    public static final int STYLE_ROUNDED = 9;
    public static final int STYLE_CAP_BUTT = 10;
    public static final int STYLE_CAP_ROUND = 11;
    public static final int STYLE_CAP_SQUARE = 12;
    public static final int STYLE_JOIN_BEVEL = 13;
    public static final int STYLE_JOIN_MITER = 14;
    public static final int STYLE_JOIN_ROUND = 15;
    public static final int STYLE_MITER_LIMIT = 16;
    public static final int STYLE_FIXED_SIZE = 17;
    public static final int STYLE_INVIS = 18;
    public static final int STYLE_OLD_BOLD = 100;
    public static final int STYLE_OLD_ITALIC = 101;
    public static final int STYLE_OLD_PLAIN = 102;
    public static final Color STYLE_LINE_COLOR_DEFAULT = GrappaColor.getColor("black", null);
    public static final int STYLE_LINE_STYLE_DEFAULT = 0;
    public static final float STYLE_LINE_WIDTH_DEFAULT = 1.0f;
    public static final int STYLE_CAP_DEFAULT = 0;
    public static final int STYLE_JOIN_DEFAULT = 2;
    public static final float STYLE_MITER_LIMIT_DEFAULT = 0.0f;
    public static final float[] STYLE_DASH_DEFAULT = null;
    public static final float STYLE_DASH_PHASE_DEFAULT = 0.0f;
    public static final boolean STYLE_ROUNDED_DEFAULT = false;
    public static final boolean STYLE_DIAGONALS_DEFAULT = false;
    public static final boolean STYLE_FILLED_DEFAULT = false;
    public static final boolean STYLE_INVIS_DEFAULT = false;
    public static final boolean STYLE_FIXED_SIZE_DEFAULT = false;
    static BasicStroke defaultStroke = new BasicStroke(1.0f, 0, 2, 0.0f, STYLE_DASH_DEFAULT, 0.0f);
    static String defaultStrokeString = GrappaStyle.generateStrokeString(1.0f, 0, 2, 0.0f, STYLE_DASH_DEFAULT, 0.0f);
    private static Hashtable styleTypes = new Hashtable(20);
    private static Hashtable strokeCache = new Hashtable(4);
    Color line_color = STYLE_LINE_COLOR_DEFAULT;
    int line_style = 0;
    float line_width = 1.0f;
    int cap = 0;
    int join = 2;
    float miter_limit = 0.0f;
    float[] dash = STYLE_DASH_DEFAULT;
    float dash_phase = 0.0f;
    boolean rounded = false;
    boolean diagonals = false;
    boolean filled = false;
    boolean invis = false;
    boolean fixed_size = false;
    Integer font_style = null;
    BasicStroke stroke = defaultStroke;

    public GrappaStyle(int n, String string) {
        if ((n & 0xF) != n) {
            throw new RuntimeException("type must specify node, edge or subgraph");
        }
        this.elementType = n;
        this.updateStyle(string);
    }

    /*
     * Unable to fully structure code
     */
    public void updateStyle(String var1_1) {
        this.stroke = GrappaStyle.defaultStroke;
        this.line_color = GrappaStyle.STYLE_LINE_COLOR_DEFAULT;
        this.line_style = 0;
        this.line_width = 1.0f;
        this.cap = 0;
        this.join = 2;
        this.miter_limit = 0.0f;
        this.dash = GrappaStyle.STYLE_DASH_DEFAULT;
        this.dash_phase = 0.0f;
        this.rounded = false;
        this.diagonals = false;
        this.filled = false;
        this.invis = false;
        this.fixed_size = false;
        this.font_style = null;
        if (var1_1 == null) {
            return;
        }
        var2_2 = var1_1.length();
        if (var2_2 == 0 || var1_1.equals("__default__")) {
            return;
        }
        var3_3 = null;
        var4_4 = null;
        var5_5 = -1;
        var6_6 = -1;
        var7_7 = false;
        var8_8 = true;
        var9_9 = false;
        var10_10 = 0;
        var11_11 = 0;
        while (var10_10 < var2_2) {
            block62: {
                if (Character.isWhitespace(var12_12 = var1_1.charAt(var10_10++))) continue;
                if (var12_12 == '(') {
                    if (var7_7) {
                        throw new RuntimeException("style attribute has nested parentheses");
                    }
                    if (!var9_9) {
                        throw new RuntimeException("style attribute has parentheses without keyword");
                    }
                    if (var6_6 < 0) {
                        throw new RuntimeException("style attribute (" + var3_3 + ") has unexpected modifier");
                    }
                    var7_7 = true;
                    var8_8 = true;
                    var9_9 = false;
                    continue;
                }
                if (var12_12 == ')') {
                    if (!var7_7) {
                        throw new RuntimeException("style attribute has unmatched right parenthesis");
                    }
                    var7_7 = false;
                    var8_8 = false;
                    var9_9 = false;
                    continue;
                }
                if (var12_12 == ',') {
                    if (var7_7) {
                        throw new RuntimeException("style attribute has comma within parentheses");
                    }
                    var8_8 = true;
                    var9_9 = false;
                    continue;
                }
                if (!var8_8) {
                    throw new RuntimeException("style attribute (" + var3_3 + ") has bad format");
                }
                var11_11 = var10_10 - 1;
                if (!var7_7) ** GOTO lbl71
                var13_13 = 0;
                while (var10_10 < var2_2 && ((var12_12 = var1_1.charAt(var10_10)) != ')' || var13_13 > 0)) {
                    if (var12_12 == '(') {
                        ++var13_13;
                    } else if (var12_12 == ')') {
                        --var13_13;
                    }
                    ++var10_10;
                }
                break block62;
lbl-1000:
                // 1 sources

                {
                    ++var10_10;
lbl71:
                    // 2 sources

                    ** while (var10_10 < var2_2 && (var12_12 = var1_1.charAt((int)var10_10)) != ',' && var12_12 != '(' && var12_12 != ')')
                }
            }
            var3_3 = var1_1.substring(var11_11, var10_10);
            if (var7_7) {
                if (var6_6 == -1) {
                    throw new RuntimeException("style attribute modifier (" + var3_3 + ") is unexpected");
                }
                switch (var6_6) {
                    case 3: {
                        this.line_style = var6_6;
                        try {
                            this.dash = GrappaSupport.floatArrayForTuple(var3_3);
                            break;
                        }
                        catch (NumberFormatException var13_14) {
                            throw new RuntimeException("dash style attribute modifier (" + var3_3 + ") is not a comma-delimited floating point tuple");
                        }
                    }
                    case 4: {
                        try {
                            this.dash_phase = Float.valueOf(var3_3).floatValue();
                            break;
                        }
                        catch (NumberFormatException var13_15) {
                            throw new RuntimeException("dash phase style attribute modifier (" + var3_3 + ") is not a floating point number");
                        }
                    }
                    case 5: {
                        try {
                            this.line_width = Float.valueOf(var3_3).floatValue();
                            break;
                        }
                        catch (NumberFormatException var13_16) {
                            throw new RuntimeException("line width style attribute modifier (" + var3_3 + ") is not a floating point number");
                        }
                    }
                    case 16: {
                        try {
                            this.miter_limit = Float.valueOf(var3_3).floatValue();
                            break;
                        }
                        catch (NumberFormatException var13_17) {
                            throw new RuntimeException("miter limit style attribute modifier (" + var3_3 + ") is not a floating point number");
                        }
                    }
                    case 6: {
                        this.line_color = GrappaColor.getColor(var3_3, null);
                        break;
                    }
                    case 7: {
                        this.filled = Boolean.valueOf(var3_3);
                        break;
                    }
                    case 18: {
                        this.invis = Boolean.valueOf(var3_3);
                        break;
                    }
                    case 8: {
                        this.diagonals = Boolean.valueOf(var3_3);
                        break;
                    }
                    case 9: {
                        this.rounded = Boolean.valueOf(var3_3);
                        break;
                    }
                    case 17: {
                        this.fixed_size = Boolean.valueOf(var3_3);
                        break;
                    }
                    default: {
                        throw new RuntimeException("style attribute (" + var3_3 + ") has bad format");
                    }
                }
                var6_6 = -1;
                continue;
            }
            var4_4 = GrappaStyle.styleTypes.get(var3_3.toLowerCase());
            if (var4_4 == null || !(var4_4 instanceof Integer)) {
                throw new RuntimeException("style attribute (" + var3_3 + ") is unrecognized or badly implemented");
            }
            var5_5 = var4_4;
            var6_6 = -1;
            switch (var5_5) {
                case 0: {
                    this.line_style = var5_5;
                    this.dash = null;
                    this.dash_phase = 0.0f;
                    break;
                }
                case 1: {
                    this.line_style = var5_5;
                    this.dash = new float[]{12.0f, 12.0f};
                    this.dash_phase = 0.0f;
                    break;
                }
                case 2: {
                    this.line_style = var5_5;
                    this.dash = new float[]{2.0f, 2.0f};
                    this.dash_phase = 0.0f;
                    break;
                }
                case 7: {
                    var6_6 = var5_5;
                    this.filled = true;
                    break;
                }
                case 18: {
                    var6_6 = var5_5;
                    this.invis = true;
                    break;
                }
                case 8: {
                    var6_6 = var5_5;
                    this.diagonals = true;
                    break;
                }
                case 9: {
                    var6_6 = var5_5;
                    this.rounded = true;
                    break;
                }
                case 10: {
                    this.cap = 0;
                    break;
                }
                case 11: {
                    this.cap = 1;
                    break;
                }
                case 12: {
                    this.cap = 2;
                    break;
                }
                case 13: {
                    this.cap = 2;
                    break;
                }
                case 14: {
                    this.cap = 0;
                    break;
                }
                case 15: {
                    this.cap = 1;
                    break;
                }
                case 17: {
                    var6_6 = var5_5;
                    this.fixed_size = true;
                    break;
                }
                case 100: {
                    this.font_style = new Integer(1);
                    break;
                }
                case 101: {
                    this.font_style = new Integer(2);
                    break;
                }
                case 102: {
                    this.font_style = new Integer(0);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 16: {
                    var6_6 = var5_5;
                    break;
                }
                default: {
                    throw new RuntimeException("style attribute (" + var3_3 + ") has bad format");
                }
            }
            if (var6_6 == -1) continue;
            var9_9 = true;
        }
        if (var7_7) {
            throw new RuntimeException("style attribute has unmatched left parenthesis");
        }
        var13_18 = GrappaStyle.generateStrokeString(this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase);
        this.stroke = (BasicStroke)GrappaStyle.strokeCache.get(var13_18);
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase);
            GrappaStyle.strokeCache.put(var13_18, this.stroke);
        }
    }

    private static String generateStrokeString(float f, int n, int n2, float f2, float[] fArray, float f3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(f);
        stringBuffer.append(",");
        stringBuffer.append(n);
        stringBuffer.append(",");
        stringBuffer.append(n2);
        stringBuffer.append(",");
        stringBuffer.append(f2);
        stringBuffer.append(",");
        if (fArray == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("{");
            stringBuffer.append(fArray[0]);
            int n3 = 1;
            while (n3 < fArray.length) {
                stringBuffer.append(",");
                stringBuffer.append(fArray[n3]);
                ++n3;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(",");
        stringBuffer.append(f3);
        return stringBuffer.toString();
    }

    public String toAttributeString() {
        return GrappaStyle.generateStyleString(this.line_color, this.line_style, this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase, this.rounded, this.diagonals, this.filled, this.invis, this.fixed_size, this.font_style, false, this.elementType);
    }

    public String toString() {
        return GrappaStyle.generateStyleString(this.line_color, this.line_style, this.line_width, this.cap, this.join, this.miter_limit, this.dash, this.dash_phase, this.rounded, this.diagonals, this.filled, this.invis, this.fixed_size, this.font_style, true, this.elementType);
    }

    private static String generateStyleString(Color color, int n, float f, int n2, int n3, float f2, float[] fArray, float f3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Integer n4, boolean bl6, int n5) {
        StringBuffer stringBuffer = null;
        String string = null;
        Object[] objectArray = new Object[]{"%g", null};
        if (bl6 || color != STYLE_LINE_COLOR_DEFAULT && STYLE_LINE_COLOR_DEFAULT != null && !STYLE_LINE_COLOR_DEFAULT.equals(color)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append("lineColor(");
            string = GrappaColor.getColorName(color);
            if (string == null) {
                float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                stringBuffer.append(GrappaSupportPrintf.sprintf(new Object[]{"%g,%g,%g", new Float(fArray2[0]), new Float(fArray2[1]), new Float(fArray2[2])}));
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(')');
        }
        if (bl6 || n != 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            switch (n) {
                case 0: {
                    stringBuffer.append("solid");
                    break;
                }
                case 1: {
                    stringBuffer.append("dashed");
                    break;
                }
                case 2: {
                    stringBuffer.append("dotted");
                    break;
                }
                case 3: {
                    if (fArray == null) {
                        stringBuffer.append("solid");
                        break;
                    }
                    stringBuffer.append("dash(");
                    objectArray[1] = new Float(fArray[0]);
                    stringBuffer.append(GrappaSupportPrintf.sprintf(objectArray));
                    int n6 = 1;
                    while (n6 < fArray.length) {
                        stringBuffer.append(',');
                        objectArray[1] = new Float(fArray[n6]);
                        stringBuffer.append(GrappaSupportPrintf.sprintf(objectArray));
                        ++n6;
                    }
                    stringBuffer.append(')');
                    break;
                }
                default: {
                    throw new InternalError("unexpected lineStyle (" + n + ")");
                }
            }
        }
        if (bl6 || f != 1.0f) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append("lineWidth(");
            objectArray[1] = new Float(f);
            stringBuffer.append(GrappaSupportPrintf.sprintf(objectArray));
            stringBuffer.append(')');
        }
        if (bl6 || n2 != 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            switch (n2) {
                case 0: {
                    stringBuffer.append("capButt");
                    break;
                }
                case 1: {
                    stringBuffer.append("capRound");
                    break;
                }
                case 2: {
                    stringBuffer.append("capSquare");
                    break;
                }
                default: {
                    throw new InternalError("unexpected cap type (" + n2 + ")");
                }
            }
        }
        if (bl6 || n3 != 2) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            switch (n3) {
                case 2: {
                    stringBuffer.append("joinBevel");
                    break;
                }
                case 0: {
                    stringBuffer.append("joinMiter");
                    break;
                }
                case 1: {
                    stringBuffer.append("joinRound");
                    break;
                }
                default: {
                    throw new InternalError("unexpected join type (" + n3 + ")");
                }
            }
        }
        if (bl6 || f2 != 0.0f) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append("miterLimit(");
            objectArray[1] = new Float(f2);
            stringBuffer.append(GrappaSupportPrintf.sprintf(objectArray));
            stringBuffer.append(')');
        }
        if (bl6 || f3 != 0.0f) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append("dashPhase(");
            objectArray[1] = new Float(f3);
            stringBuffer.append(GrappaSupportPrintf.sprintf(objectArray));
            stringBuffer.append(')');
        }
        if (n5 > 0 && (n5 & 1) == 1 && (bl6 || bl)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            if (bl) {
                stringBuffer.append("rounded");
            } else {
                stringBuffer.append("rounded(false)");
            }
        }
        if (n5 > 0 && (n5 & 1) == 1 && (bl6 || bl2)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            if (bl2) {
                stringBuffer.append("diagonals");
            } else {
                stringBuffer.append("diagonals(false)");
            }
        }
        if (n5 > 0 && (n5 & 5) != 0 && (bl6 || bl3)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            if (bl3) {
                stringBuffer.append("filled");
            } else {
                stringBuffer.append("filled(false)");
            }
        }
        if (n5 > 0 && (n5 & 7) != 0 && (bl6 || bl4)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            if (bl4) {
                stringBuffer.append("invis");
            } else {
                stringBuffer.append("invis(false)");
            }
        }
        if (bl6 || bl5) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            if (bl5) {
                stringBuffer.append("fixedSize");
            } else {
                stringBuffer.append("fixedSize(false)");
            }
        }
        if (n4 != null) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            if (n4 == 1) {
                stringBuffer.append("bold");
            } else if (n4 == 2) {
                stringBuffer.append("italic");
            } else {
                stringBuffer.append("plain");
            }
        }
        string = stringBuffer == null ? "" : stringBuffer.toString();
        return string;
    }

    public Color getLineColor() {
        return this.line_color;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public float getLineWidth() {
        return this.line_width;
    }

    public int getCapStyle() {
        return this.cap;
    }

    public int getJoinStyle() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miter_limit;
    }

    public float[] getDash() {
        if (this.dash == null) {
            return null;
        }
        return (float[])this.dash.clone();
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public boolean getRounded() {
        return this.rounded;
    }

    public boolean getDiagonals() {
        return this.diagonals;
    }

    public boolean getFilled() {
        return this.filled;
    }

    public boolean getInvis() {
        return this.invis;
    }

    public boolean getFixedSize() {
        return this.fixed_size;
    }

    public int getFontStyle() {
        if (this.font_style == null) {
            return 0;
        }
        return this.font_style;
    }

    public Object clone() {
        try {
            GrappaStyle grappaStyle = (GrappaStyle)super.clone();
            grappaStyle.dash = this.getDash();
            return grappaStyle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        styleTypes.put("solid", new Integer(0));
        styleTypes.put("dashed", new Integer(1));
        styleTypes.put("dotted", new Integer(2));
        styleTypes.put("dash", new Integer(3));
        styleTypes.put("dashphase", new Integer(4));
        styleTypes.put("dash_phase", new Integer(4));
        styleTypes.put("width", new Integer(5));
        styleTypes.put("linewidth", new Integer(5));
        styleTypes.put("line_width", new Integer(5));
        styleTypes.put("setlinewidth", new Integer(5));
        styleTypes.put("color", new Integer(6));
        styleTypes.put("linecolor", new Integer(6));
        styleTypes.put("line_color", new Integer(6));
        styleTypes.put("filled", new Integer(7));
        styleTypes.put("invis", new Integer(18));
        styleTypes.put("diagonals", new Integer(8));
        styleTypes.put("rounded", new Integer(9));
        styleTypes.put("capbutt", new Integer(10));
        styleTypes.put("cap_butt", new Integer(10));
        styleTypes.put("capround", new Integer(11));
        styleTypes.put("cap_round", new Integer(11));
        styleTypes.put("capsquare", new Integer(12));
        styleTypes.put("cap_square", new Integer(12));
        styleTypes.put("joinbevel", new Integer(13));
        styleTypes.put("join_bevel", new Integer(13));
        styleTypes.put("joinmiter", new Integer(14));
        styleTypes.put("join_miter", new Integer(14));
        styleTypes.put("joinround", new Integer(15));
        styleTypes.put("join_round", new Integer(15));
        styleTypes.put("miterlimit", new Integer(16));
        styleTypes.put("miter_limit", new Integer(16));
        styleTypes.put("fixedsize", new Integer(17));
        styleTypes.put("fixed_size", new Integer(17));
        styleTypes.put("bold", new Integer(100));
        styleTypes.put("italic", new Integer(101));
        styleTypes.put("normal", new Integer(102));
        styleTypes.put("plain", new Integer(102));
        strokeCache.put(defaultStrokeString, defaultStroke);
    }
}

