/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.GrappaPoint;
import att.grappa.Subgraph;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Node
extends Element {
    public static final String defaultNamePrefix = "N";
    private Vector inEdges = null;
    private Vector outEdges = null;
    private Vector Ports = null;

    public Node(Subgraph subgraph, String string) {
        super(1, subgraph);
        this.setName(string);
        this.nodeAttrsOfInterest();
    }

    public Node(Subgraph subgraph) {
        this(subgraph, (String)null);
    }

    private void nodeAttrsOfInterest() {
        this.attrOfInterest("distortion");
        this.attrOfInterest("height");
        this.attrOfInterest("orientation");
        this.attrOfInterest("peripheries");
        this.attrOfInterest("pos");
        this.attrOfInterest("sides");
        this.attrOfInterest("skew");
        this.attrOfInterest("style");
        this.attrOfInterest("width");
    }

    public boolean isNode() {
        return true;
    }

    public int getType() {
        return 1;
    }

    void setName() {
        String string = this.name;
        do {
            this.name = defaultNamePrefix + this.getId() + "_" + System.currentTimeMillis();
        } while (this.getGraph().findNodeByName(this.name) != null);
        if (string != null) {
            this.getSubgraph().removeNode(string);
        }
        this.getSubgraph().addNode(this);
        this.canonName = null;
    }

    void setName(String string) throws IllegalArgumentException {
        if (string == null) {
            this.setName();
            return;
        }
        String string2 = this.name;
        if (string2 != null && string2.equals(string)) {
            return;
        }
        if (this.getGraph().findNodeByName(string) != null) {
            throw new IllegalArgumentException("node name (" + string + ") is not unique");
        }
        if (string2 != null) {
            this.getSubgraph().removeNode(string2);
        }
        this.name = string;
        this.getSubgraph().addNode(this);
        this.canonName = null;
    }

    public synchronized void addEdge(Edge edge, boolean bl) {
        if (edge == null) {
            return;
        }
        if (bl) {
            if (this.inEdges == null) {
                this.inEdges = new Vector();
            }
            if (!this.inEdges.contains(edge)) {
                this.inEdges.addElement(edge);
            }
        } else {
            if (this.outEdges == null) {
                this.outEdges = new Vector();
            }
            this.outEdges.addElement(edge);
            if (!this.outEdges.contains(edge)) {
                this.outEdges.addElement(edge);
            }
        }
    }

    public Edge findOutEdgeByKey(Node node, String string) {
        if (node == null || string == null || this.outEdges == null) {
            return null;
        }
        Edge edge = null;
        int n = 0;
        while (n < this.outEdges.size()) {
            edge = (Edge)this.outEdges.elementAt(n);
            if (node == edge.getHead() && string.equals(edge.getKey())) {
                return edge;
            }
            ++n;
        }
        return null;
    }

    public Edge findInEdgeByKey(Node node, String string) {
        if (node == null || string == null || this.inEdges == null) {
            return null;
        }
        Edge edge = null;
        int n = 0;
        while (n < this.inEdges.size()) {
            edge = (Edge)this.inEdges.elementAt(n);
            if (node == edge.getTail() && string.equals(edge.getKey())) {
                return edge;
            }
            ++n;
        }
        return null;
    }

    public GrappaPoint getCenterPoint() {
        GrappaPoint grappaPoint = (GrappaPoint)this.getAttributeValue("pos");
        if (grappaPoint == null) {
            grappaPoint = new GrappaPoint();
        }
        if (!Grappa.centerPointNodes) {
            Double d = (Double)this.getAttributeValue("width");
            Double d2 = (Double)this.getAttributeValue("height");
            if (d != null && d2 != null) {
                grappaPoint = new GrappaPoint(grappaPoint.x - d / 2.0, grappaPoint.y - d2 / 2.0);
            }
        }
        return grappaPoint;
    }

    public synchronized void removeEdge(Edge edge, boolean bl) {
        if (edge == null) {
            return;
        }
        if (bl) {
            if (this.inEdges == null) {
                return;
            }
            this.inEdges.removeElement(edge);
        } else {
            if (this.outEdges == null) {
                return;
            }
            this.outEdges.removeElement(edge);
        }
    }

    public void printNode(PrintWriter printWriter) {
        this.printElement(printWriter);
    }

    public static int attributeType(String string) {
        int n = -1;
        if (string != null) {
            int n2 = string.hashCode();
            if (n2 == GrappaConstants.DISTORTION_HASH && string.equals("distortion")) {
                n = 4;
            } else if (n2 == GrappaConstants.ORIENTATION_HASH && string.equals("orientation")) {
                n = 4;
            } else if (n2 == GrappaConstants.PERIPHERIES_HASH && string.equals("peripheries")) {
                n = 7;
            } else if (n2 == GrappaConstants.POS_HASH && string.equals("pos")) {
                n = 9;
            } else if (n2 == GrappaConstants.SHAPE_HASH && string.equals("shape")) {
                n = 10;
            } else if (n2 == GrappaConstants.SIDES_HASH && string.equals("sides")) {
                n = 7;
            } else if (n2 == GrappaConstants.SKEW_HASH && string.equals("skew")) {
                n = 4;
            } else {
                return Element.attributeType(string);
            }
        }
        return n;
    }

    public Enumeration edgeElements() {
        return new Enumerator(this.inEdges, this.outEdges);
    }

    public Enumeration inEdgeElements() {
        return new Enumerator(this.inEdges, null);
    }

    public Enumeration outEdgeElements() {
        return new Enumerator(null, this.outEdges);
    }

    class Enumerator
    implements Enumeration {
        int inCnt = 0;
        int outCnt = 0;
        Vector inEdges = null;
        Vector outEdges = null;

        Enumerator(Vector vector, Vector vector2) {
            this.inCnt = vector == null ? 0 : vector.size();
            this.outCnt = vector2 == null ? 0 : vector2.size();
            this.inEdges = vector;
            this.outEdges = vector2;
        }

        public boolean hasMoreElements() {
            int n;
            if (this.inCnt > 0 && this.inCnt > (n = this.inEdges.size())) {
                this.inCnt = n;
            }
            if (this.outCnt > 0 && this.outCnt > (n = this.outEdges.size())) {
                this.outCnt = n;
            }
            return this.inCnt + this.outCnt > 0;
        }

        public Object nextElement() {
            Node node = Node.this;
            synchronized (node) {
                int n;
                if (this.inCnt > 0 && this.inCnt > (n = this.inEdges.size())) {
                    this.inCnt = n;
                }
                if (this.inCnt > 0) {
                    Object e = this.inEdges.elementAt(--this.inCnt);
                    return e;
                }
                if (this.outCnt > 0 && this.outCnt > (n = this.outEdges.size())) {
                    this.outCnt = n;
                }
                if (this.outCnt > 0) {
                    Object e = this.outEdges.elementAt(--this.outCnt);
                    return e;
                }
                throw new NoSuchElementException("Node$Enumerator");
            }
        }
    }
}

