/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.GrappaConstants;
import att.grappa.GrappaSupportRects;
import att.grappa.Node;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

class TableField
implements GrappaConstants {
    private Dimension size = new Dimension();
    private Rectangle bounds = new Rectangle();
    private Rectangle textBounds = null;
    private TableField[] subFields = null;
    private int subFieldsUsed = 0;
    private boolean orientLR = false;
    private String idTag = null;
    private String text = null;
    private TableField parent = null;

    TableField() {
    }

    void setParent(TableField tableField) {
        this.parent = tableField;
    }

    TableField getTopMost() {
        TableField tableField = this;
        while (tableField.getParent() != null) {
            tableField = tableField.getParent();
        }
        return tableField;
    }

    TableField getParent() {
        return this.parent;
    }

    String getText() {
        return this.text;
    }

    String getIdentifier() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isLR()) {
            stringBuffer.append("LR:");
        } else {
            stringBuffer.append("TB:");
        }
        stringBuffer.append(this.fieldCount());
        stringBuffer.append('(');
        stringBuffer.append(this.text);
        stringBuffer.append(')');
        TableField tableField = this.getParent();
        while (tableField != null) {
            stringBuffer.append(',');
            stringBuffer.append(tableField.fieldCount());
            stringBuffer.append('(');
            stringBuffer.append(tableField.getText());
            stringBuffer.append(')');
            tableField = tableField.getParent();
        }
        return stringBuffer.toString();
    }

    Rectangle getBounds() {
        return this.bounds;
    }

    void setBounds(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
    }

    void setBounds(Rectangle rectangle) {
        this.bounds.setBounds(rectangle);
    }

    Dimension getSize() {
        return this.size;
    }

    void setSize(int n, int n2) {
        this.size.setSize(n, n2);
    }

    void setSize(Dimension dimension) {
        this.size.setSize(dimension.width, dimension.height);
    }

    boolean hasFields() {
        return this.subFields != null && this.subFields.length != 0 && this.subFieldsUsed != 0;
    }

    synchronized int subfields(int n) {
        if (n < 1) {
            return 0;
        }
        this.subFields = new TableField[n];
        return this.subFields.length;
    }

    int fieldCount() {
        if (this.subFields == null) {
            return 0;
        }
        return this.subFieldsUsed;
    }

    synchronized void addField(TableField tableField) {
        this.subFields[this.subFieldsUsed++] = tableField;
    }

    TableField fieldAt(int n) {
        if (n < 0 || n >= this.subFieldsUsed) {
            return null;
        }
        return this.subFields[n];
    }

    boolean isLR() {
        return this.orientLR;
    }

    void setLR(boolean bl) {
        this.orientLR = bl;
    }

    String getId() {
        return this.idTag;
    }

    void setId(String string) {
        this.idTag = null;
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\u00a0') {
                cArray[n] = 32;
                bl = true;
            }
            ++n;
        }
        this.idTag = bl ? new String(cArray, 0, cArray.length) : string;
    }

    Dimension sizeFields() {
        return this.sizeUpFields(this);
    }

    private Dimension sizeUpFields(TableField tableField) {
        int n = tableField.fieldCount();
        if (n == 0) {
            if (tableField.getTextBounds() != null) {
                tableField.setSize(tableField.getTextBounds().getSize());
            } else {
                tableField.setSize(0, 0);
            }
        } else {
            Dimension dimension = null;
            Dimension dimension2 = new Dimension();
            int n2 = 0;
            while (n2 < n) {
                dimension = this.sizeUpFields(tableField.fieldAt(n2));
                if (tableField.isLR()) {
                    dimension2.width += dimension.width;
                    dimension2.height = dimension2.height > dimension.height ? dimension2.height : dimension.height;
                } else {
                    dimension2.width = dimension2.width > dimension.width ? dimension2.width : dimension.width;
                    dimension2.height += dimension.height;
                }
                ++n2;
            }
            tableField.setSize(dimension2);
        }
        return tableField.getSize();
    }

    Dimension resizeFields(Dimension dimension) {
        this.resizeUpFields(this, dimension);
        return this.getSize();
    }

    void resizeUpFields(TableField tableField, Dimension dimension) {
        Dimension dimension2 = new Dimension(dimension.width - tableField.getSize().width, dimension.height - tableField.getSize().height);
        tableField.setSize(dimension);
        int n = tableField.fieldCount();
        if (n == 0) {
            return;
        }
        double d = 0.0;
        d = tableField.isLR() ? (double)dimension2.width / (double)n : (double)dimension2.height / (double)n;
        TableField tableField2 = null;
        int n2 = 0;
        Dimension dimension3 = dimension2;
        int n3 = 0;
        while (n3 < n) {
            tableField2 = tableField.fieldAt(n3);
            n2 = (int)Math.floor((double)(n3 + 1) * d) - (int)Math.floor((double)n3 * d);
            if (tableField.isLR()) {
                dimension3.setSize(tableField2.getSize().width + n2, dimension.height);
            } else {
                dimension3.setSize(dimension.width, tableField2.getSize().height + n2);
            }
            this.resizeUpFields(tableField2, dimension3);
            ++n3;
        }
    }

    void positionFields(Point point) {
        this.posFields(this, point);
    }

    private void posFields(TableField tableField, Point point) {
        tableField.setBounds(point.x, point.y, tableField.getSize().width, tableField.getSize().height);
        Rectangle rectangle = tableField.getBounds();
        Rectangle rectangle2 = tableField.getTopMost().getBounds();
        int n = Math.max(rectangle.x, rectangle2.x);
        rectangle.width = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width) - n;
        rectangle.x = n;
        n = Math.max(rectangle.y, rectangle2.y);
        rectangle.height = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height) - n;
        rectangle.y = n;
        int n2 = tableField.fieldCount();
        if (n2 == 0) {
            return;
        }
        TableField tableField2 = null;
        int n3 = 0;
        while (n3 < n2) {
            tableField2 = tableField.fieldAt(n3);
            this.posFields(tableField2, new Point(point));
            if (tableField.isLR()) {
                point.x += tableField2.getSize().width;
            } else {
                point.y += tableField2.getSize().height;
            }
            ++n3;
        }
    }

    void setTextBounds(String string, Node node) {
        int n = 1;
        boolean bl = false;
        double[] dArray = new double[]{0.6206};
        String string2 = node.getAttribute("fontname").getStringValue().toLowerCase();
        if (string2.startsWith("courier") || string2.startsWith("monospaced")) {
            bl = true;
        } else {
            dArray = string2.startsWith("helvetica") || string2.startsWith("sansserif") ? GrappaSupportRects.helveticaFontwidth : GrappaSupportRects.romanFontwidth;
        }
        char[] cArray = string.toCharArray();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] == '\u00a0') {
                cArray[n3] = 32;
            }
            if (cArray[n3] == '\\' && n3 + 1 < cArray.length && (cArray[n3 + 1] == 'n' || cArray[n3 + 1] == 'l' || cArray[n3 + 1] == 'r')) {
                ++n;
                ++n3;
                if (d > d2) {
                    d2 = d;
                }
                d = 0.0;
            } else {
                n2 = cArray[n3] - 32;
                d += bl ? dArray[0] : (n2 >= 0 && n2 < dArray.length ? dArray[n2] : 0.0);
            }
            ++n3;
        }
        if (d > d2) {
            d2 = d;
        }
        int n4 = (Integer)node.getAttributeValue("fontsize");
        int n5 = (int)Math.round((double)n4 * d2);
        this.textBounds = new Rectangle(0, 0, n5, n4 * n);
        this.text = string;
    }

    Rectangle getTextBounds() {
        return this.textBounds;
    }

    void debugID() {
        int n = this.fieldCount();
        if (n == 0) {
            return;
        }
        TableField tableField = null;
        int n2 = 0;
        while (n2 < n) {
            tableField = this.fieldAt(n2);
            tableField.debugID();
            ++n2;
        }
    }
}

