/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.BooleanPropertyModel;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerImpl;
import com.parctechnologies.eclipse.visualisation.ViewerSetBooleanPropertyCommand;
import com.parctechnologies.eclipse.visualisation.ViewerSetSelectionCommand;
import com.parctechnologies.eclipse.visualisation.ViewerZoomCommand;
import com.parctechnologies.eclipse.visualisation.ViewerZoomInCommand;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletRangeCollection;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class ContainerViewer
extends ViewerImpl {
    private ViewletRange createdElementIndices;
    private ViewletRange updatingElementIndices;
    private ViewletRange expandingElementIndices;
    private List size;
    private boolean trackUpdates = false;
    protected ViewletType viewletType;
    protected ViewletDataStore viewletDataStore;
    private SelectUpdatingAction selectUpdatingAction;
    protected JCheckBoxMenuItem trackUpdatesMenuItem;
    private static final Atom vcSupportAtom = new Atom("vc_support");
    private List[] locationNames;

    @Override
    protected int getMenuMnemonic(String string) {
        if ("Select".equals(string)) {
            return 83;
        }
        if ("View".equals(string)) {
            return 86;
        }
        return super.getMenuMnemonic(string);
    }

    public ContainerViewer(VisClientStateModel visClientStateModel, Viewable viewable, ViewletType viewletType) {
        super(visClientStateModel, viewable);
        this.viewletType = viewletType;
        viewletType.setSymRef(new SymRef(viewletType, this.getSymRef(), viewletType.getClass().getName()));
        this.trackUpdatesMenuItem = new JCheckBoxMenuItem("Track updates");
        this.trackUpdatesMenuItem.setModel(new BooleanPropertyModel("trackUpdates", this, this.getPropertyChangeSupport()));
        this.addMenuItem("Options", this.trackUpdatesMenuItem);
        this.addMenuAndPopupMenuItem("Select", new SelectAllAction());
        this.selectUpdatingAction = new SelectUpdatingAction();
        this.addMenuAndPopupMenuItem("Select", this.selectUpdatingAction);
        this.addMenuAndPopupMenuItem("Select", new ClearSelectionAction());
        this.addMenuAndPopupMenuItem("View", this.getZoomInAction(this, 0.5f));
        this.addMenuAndPopupMenuItem("View", this.getZoomInAction(this, 2.0f));
        this.addMenuAndPopupMenuItem("View", null);
        this.addMenuAndPopupMenuItem("View", this.getZoomAction(this, 4.0f));
        this.addMenuAndPopupMenuItem("View", this.getZoomAction(this, 2.0f));
        this.addMenuAndPopupMenuItem("View", this.getZoomAction(this, 1.5f));
        this.addMenuAndPopupMenuItem("View", this.getZoomNormalAction(this));
        this.addMenuAndPopupMenuItem("View", this.getZoomAction(this, 0.75f));
        this.addMenuAndPopupMenuItem("View", this.getZoomAction(this, 0.5f));
        this.addMenuAndPopupMenuItem("View", this.getZoomAction(this, 0.25f));
        this.addMenuAndPopupMenuItem("View", this.getZoomToFitWidthAction());
        this.addMenuAndPopupMenuItem("View", this.getZoomToFitHeightAction());
    }

    public ViewletDataStore getViewletDataStore() {
        return this.viewletDataStore;
    }

    protected abstract Action getZoomToFitWidthAction();

    protected abstract Action getZoomToFitHeightAction();

    protected List getSize() {
        return this.size;
    }

    public boolean getTrackUpdates() {
        return this.trackUpdates;
    }

    public void setTrackUpdates(boolean bl) {
        new ViewerSetBooleanPropertyCommand(this, "trackUpdates", bl).issue();
    }

    public void setTrackUpdatesPrivate(boolean bl) {
        boolean bl2 = this.trackUpdates;
        this.trackUpdates = bl;
        this.getPropertyChangeSupport().firePropertyChange("trackUpdates", bl2, bl);
    }

    @Override
    public BatchGoal collectPreEventGoals(VisEvent visEvent) {
        BatchGoal batchGoal = new BatchGoal();
        if (visEvent instanceof UpdateEvent) {
            batchGoal.add(super.collectPreEventGoals(visEvent));
            this.setUpdatingElementIndices((UpdateEvent)visEvent);
            batchGoal.add(this.collectPreUpdateGoals(this.updatingElementIndices, (UpdateEvent)visEvent));
            return batchGoal;
        }
        if (visEvent instanceof ExpandEvent) {
            batchGoal.add(super.collectPreEventGoals(visEvent));
            ExpandEvent expandEvent = (ExpandEvent)visEvent;
            int n = expandEvent.getExpandingDimension();
            Integer n2 = (Integer)expandEvent.getViewableSize().get(n - 1);
            batchGoal.add(this.getAddLocationNameGoal(n, n2));
            this.setExpandingElementIndices(expandEvent);
            batchGoal.add(this.collectPreBuildGoals(this.expandingElementIndices));
            return batchGoal;
        }
        if (visEvent instanceof CreateEvent) {
            batchGoal.add(super.collectPreEventGoals(visEvent));
            CreateEvent createEvent = (CreateEvent)visEvent;
            for (int i = 1; i <= createEvent.getViewableSize().size(); ++i) {
                batchGoal.add(this.getLocationNamesGoal(i));
            }
            this.setCreatedElementIndices(createEvent);
            DebuggingSupport.logMessage(this, "collectPreEventGoal fooee");
            batchGoal.add(this.collectPreBuildGoals(this.createdElementIndices));
            return batchGoal;
        }
        return super.collectPreEventGoals(visEvent);
    }

    public void clearSelection() {
        this.setSelection(new ViewletRangeCollection());
    }

    public void setSelection(ViewletRange viewletRange) {
        new ViewerSetSelectionCommand(this, viewletRange).issue();
    }

    protected void setSelectionPrivate(ViewletRange viewletRange) {
    }

    public ViewletRange getSelection() {
        return null;
    }

    private Collection collectPreBuildGoals(ViewletRange viewletRange) {
        BatchGoal batchGoal = this.viewletType.collectPreBuildGoal(this, this.viewletDataStore, viewletRange);
        DebuggingSupport.logMessage(this, "PreBuildGoals=" + String.valueOf(batchGoal));
        return batchGoal;
    }

    private Collection collectPreUpdateGoals(ViewletRange viewletRange, UpdateEvent updateEvent) {
        BatchGoal batchGoal = this.viewletType.collectPreUpdateGoal(this, this.viewletDataStore, viewletRange, updateEvent);
        DebuggingSupport.logMessage(this, "PreUpdateGoals=" + String.valueOf(batchGoal));
        return batchGoal;
    }

    private void setCreatedElementIndices(CreateEvent createEvent) {
        List list = createEvent.getViewableSize();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        Integer n = new Integer(1);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(n);
        }
        this.createdElementIndices = this.viewletDataStore.createRange(arrayList, list);
    }

    private void setExpandingElementIndices(ExpandEvent expandEvent) {
        int n = expandEvent.getExpandingDimension();
        List list = expandEvent.getViewableSize();
        Integer n2 = (Integer)list.get(n - 1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        Integer n3 = new Integer(1);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(n3);
        }
        arrayList.set(n - 1, n2);
        this.expandingElementIndices = this.viewletDataStore.createRange(arrayList, list);
    }

    private void setUpdatingElementIndices(UpdateEvent updateEvent) {
        this.updatingElementIndices = this.viewletDataStore.createRange(updateEvent.getElementsUpdating());
    }

    protected ViewletRange getCreatedElementIndices() {
        return this.createdElementIndices;
    }

    protected ViewletRange getUpdatingElementIndices() {
        return this.updatingElementIndices;
    }

    protected ViewletRange getExpandingElementIndices() {
        return this.expandingElementIndices;
    }

    @Override
    public void gainFocus() {
        super.gainFocus();
        this.getComponent().repaint();
    }

    @Override
    public void loseFocus() {
        super.loseFocus();
        this.clearSelection();
        this.getComponent().repaint();
    }

    private void scrollToTrackUpdate(Collection collection) {
    }

    @Override
    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof UpdateEvent) {
            super.startEvent(visEvent, (List)list.get(0));
            this.distributeUpdateResults((List)list.get(1), this.updatingElementIndices, (UpdateEvent)visEvent);
            this.selectUpdatingAction.setEnabled(true);
            return;
        }
        this.selectUpdatingAction.setEnabled(false);
        if (visEvent instanceof ExpandEvent) {
            this.size = ((ExpandEvent)visEvent).getViewableSize();
            super.startEvent(visEvent, (List)list.get(0));
            String string = this.locationNameFromGoalResult((CompoundTermImpl)list.get(1));
            int n = ((ExpandEvent)visEvent).getExpandingDimension();
            this.locationNames[n - 1].add(string);
            this.distributeBuildResults((List)list.get(2), this.expandingElementIndices);
            return;
        }
        if (visEvent instanceof ContractEvent) {
            this.size = ((ContractEvent)visEvent).getViewableSize();
            this.shrinkLocationNamesTo(this.size);
        }
        if (visEvent instanceof CreateEvent) {
            int n;
            this.size = ((CreateEvent)visEvent).getViewableSize();
            super.startEvent(visEvent, (List)list.get(0));
            int n2 = this.size.size();
            this.locationNames = new List[n2];
            for (n = 1; n <= n2; ++n) {
                List list2;
                this.locationNames[n - 1] = list2 = this.locationNamesFromGoalResult((CompoundTermImpl)list.get(n));
            }
            this.distributeBuildResults((List)list.get(n), this.createdElementIndices);
            return;
        }
        super.startEvent(visEvent, list);
    }

    public Collection getCreatedViewlets() {
        return null;
    }

    public Collection getUpdatingViewlets() {
        return null;
    }

    public Collection getExpandingViewlets() {
        return null;
    }

    private Collection getViewletDataAtIndexList(Collection collection) {
        Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Collection collection2 = this.getViewletDataAt(list);
            linkedList.addAll(collection2);
        }
        return linkedList;
    }

    @Override
    public boolean shouldHold() {
        if (super.shouldHold()) {
            return true;
        }
        if (this.getCurrentEvent() instanceof UpdateEvent) {
            Iterator iterator = this.viewletDataStore.getViewletDataIterator(new ViewletRangeCollection((Collection)this.updatingElementIndices));
            while (iterator.hasNext()) {
                ViewletData viewletData = (ViewletData)iterator.next();
                if (!viewletData.getHoldsOnUpdates()) continue;
                return true;
            }
        }
        return false;
    }

    private void distributeBuildResults(List list, ViewletRange viewletRange) {
        this.viewletType.startBuild(this, this.viewletDataStore, viewletRange, list);
    }

    private void distributeUpdateResults(List list, ViewletRange viewletRange, UpdateEvent updateEvent) {
        this.viewletType.startUpdate(this, this.viewletDataStore, viewletRange, list, updateEvent);
    }

    @Override
    public void stopEvent() {
        if (this.getCurrentEvent() instanceof CreateEvent) {
            this.stopBuild(this.createdElementIndices);
        }
        if (this.getCurrentEvent() instanceof ExpandEvent) {
            this.stopBuild(this.expandingElementIndices);
        }
        if (this.getCurrentEvent() instanceof UpdateEvent) {
            this.stopUpdate(this.updatingElementIndices);
            this.selectUpdatingAction.setEnabled(false);
        }
        this.createdElementIndices = null;
        this.updatingElementIndices = null;
        this.expandingElementIndices = null;
        super.stopEvent();
    }

    private void stopBuild(ViewletRange viewletRange) {
        for (List list : viewletRange) {
            for (ViewletData viewletData : this.getViewletDataAt(list)) {
            }
        }
    }

    private void stopUpdate(ViewletRange viewletRange) {
        this.viewletType.stopUpdate(this, this.viewletDataStore, viewletRange);
    }

    protected abstract Collection getViewletDataAt(List var1);

    protected abstract ViewletRange getAllViewletData();

    protected List getLocationNames(int n) {
        return this.locationNames[n - 1];
    }

    protected String getLocationName(int n, int n2) {
        return (String)this.getLocationNames(n).get(n2 - 1);
    }

    private void shrinkLocationNamesTo(List list) {
        for (int i = 0; i < this.locationNames.length; ++i) {
            List list2;
            int n = (Integer)list.get(i);
            this.locationNames[i] = list2 = this.locationNames[i].subList(0, n);
        }
    }

    private CompoundTerm getLocationNamesGoal(int n) {
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("viewable_get_location_names", (Object)this.getViewable().getNameAtom(), (Object)new Integer(n), null));
        return compoundTermImpl;
    }

    private CompoundTerm getAddLocationNameGoal(int n, int n2) {
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("viewable_get_location_name", (Object)this.getViewable().getNameAtom(), (Object)new Integer(n), (Object)new Integer(n2), null));
        return compoundTermImpl;
    }

    private List locationNamesFromGoalResult(CompoundTermImpl compoundTermImpl) {
        return (List)compoundTermImpl.argCT(2).arg(3);
    }

    private String locationNameFromGoalResult(CompoundTermImpl compoundTermImpl) {
        return (String)compoundTermImpl.argCT(2).arg(4);
    }

    protected Action getZoomInAction(Viewer viewer, float f) {
        return new ZoomInAction(viewer, f);
    }

    protected Action getZoomAction(Viewer viewer, float f) {
        return new ZoomAction(viewer, f);
    }

    protected Action getZoomNormalAction(Viewer viewer) {
        return new ZoomNormalAction(viewer);
    }

    public Collection getViewerPopupMenuCollection() {
        LinkedList<JMenu> linkedList = new LinkedList<JMenu>();
        linkedList.add(this.getPopupMenu("Select"));
        linkedList.add(this.getPopupMenu("View"));
        return linkedList;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = super.getPopupMenu();
        ViewletRange viewletRange = this.getSelection();
        if (viewletRange != null) {
            Iterator iterator = this.viewletType.getActions(this.viewletDataStore, viewletRange).iterator();
            while (iterator.hasNext()) {
                jPopupMenu.add((Action)iterator.next());
            }
        }
        jPopupMenu.addSeparator();
        for (Object e : this.getViewerPopupMenuCollection()) {
            if (e instanceof Action) {
                jPopupMenu.add((Action)e);
                continue;
            }
            if (e instanceof JMenuItem) {
                jPopupMenu.add((JMenuItem)e);
                continue;
            }
            if (e instanceof Component) {
                jPopupMenu.add((Component)e);
                continue;
            }
            if (e instanceof String) {
                jPopupMenu.add((String)e);
                continue;
            }
            if (!(e instanceof JMenu)) continue;
            jPopupMenu.add((JMenu)e);
        }
        return jPopupMenu;
    }

    private class ZoomNormalAction
    extends ZoomAction {
        ZoomNormalAction(Viewer viewer) {
            super(viewer, 1.0f);
            this.putValue("Name", "Zoom to normal size");
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private float zoomRatio;
        private Viewer viewer;

        ZoomInAction(Viewer viewer, float f) {
            super("Zoom " + (f < 1.0f ? "out" : "in") + " by " + (int)((f < 1.0f ? 1.0f / f : f) * 100.0f) + "%");
            this.zoomRatio = f;
            this.viewer = viewer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ViewerZoomInCommand(this.viewer, this.zoomRatio).issue();
        }
    }

    private class ZoomAction
    extends AbstractAction {
        private float zoomRatio;
        private Viewer viewer;

        ZoomAction(Viewer viewer, float f) {
            super("Zoom to " + (int)(f * 100.0f) + "%");
            this.zoomRatio = f;
            this.viewer = viewer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ViewerZoomCommand(this.viewer, this.zoomRatio).issue();
        }
    }

    private class ClearSelectionAction
    extends ViewletSelectionAction {
        ClearSelectionAction() {
            super("Clear selection");
        }

        @Override
        protected ViewletRange newSelection() {
            return new ViewletRangeCollection();
        }
    }

    private class SelectUpdatingAction
    extends ViewletSelectionAction {
        SelectUpdatingAction() {
            super("Select updating viewlet(s)");
            this.setEnabled(false);
        }

        @Override
        protected ViewletRange newSelection() {
            return ContainerViewer.this.getUpdatingElementIndices();
        }
    }

    private class SelectAllAction
    extends ViewletSelectionAction {
        SelectAllAction() {
            super("Select all viewlets");
        }

        @Override
        protected ViewletRange newSelection() {
            return ContainerViewer.this.viewletDataStore.getEntireViewletRange();
        }
    }

    private abstract class ViewletSelectionAction
    extends AbstractAction {
        protected abstract ViewletRange newSelection();

        ViewletSelectionAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ContainerViewer.this.clearSelection();
            ContainerViewer.this.setSelection(this.newSelection());
            ContainerViewer.this.getComponent().repaint();
        }
    }
}

