/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletDataStoreListener;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletRangeCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractViewletDataStore
extends AbstractTableModel
implements ViewletDataStore {
    protected static final String fixedString = "fixed";
    protected static final String flexibleString = "flexible";
    SymRef symRef;
    protected Viewable viewable;
    protected List oldSize;
    protected List[] locationNames;
    protected String topLevelFixity;
    protected List wholeSize;
    protected ViewletFactory viewletFactory;
    protected List listenerList;

    public AbstractViewletDataStore(List list, List list2, Viewable viewable, ViewletFactory viewletFactory) {
        int n = (Integer)list.get(0);
        this.wholeSize = new LinkedList(list);
        this.topLevelFixity = (String)list2.get(0);
        this.viewable = viewable;
        this.viewletFactory = viewletFactory;
        this.listenerList = new LinkedList();
        this.locationNames = new List[this.getNDimensions()];
    }

    @Override
    public void setLocationNames(int n, List list) {
        this.locationNames[n - 1] = list;
    }

    @Override
    public void finishExpandDimension(int n) {
        switch (n) {
            case 1: {
                int n2 = (Integer)this.oldSize.get(0);
                int n3 = (Integer)this.wholeSize.get(0);
                this.fireTableRowsInserted(n2, n3 - 1);
                break;
            }
            case 2: {
                this.fireTableStructureChanged();
                break;
            }
        }
    }

    @Override
    public List getLocationNames(int n) {
        return this.locationNames[n - 1];
    }

    @Override
    public String getLocationName(int n, int n2) {
        return (String)this.getLocationNames(n).get(n2 - 1);
    }

    @Override
    public void setViewable(Viewable viewable) {
        this.viewable = viewable;
    }

    @Override
    public Viewable getViewable() {
        return this.viewable;
    }

    @Override
    public ViewletRange getEntireViewletRange() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.wholeSize.size());
        Integer n = new Integer(1);
        for (int i = 0; i < this.wholeSize.size(); ++i) {
            arrayList.add(n);
        }
        return this.createRange(arrayList, this.wholeSize);
    }

    @Override
    public Iterator getViewletDataIterator(ViewletRange viewletRange) {
        return new ViewletDataIterator(this, viewletRange);
    }

    @Override
    public int getNDimensions() {
        return this.getSize().size();
    }

    @Override
    public List getSize() {
        return this.wholeSize;
    }

    @Override
    public void shrinkTo(List list) {
    }

    @Override
    public void startExpandDimension(int n) {
        Integer n2 = (Integer)this.wholeSize.get(n - 1);
        Integer n3 = new Integer(n2 + 1);
        this.oldSize = new LinkedList(this.wholeSize);
        this.wholeSize.set(n - 1, n3);
    }

    public ViewletData getViewletDataAt(int n, int n2) {
        if (this.getSize().size() != 2) {
            return null;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(new Integer(n));
        linkedList.add(new Integer(n2));
        return this.getViewletDataAt(linkedList);
    }

    public ViewletData getViewletDataAt(int n) {
        if (this.getSize().size() != 1) {
            return null;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(new Integer(n));
        return this.getViewletDataAt(linkedList);
    }

    @Override
    public abstract ViewletData getViewletDataAt(List var1);

    @Override
    public abstract void setViewletDataAt(List var1, ViewletData var2);

    @Override
    public void fireViewletRangeUpdated(ViewletRange viewletRange) {
        SwingUtilities.invokeLater(new RangeUpdater(this, viewletRange));
    }

    @Override
    public synchronized void addViewletDataStoreListener(ViewletDataStoreListener viewletDataStoreListener) {
        this.listenerList.add(viewletDataStoreListener);
    }

    @Override
    public synchronized void removeViewletDataStoreListener(ViewletDataStoreListener viewletDataStoreListener) {
        this.listenerList.remove(viewletDataStoreListener);
    }

    @Override
    public int getRowCount() {
        int n = (Integer)this.wholeSize.get(0);
        return n;
    }

    @Override
    public int getColumnCount() {
        int n = 1;
        if (this.wholeSize.size() > 1) {
            n = (Integer)this.wholeSize.get(1);
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.wholeSize.size() == 1) {
            return this.getViewletDataAt(n + 1);
        }
        return this.getViewletDataAt(n + 1, n2 + 1);
    }

    @Override
    public String getColumnName(int n) {
        if (this.wholeSize.size() == 1) {
            return "1";
        }
        return (String)this.locationNames[1].get(n);
    }

    @Override
    public String getRowName(int n) {
        return (String)this.locationNames[0].get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public ViewletRange createRange(Collection collection) {
        return new ViewletRangeCollection(collection);
    }

    protected List allCombinations(List list, List list2) {
        LinkedList linkedList = new LinkedList();
        if (list2.size() > 0) {
            Integer n = (Integer)list.get(0);
            List list3 = list.subList(1, list.size());
            Integer n2 = (Integer)list2.get(0);
            List list4 = list2.subList(1, list2.size());
            List list5 = this.allCombinations(list3, list4);
            for (int i = n.intValue(); i <= n2; ++i) {
                Iterator iterator = list5.iterator();
                while (iterator.hasNext()) {
                    LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
                    linkedList2.add(new Integer(i));
                    linkedList2.addAll((List)iterator.next());
                    linkedList.add(linkedList2);
                }
            }
        } else {
            linkedList.add(new LinkedList());
        }
        return linkedList;
    }

    @Override
    public ViewletRange createRange(List list, List list2) {
        return new ViewletRangeCollection((Collection)this.allCombinations(list, list2));
    }

    @Override
    public void setSymRef(SymRef symRef) {
        this.symRef = symRef;
    }

    @Override
    public SymRef getSymRef() {
        return this.symRef;
    }

    protected class RangeUpdater
    implements Runnable {
        ViewletRange range;
        AbstractViewletDataStore store;

        public RangeUpdater(AbstractViewletDataStore abstractViewletDataStore2, ViewletRange viewletRange) {
            this.range = viewletRange;
            this.store = abstractViewletDataStore2;
        }

        @Override
        public void run() {
            Iterator iterator = AbstractViewletDataStore.this.listenerList.iterator();
            while (iterator.hasNext()) {
                ((ViewletDataStoreListener)iterator.next()).rangeUpdated(this.store, this.range);
            }
            if (this.range == null) {
                this.store.fireTableDataChanged();
                return;
            }
            for (List list : this.range) {
                int n;
                int n2;
                if (list.size() == 1) {
                    n2 = 0;
                    n = (Integer)list.get(0) - 1;
                    this.store.fireTableCellUpdated(n, n2);
                    continue;
                }
                n2 = (Integer)list.get(0) - 1;
                n = (Integer)list.get(1) - 1;
                this.store.fireTableCellUpdated(n2, n);
            }
        }
    }

    protected static class ViewletDataIterator
    implements Iterator {
        Iterator it;
        ViewletDataStore store;

        public ViewletDataIterator(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            this.it = viewletRange.iterator();
            this.store = viewletDataStore;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            List list = (List)this.it.next();
            return this.store.getViewletDataAt(list);
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

