/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.MouseViewletMenuUpPopper;
import com.parctechnologies.eclipse.visualisation.SpreadSheet;
import com.parctechnologies.eclipse.visualisation.SpreadSheetSelectionViewletRange;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.ViewletArrayViewer;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import com.parctechnologies.eclipse.visualisation.ZoomableViewer;
import com.parctechnologies.eclipse.visualisation.ZoomableViewerZoomToFitHeightCommand;
import com.parctechnologies.eclipse.visualisation.ZoomableViewerZoomToFitWidthCommand;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;

public class TableViewer
extends ViewletArrayViewer
implements ZoomableViewer {
    protected static int DEFAULT_ROW_HEIGHT = 70;
    protected static int DEFAULT_COLUMN_WIDTH = 100;
    private SpreadSheet table;
    private JScrollPane scrollpane;
    private boolean trackExpansions = false;

    public TableViewer(ViewletType viewletType, VisClientStateModel visClientStateModel, Viewable viewable) {
        super(viewletType, visClientStateModel, viewable);
        this.initialiseMenu();
    }

    private void initialiseMenu() {
    }

    @Override
    protected Action getZoomToFitWidthAction() {
        return new ZoomToFitWidthAction(this);
    }

    @Override
    protected Action getZoomToFitHeightAction() {
        return new ZoomToFitHeightAction(this);
    }

    @Override
    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof UpdateEvent) {
            super.startEvent(visEvent, list);
            return;
        }
        if (visEvent instanceof CreateEvent) {
            super.startEvent(visEvent, list);
            this.initialiseComponent();
            return;
        }
        if (visEvent instanceof ExpandEvent) {
            super.startEvent(visEvent, list);
            return;
        }
        super.startEvent(visEvent, list);
    }

    private void initialiseComponent() {
        this.trackUpdatesMenuItem.setEnabled(false);
        this.table = new SpreadSheet(this.getViewletDataStore(), null, null);
        this.table.setAutoResizeMode(0);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setDefaultRenderer(new Object().getClass(), this.viewletType.getTableCellRenderer());
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.setPreferredSize(new Dimension(430, 200));
        MouseViewletMenuUpPopper mouseViewletMenuUpPopper = new MouseViewletMenuUpPopper(this, this.table);
        this.table.setColumnWidth(DEFAULT_COLUMN_WIDTH);
        this.table.setRowHeight(DEFAULT_ROW_HEIGHT);
    }

    @Override
    public Component getComponent() {
        return this.scrollpane;
    }

    public void setTrackExpansions(boolean bl) {
    }

    public void setTrackExpansionsPrivate(boolean bl) {
    }

    public boolean getTrackExpansions() {
        return false;
    }

    @Override
    public void zoomToLevel(float f) {
        this.table.setColumnWidth((int)((float)DEFAULT_COLUMN_WIDTH * f));
        this.table.setRowHeight((int)((float)DEFAULT_ROW_HEIGHT * f));
        this.table.revalidate();
    }

    @Override
    public void zoomInByRatio(float f) {
        int n = this.table.getColumnCount();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < n; ++i) {
            int n2 = tableColumnModel.getColumn(i).getPreferredWidth();
            tableColumnModel.getColumn(i).setPreferredWidth((int)((float)n2 * f));
        }
        this.table.setRowHeight((int)((float)this.table.getRowHeight() * f));
        this.table.revalidate();
    }

    private void scrollToTrackExpansion(ExpandEvent expandEvent) {
    }

    @Override
    public void zoomToFitWidth() {
        this.table.fitWidth();
        this.table.revalidate();
    }

    @Override
    public void zoomToFitHeight() {
        this.table.fitHeight();
        this.table.revalidate();
    }

    Rectangle rangeToBounds(ViewletRange viewletRange) {
        if (((ViewableType.ArrayType)this.getViewable().getType()).getNDimensions() == 1) {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            for (List list : viewletRange) {
                int n3 = (Integer)list.get(0);
                if (n3 < n) {
                    n = n3;
                }
                if (n3 <= n2) continue;
                n2 = n3;
            }
            return new Rectangle(0, n - 1, 1, n2 - n + 1);
        }
        int n = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = Integer.MAX_VALUE;
        int n6 = -1;
        for (List list : viewletRange) {
            int n7 = (Integer)list.get(0);
            int n8 = (Integer)list.get(1);
            if (n8 < n) {
                n = n8;
            }
            if (n8 > n4) {
                n4 = n8;
            }
            if (n7 < n5) {
                n5 = n7;
            }
            if (n7 <= n6) continue;
            n6 = n7;
        }
        return new Rectangle(n - 1, n5 - 1, n4 - n + 1, n6 - n5 + 1);
    }

    @Override
    protected void setSelectionPrivate(ViewletRange viewletRange) {
        DebuggingSupport.logMessage(this, "setSelectionPrivate called with newSelection=" + String.valueOf(viewletRange));
        if (viewletRange.isEmpty()) {
            this.table.clearSelection();
            return;
        }
        Rectangle rectangle = this.rangeToBounds(viewletRange);
        this.table.setColumnSelectionInterval(rectangle.x, rectangle.x + rectangle.width - 1);
        this.table.setRowSelectionInterval(rectangle.y, rectangle.y + rectangle.height - 1);
    }

    @Override
    public ViewletRange getSelection() {
        return new SpreadSheetSelectionViewletRange(this.table);
    }

    public Collection getCompoundActions(ViewletRange viewletRange) {
        return this.viewletType.getActions(this.viewletDataStore, viewletRange);
    }

    private class ZoomToFitHeightAction
    extends AbstractAction {
        private TableViewer viewer;

        ZoomToFitHeightAction(TableViewer tableViewer2) {
            super("Zoom to fit height");
            this.viewer = tableViewer2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ZoomableViewerZoomToFitHeightCommand(this.viewer).issue();
        }
    }

    private class ZoomToFitWidthAction
    extends AbstractAction {
        private TableViewer viewer;

        ZoomToFitWidthAction(TableViewer tableViewer2) {
            super("Zoom to fit width");
            this.viewer = tableViewer2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ZoomableViewerZoomToFitWidthCommand(this.viewer).issue();
        }
    }
}

