/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.ActionButton;
import com.parctechnologies.eclipse.visualisation.AutoResumePanel;
import com.parctechnologies.eclipse.visualisation.BooleanPropertyModel;
import com.parctechnologies.eclipse.visualisation.ScenarioManager;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerActivationCommand;
import com.parctechnologies.eclipse.visualisation.ViewerCloseCommand;
import com.parctechnologies.eclipse.visualisation.ViewerDeiconifyCommand;
import com.parctechnologies.eclipse.visualisation.ViewerFocusCommand;
import com.parctechnologies.eclipse.visualisation.ViewerIconifyCommand;
import com.parctechnologies.eclipse.visualisation.ViewerInternalFrameBoundsCommand;
import com.parctechnologies.eclipse.visualisation.ViewerSetMaximizedCommand;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class ViewerManagerFrame
extends JFrame {
    private JDesktopPane jDesktopPane;
    private Map viewerToJInternalFrame;
    private VisClientStateModel stateModel;
    private ControlPanel controlPanel;
    private static final int INITIAL_WIDTH = 800;
    private static final int INITIAL_HEIGHT = 600;
    private JMenuBar jMenuBar;
    private Map menuTitleToMenu;
    private ActionButton resumeButton;
    private ActionButton interruptButton;
    private JLabel lastEventLabel;

    public ViewerManagerFrame(VisClientStateModel visClientStateModel) {
        super("ECLiPSe Visualisation Client [" + visClientStateModel.getVisClientName().functor() + "]");
        this.stateModel = visClientStateModel;
        this.initialise();
    }

    private void initialise() {
        FocusManager.setCurrentManager(new MyFocusManager());
        this.getContentPane().setLayout(new GridBagLayout());
        this.viewerToJInternalFrame = new HashMap();
        this.initialiseDesktopPane();
        this.initialiseControlPanel();
        this.initialiseLastEventLabel();
        this.initialiseMenu();
        this.initialiseWindowListener();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        this.setLocation(Math.max(dimension.width / 2 - dimension2.width / 2, 2), Math.max(dimension.height / 2 - dimension2.height / 2, 2));
    }

    void setLastEventString(String string) {
        this.lastEventLabel.setText(" " + string);
    }

    private void initialiseLastEventLabel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 2;
        this.lastEventLabel = new JLabel(" ", 2);
        this.lastEventLabel.setBorder(new BevelBorder(1));
        this.getContentPane().add((Component)this.lastEventLabel, gridBagConstraints);
    }

    protected int getMenuMnemonic(String string) {
        if ("File".equals(string)) {
            return 70;
        }
        if ("Options".equals(string)) {
            return 79;
        }
        return -1;
    }

    private void addMenuItem(String string, Object object) {
        JMenu jMenu = (JMenu)this.menuTitleToMenu.get(string);
        if (jMenu == null) {
            jMenu = new JMenu(string);
            int n = this.getMenuMnemonic(string);
            if (n != -1) {
                jMenu.setMnemonic(n);
            }
            this.jMenuBar.add(jMenu);
            this.menuTitleToMenu.put(string, jMenu);
        }
        if (object instanceof Action) {
            jMenu.add((Action)object);
            return;
        }
        if (object instanceof JMenuItem) {
            jMenu.add((JMenuItem)object);
            return;
        }
    }

    private void initialiseMenu() {
        this.jMenuBar = new JMenuBar();
        this.setJMenuBar(this.jMenuBar);
        this.menuTitleToMenu = new HashMap();
        this.addMenuItem("File", new LoadAction());
        this.addMenuItem("File", new SaveAction());
        this.addMenuItem("File", new ExitAction());
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Auto Resume");
        jCheckBoxMenuItem.setModel(new BooleanPropertyModel("autoResume", this.stateModel, this.stateModel.getPropertyChangeSupport()));
        this.addMenuItem("Options", jCheckBoxMenuItem);
    }

    private void initialiseDesktopPane() {
        this.jDesktopPane = new JDesktopPane();
        this.jDesktopPane.setPreferredSize(new Dimension(800, 600));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jDesktopPane, gridBagConstraints);
        JInternalFrame jInternalFrame = new JInternalFrame("dummy");
        jInternalFrame.setDefaultCloseOperation(2);
        this.jDesktopPane.add(jInternalFrame);
        jInternalFrame.setVisible(true);
        try {
            jInternalFrame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(System.err);
        }
    }

    private void initialiseControlPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        this.controlPanel = new ControlPanel(this);
        this.getContentPane().add((Component)this.controlPanel, gridBagConstraints);
    }

    private void initialiseWindowListener() {
        this.addWindowListener(new WindowClosingListener());
    }

    void addViewer(Viewer viewer, String string) {
        try {
            SwingUtilities.invokeAndWait(new ViewerAdder(viewer, string));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException("Exception thrown by event thread executing ViewerAdder: \n" + String.valueOf(exception));
        }
    }

    void removeViewer(Viewer viewer) {
        new ViewerRemover(viewer).run();
    }

    private void exit() {
        this.dispose();
        this.stateModel.setTerminate(true);
    }

    private class ViewerRemover
    implements Runnable {
        private Viewer viewer;

        ViewerRemover(Viewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public void run() {
            JInternalFrame jInternalFrame = (JInternalFrame)ViewerManagerFrame.this.viewerToJInternalFrame.get(this.viewer);
            if (jInternalFrame != null && !jInternalFrame.isClosed()) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
                ViewerManagerFrame.this.viewerToJInternalFrame.remove(this.viewer);
            }
        }
    }

    private class ViewerAdder
    implements Runnable {
        private Viewer newViewer;
        private String viewableName;

        ViewerAdder(Viewer viewer, String string) {
            this.newViewer = viewer;
            this.viewableName = string;
        }

        @Override
        public void run() {
            String string = this.viewableName + " - " + this.newViewer.getDescription();
            JInternalFrame jInternalFrame = new JInternalFrame(string, true, true, true, true);
            jInternalFrame.setDefaultCloseOperation(2);
            jInternalFrame.getRootPane().setJMenuBar(this.newViewer.getJMenuBar());
            jInternalFrame.getContentPane().add(this.newViewer.getComponent());
            jInternalFrame.pack();
            int n = Math.min(jInternalFrame.getWidth(), ViewerManagerFrame.this.jDesktopPane.getWidth());
            int n2 = Math.min(jInternalFrame.getHeight(), ViewerManagerFrame.this.jDesktopPane.getHeight());
            jInternalFrame.setSize(n, n2);
            jInternalFrame.addInternalFrameListener(new ViewerInternalFrameListener(this.newViewer));
            jInternalFrame.addComponentListener(new ViewerInternalFrameComponentListener(this.newViewer, jInternalFrame));
            jInternalFrame.addPropertyChangeListener("maximum", new ViewerMaximizeListener(this.newViewer));
            ViewerManagerFrame.this.jDesktopPane.add(jInternalFrame);
            jInternalFrame.setVisible(true);
            ViewerManagerFrame.this.viewerToJInternalFrame.put(this.newViewer, jInternalFrame);
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScenarioManager.getInstance().saveScenarioToDisk();
        }
    }

    private class LoadAction
    extends AbstractAction {
        LoadAction() {
            super("Load");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScenarioManager.getInstance().loadScenarioForPlayback();
        }
    }

    private class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ViewerManagerFrame.this.exit();
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ViewerManagerFrame.this.exit();
        }
    }

    private class ViewerInternalFrameListener
    extends InternalFrameAdapter {
        private Viewer viewer;

        ViewerInternalFrameListener(Viewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            ScenarioManager.getInstance().processCommand(new ViewerActivationCommand(this.viewer, true));
            new ViewerFocusCommand(this.viewer, true).issue();
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            ScenarioManager.getInstance().processCommand(new ViewerActivationCommand(this.viewer, false));
            new ViewerFocusCommand(this.viewer, false).issue();
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            ScenarioManager.getInstance().processCommand(new ViewerIconifyCommand(this.viewer));
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            ScenarioManager.getInstance().processCommand(new ViewerDeiconifyCommand(this.viewer));
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            new ViewerCloseCommand(this.viewer).issue();
        }
    }

    private class ViewerMaximizeListener
    implements PropertyChangeListener {
        private Viewer viewer;

        ViewerMaximizeListener(Viewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            ScenarioManager.getInstance().processCommand(new ViewerSetMaximizedCommand(this.viewer, bl));
        }
    }

    private class ViewerInternalFrameComponentListener
    implements ComponentListener {
        private Viewer viewer;
        private JInternalFrame frame;

        ViewerInternalFrameComponentListener(Viewer viewer, JInternalFrame jInternalFrame) {
            this.viewer = viewer;
            this.frame = jInternalFrame;
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            ViewerInternalFrameBoundsCommand viewerInternalFrameBoundsCommand = new ViewerInternalFrameBoundsCommand(this.viewer, this.frame.getBounds());
            ScenarioManager.getInstance().processCommand(viewerInternalFrameBoundsCommand);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ViewerInternalFrameBoundsCommand viewerInternalFrameBoundsCommand = new ViewerInternalFrameBoundsCommand(this.viewer, this.frame.getBounds());
            ScenarioManager.getInstance().processCommand(viewerInternalFrameBoundsCommand);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    private class ControlPanel
    extends JPanel
    implements PropertyChangeListener {
        private AutoResumePanel autoResumePanel;
        private ViewerManagerFrame enclosingComponent;

        ControlPanel(ViewerManagerFrame viewerManagerFrame2) {
            super(new FlowLayout());
            this.enclosingComponent = this.enclosingComponent;
            this.initialiseButtons();
            this.initialiseAutoResumePanel();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("autoResume")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    this.showAutoResumePanel();
                } else {
                    this.hideAutoResumePanel();
                }
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("currentVisClientState")) {
                if (!((Integer)propertyChangeEvent.getNewValue() != 6 || ViewerManagerFrame.this.interruptButton.hasFocus() && ViewerManagerFrame.this.stateModel.getAutoResume())) {
                    ViewerManagerFrame.this.resumeButton.requestFocus();
                    return;
                }
                if ((Integer)propertyChangeEvent.getNewValue() == 0) {
                    ViewerManagerFrame.this.interruptButton.requestFocus();
                    return;
                }
            }
        }

        private void initialiseButtons() {
            ViewerManagerFrame.this.stateModel.getPropertyChangeSupport().addPropertyChangeListener("currentVisClientState", this);
            ViewerManagerFrame.this.resumeButton = new ActionButton(ViewerManagerFrame.this.stateModel.getResumeAction());
            ViewerManagerFrame.this.interruptButton = new ActionButton(ViewerManagerFrame.this.stateModel.getInterruptAction());
            this.add(ViewerManagerFrame.this.resumeButton);
            this.add(ViewerManagerFrame.this.interruptButton);
        }

        private void initialiseAutoResumePanel() {
            this.autoResumePanel = new AutoResumePanel(ViewerManagerFrame.this.stateModel);
            if (ViewerManagerFrame.this.stateModel.getAutoResume()) {
                this.showAutoResumePanel();
            }
            ViewerManagerFrame.this.stateModel.getPropertyChangeSupport().addPropertyChangeListener("autoResume", this);
        }

        private void showAutoResumePanel() {
            this.add(this.autoResumePanel);
            this.revalidate();
            this.repaint();
        }

        private void hideAutoResumePanel() {
            this.remove(this.autoResumePanel);
            this.revalidate();
            this.repaint();
        }
    }

    private class MyFocusManager
    extends DefaultFocusManager {
        private MyFocusManager() {
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component == ViewerManagerFrame.this.resumeButton) {
                return ViewerManagerFrame.this.interruptButton;
            }
            if (component == ViewerManagerFrame.this.interruptButton) {
                return ViewerManagerFrame.this.resumeButton;
            }
            return super.getComponentBefore(container, component);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component == ViewerManagerFrame.this.resumeButton) {
                return ViewerManagerFrame.this.interruptButton;
            }
            if (component == ViewerManagerFrame.this.interruptButton) {
                return ViewerManagerFrame.this.resumeButton;
            }
            return super.getComponentAfter(container, component);
        }
    }
}

