/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.FullDomainMap;
import ie.ucc.cccc.viz.InvariantType;
import ie.ucc.cccc.viz.Pair;
import ie.ucc.cccc.viz.State;
import ie.ucc.cccc.viz.Visualizer;
import ie.ucc.cccc.viz.VizFailed;
import ie.ucc.cccc.viz.VizFocus;
import ie.ucc.cccc.viz.VizParent;
import java.io.PrintWriter;
import java.util.Map;

public class VisualState
extends VizParent {
    private VisualState parent = null;
    private Visualizer visualizer;
    private State state;
    private VizFocus focus;
    private VizFailed failed;

    public VisualState(Visualizer visualizer, State state) {
        assert (visualizer != null);
        assert (state != null);
        this.visualizer = visualizer;
        this.state = state;
        for (VisualState visualState : state.getParent().getVisualStates()) {
            if (visualState.getVisualizer() != visualizer) continue;
            this.parent = visualState;
        }
    }

    @Override
    public FullDomain getDomainAsList() {
        return new FullDomain();
    }

    public Visualizer getVisualizer() {
        return this.visualizer;
    }

    public State getState() {
        return this.state;
    }

    public VisualState getParent() {
        return this.parent;
    }

    public FullDomain[] getRemovedValues(FullDomain[] fullDomainArray) {
        FullDomain[] fullDomainArray2 = new FullDomain[fullDomainArray.length];
        if (this.getParent() == null) {
            for (int i = 0; i < fullDomainArray.length; ++i) {
                fullDomainArray2[i] = new FullDomain();
            }
        } else {
            FullDomain[] fullDomainArray3 = this.getParent().getEntries().asDomainArray();
            for (int i = 0; i < fullDomainArray.length; ++i) {
                fullDomainArray2[i] = fullDomainArray[i] == null ? new FullDomain() : fullDomainArray3[i].getRemovedValues(fullDomainArray[i]);
            }
        }
        return fullDomainArray2;
    }

    public FullDomain[] getRemovedValues(String string, FullDomain[] fullDomainArray) {
        FullDomain[] fullDomainArray2 = new FullDomain[fullDomainArray.length];
        if (this.getParent() == null) {
            for (int i = 0; i < fullDomainArray.length; ++i) {
                fullDomainArray2[i] = new FullDomain();
            }
        } else {
            FullDomain[] fullDomainArray3 = this.getParent().argumentDomainArray(string);
            for (int i = 0; i < fullDomainArray.length; ++i) {
                fullDomainArray2[i] = fullDomainArray[i] == null ? new FullDomain() : fullDomainArray3[i].getRemovedValues(fullDomainArray[i]);
            }
        }
        return fullDomainArray2;
    }

    public FullDomain getRemovedValues(String string, FullDomain fullDomain) {
        FullDomain fullDomain2;
        if (this.getParent() == null) {
            fullDomain2 = new FullDomain();
        } else {
            FullDomain fullDomain3 = this.getParent().argumentDomain(string);
            fullDomain2 = fullDomain3.getRemovedValues(fullDomain);
        }
        return fullDomain2;
    }

    public FullDomainMap getRemovedValues(FullDomainMap fullDomainMap) {
        FullDomainMap fullDomainMap2 = new FullDomainMap();
        if (this.getParent() != null) {
            FullDomainMap fullDomainMap3 = this.getParent().getEntries().asDomainMap();
            for (Map.Entry entry : fullDomainMap3.entrySet()) {
                fullDomainMap2.put((Pair)entry.getKey(), ((FullDomain)entry.getValue()).getRemovedValues((FullDomain)fullDomainMap.get(entry.getKey())));
            }
        }
        return fullDomainMap2;
    }

    public FullDomainMap getRemovedValues(String string, FullDomainMap fullDomainMap) {
        FullDomainMap fullDomainMap2 = new FullDomainMap();
        if (this.getParent() != null) {
            FullDomainMap fullDomainMap3 = this.getParent().argument(string).asDomainMap();
            for (Map.Entry entry : fullDomainMap3.entrySet()) {
                fullDomainMap2.put((Pair)entry.getKey(), ((FullDomain)entry.getValue()).getRemovedValues((FullDomain)fullDomainMap.get(entry.getKey())));
            }
        }
        return fullDomainMap2;
    }

    public VizFocus getFocus() {
        return this.focus;
    }

    public VizFailed getFailed() {
        return this.failed;
    }

    public void focus(VizFocus vizFocus) {
        this.focus = vizFocus;
    }

    public void failed(VizFailed vizFailed) {
        this.failed = vizFailed;
    }

    public void draw(PrintWriter printWriter) {
        this.visualizer.draw(printWriter, this);
    }

    public void drawBox(PrintWriter printWriter, Colors colors) {
        this.visualizer.drawBox(printWriter, this, colors);
    }

    public InvariantType invariant(PrintWriter printWriter) {
        return this.visualizer.invariant(printWriter, this);
    }
}

