/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.Grappa;
import att.grappa.GrappaBacker;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaListener;
import att.grappa.GrappaNexus;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSize;
import att.grappa.GrappaStyle;
import att.grappa.GrappaSupport;
import att.grappa.Node;
import att.grappa.SimplePolygon;
import att.grappa.Subgraph;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrappaPanel
extends JPanel
implements GrappaConstants,
ComponentListener,
AncestorListener,
PopupMenuListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Printable,
Runnable {
    Graph graph;
    Subgraph subgraph;
    GrappaBacker backer;
    boolean nodeLabels;
    boolean edgeLabels;
    boolean subgLabels;
    AffineTransform transform = null;
    AffineTransform oldTransform = null;
    AffineTransform inverseTransform = null;
    int nextElement = -1;
    boolean scaleToFit = false;
    GrappaSize scaleToSize = null;
    GrappaListener grappaListener = null;
    private Element pressedElement = null;
    private GrappaPoint pressedPoint = null;
    private int pressedModifiers = 0;
    private GrappaStyle selectionStyle = null;
    private GrappaStyle deletionStyle = null;
    private double scaleFactor = 1.0;
    private double scaleInfo = 1.0;
    private GrappaBox outline = null;
    private GrappaBox savedOutline = null;
    private GrappaBox zoomBox = null;
    private boolean inMenu = false;
    private boolean scaleChanged = false;
    private boolean paintActive = false;
    private Dimension prevsz = null;
    private Point2D panelcpt = null;
    JLabel surrogateLabel;
    private double mouseWheelFactor = 2.0;
    private float edgeAlpha = 1.0f;
    private boolean panMode = false;
    private Point panPoint = null;
    HashMap<Graph, List<SimplePolygon>> XDOTShapes = new HashMap();

    public GrappaPanel(Subgraph subgraph) {
        this(subgraph, null);
    }

    public GrappaPanel(Subgraph subgraph, GrappaBacker backer) {
        this.surrogateLabel = new JLabel();
        this.subgraph = subgraph;
        this.backer = backer;
        this.graph = subgraph.getGraph();
        this.addAncestorListener(this);
        this.addComponentListener(this);
        this.selectionStyle = (GrappaStyle)this.graph.getGrappaAttributeValue("grappaSelectionColor");
        this.deletionStyle = (GrappaStyle)this.graph.getGrappaAttributeValue("grappaDeletionColor");
        this.setDoubleBuffered(true);
    }

    public GrappaListener addGrappaListener(GrappaListener listener) {
        GrappaListener oldGL = this.grappaListener;
        this.grappaListener = listener;
        if (this.grappaListener == null) {
            if (oldGL != null) {
                this.removeMouseListener(this);
                this.removeMouseMotionListener(this);
                this.removeMouseWheelListener(this);
            }
            this.setToolTipText(null);
        } else {
            String tip;
            if (oldGL == null) {
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
                this.addMouseWheelListener(this);
            }
            if ((tip = this.graph.getToolTipText()) == null) {
                tip = Grappa.getToolTipText();
            }
            this.setToolTipText(tip);
        }
        return oldGL;
    }

    public GrappaListener removeGrappaListener() {
        return this.addGrappaListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        GrappaSize prevToSize = this.scaleToSize;
        boolean prevToFit = this.scaleToFit;
        if (pi >= 1) {
            return 1;
        }
        try {
            this.scaleToFit = false;
            this.scaleToSize = new GrappaSize(pf.getImageableWidth(), pf.getImageableHeight());
            ((Graphics2D)g).translate(pf.getImageableX(), pf.getImageableY());
            this.paintComponent(g);
        }
        finally {
            this.scaleToSize = prevToSize;
            this.scaleToFit = prevToFit;
        }
        return 0;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Point2D cpt = null;
        g2d.setClip(g.getClip());
        if (Grappa.synchronizePaint || this.graph.getSynchronizePaint()) {
            if (this.graph.setPaint(true)) {
                cpt = this.componentPaint(g2d);
                this.graph.setPaint(false);
            }
        } else {
            cpt = this.componentPaint(g2d);
        }
        if (cpt != null) {
            this.setCPT(cpt);
        }
    }

    void setCPT(Point2D cpt) {
        this.panelcpt = cpt;
    }

    Point2D getCPT() {
        return this.panelcpt;
    }

    public void reset() {
        try {
            this.graph.reset();
        }
        catch (Exception others) {
            others.printStackTrace();
        }
        this.XDOTShapes.remove(this.graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point2D componentPaint(Graphics g) {
        boolean didRedraw;
        if (this.subgraph == null || !this.subgraph.reserve()) {
            return null;
        }
        Graphics2D g2d = (Graphics2D)g;
        Point2D.Double cpt = null;
        GrappaBox bbox = new GrappaBox(this.subgraph.getBoundingBox());
        if (bbox == null) {
            return null;
        }
        GrappaSize margins = (GrappaSize)this.subgraph.getAttributeValue("margin");
        double x_margin = 0.0;
        double y_margin = 0.0;
        if (margins != null) {
            x_margin = 72.0 * margins.width;
            y_margin = 72.0 * margins.height;
            bbox.x -= x_margin;
            bbox.y -= y_margin;
            bbox.width += 2.0 * x_margin;
            bbox.height += 2.0 * y_margin;
        }
        this.subgLabels = this.subgraph.getShowSubgraphLabels();
        this.nodeLabels = this.subgraph.getShowNodeLabels();
        this.edgeLabels = this.subgraph.getShowEdgeLabels();
        if (Grappa.useAntiAliasing) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (Grappa.antiAliasText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (Grappa.useFractionalMetrics) {
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        g2d.setStroke(GrappaStyle.defaultStroke);
        this.oldTransform = this.transform;
        this.transform = new AffineTransform();
        if (this.scaleToFit || this.scaleToSize != null) {
            this.scaleFactor = 1.0;
            this.zoomBox = null;
            double scaleToWidth = 0.0;
            double scaleToHeight = 0.0;
            if (this.scaleToFit) {
                Container prnt;
                Container tprnt;
                for (tprnt = prnt = this.getParent(); tprnt != null && !(tprnt instanceof JViewport); tprnt = tprnt.getParent()) {
                }
                if (tprnt != null) {
                    prnt = tprnt;
                }
                if (prnt instanceof JViewport) {
                    Dimension sz = ((JViewport)prnt).getSize();
                    scaleToWidth = sz.width;
                    scaleToHeight = sz.height;
                } else {
                    Rectangle scaleTo = this.getVisibleRect();
                    scaleToWidth = scaleTo.width;
                    scaleToHeight = scaleTo.height;
                }
            } else {
                scaleToWidth = this.scaleToSize.width;
                scaleToHeight = this.scaleToSize.height;
            }
            double widthRatio = scaleToWidth / bbox.getWidth();
            double heightRatio = scaleToHeight / bbox.getHeight();
            double xTranslate = 0.0;
            double yTranslate = 0.0;
            if (widthRatio < heightRatio) {
                xTranslate = (scaleToWidth - widthRatio * bbox.getWidth()) / (2.0 * widthRatio);
                yTranslate = (scaleToHeight - widthRatio * bbox.getHeight()) / (2.0 * widthRatio);
                this.transform.scale(widthRatio, widthRatio);
                this.scaleInfo = widthRatio;
            } else {
                xTranslate = (scaleToWidth - heightRatio * bbox.getWidth()) / (2.0 * heightRatio);
                yTranslate = (scaleToHeight - heightRatio * bbox.getHeight()) / (2.0 * heightRatio);
                this.transform.scale(heightRatio, heightRatio);
                this.scaleInfo = heightRatio;
            }
            this.transform.translate(xTranslate, yTranslate);
            Dimension nsz = new Dimension((int)Math.ceil(scaleToWidth), (int)Math.ceil(scaleToHeight));
            if (this.prevsz == null || this.prevsz.getWidth() != nsz.getWidth() || this.prevsz.getHeight() != nsz.getHeight()) {
                this.setSize(nsz);
                this.setPreferredSize(nsz);
                this.prevsz = new Dimension(nsz.width, nsz.height);
            }
            this.transform.translate(-bbox.getMinX(), -bbox.getMinY());
            this.scaleFactor = this.scaleInfo;
        } else if (this.zoomBox != null) {
            Rectangle r;
            Container prnt;
            Container tprnt;
            for (tprnt = prnt = this.getParent(); tprnt != null && !(tprnt instanceof JViewport); tprnt = tprnt.getParent()) {
            }
            if (tprnt != null) {
                prnt = tprnt;
            }
            if (prnt instanceof JViewport) {
                Dimension sz = ((JViewport)prnt).getSize();
                r = new Rectangle(0, 0, sz.width, sz.height);
            } else {
                r = this.getVisibleRect();
            }
            this.scaleFactor = 1.0;
            if (this.zoomBox.width != 0.0 && this.zoomBox.height != 0.0 && this.oldTransform != null) {
                double scaleToWidth = r.width;
                double widthRatio = scaleToWidth / this.zoomBox.width;
                double scaleToHeight = r.height;
                double heightRatio = scaleToHeight / this.zoomBox.height;
                this.scaleFactor = widthRatio < heightRatio ? widthRatio : heightRatio;
                this.transform.scale(this.scaleFactor, this.scaleFactor);
                this.scaleInfo = this.scaleFactor;
                scaleToWidth = bbox.getWidth() * this.scaleFactor;
                scaleToHeight = bbox.getHeight() * this.scaleFactor;
                Dimension nsz = new Dimension((int)Math.ceil(scaleToWidth), (int)Math.ceil(scaleToHeight));
                if (this.prevsz == null || this.prevsz.getWidth() != nsz.getWidth() || this.prevsz.getHeight() != nsz.getHeight()) {
                    this.setSize(nsz);
                    this.setPreferredSize(nsz);
                    this.prevsz = new Dimension(nsz.width, nsz.height);
                }
                this.transform.translate(-bbox.getMinX(), -bbox.getMinY());
                cpt = new Point2D.Double(this.zoomBox.getCenterX(), this.zoomBox.getCenterY());
            }
            this.zoomBox = null;
            this.scaleFactor = this.scaleInfo;
        } else if (this.scaleFactor != 1.0) {
            Rectangle r = this.getVisibleRect();
            cpt = null;
            Container prnt = null;
            if (this.scaleChanged) {
                Container tprnt;
                for (tprnt = prnt = this.getParent(); tprnt != null && !(tprnt instanceof JViewport); tprnt = tprnt.getParent()) {
                }
                if (tprnt != null) {
                    prnt = tprnt;
                }
                if (prnt instanceof JViewport && this.inverseTransform != null) {
                    Point2D.Double pt = new Point2D.Double(r.x, r.y);
                    cpt = new Point2D.Double(r.x + r.width, r.y + r.height);
                    this.inverseTransform.transform(pt, pt);
                    this.inverseTransform.transform(cpt, cpt);
                    ((Point2D)cpt).setLocation(((Point2D)pt).getX() + (((Point2D)cpt).getX() - ((Point2D)pt).getX()) / 2.0, ((Point2D)pt).getY() + (((Point2D)cpt).getY() - ((Point2D)pt).getY()) / 2.0);
                } else {
                    prnt = null;
                }
            }
            this.transform.scale(this.scaleFactor, this.scaleFactor);
            this.scaleInfo = this.scaleFactor;
            int w = (int)Math.ceil(bbox.getWidth() * this.scaleFactor);
            int h = (int)Math.ceil(bbox.getHeight() * this.scaleFactor);
            w = w < r.width ? r.width : w;
            h = h < r.height ? r.height : h;
            Dimension nsz = new Dimension(w, h);
            if (this.prevsz == null || this.prevsz.getWidth() != nsz.getWidth() || this.prevsz.getHeight() != nsz.getHeight()) {
                this.setSize(nsz);
                this.setPreferredSize(nsz);
                this.prevsz = new Dimension(nsz.width, nsz.height);
            }
            this.transform.translate(-bbox.getMinX(), -bbox.getMinY());
        } else {
            cpt = null;
            Container prnt = null;
            if (this.scaleChanged) {
                Container tprnt;
                for (tprnt = prnt = this.getParent(); tprnt != null && !(tprnt instanceof JViewport); tprnt = tprnt.getParent()) {
                }
                if (tprnt != null) {
                    prnt = tprnt;
                }
                if (prnt instanceof JViewport && this.inverseTransform != null) {
                    Rectangle r = this.getVisibleRect();
                    Point2D.Double pt = new Point2D.Double(r.x, r.y);
                    cpt = new Point2D.Double(r.x + r.width, r.y + r.height);
                    this.inverseTransform.transform(pt, pt);
                    this.inverseTransform.transform(cpt, cpt);
                    ((Point2D)cpt).setLocation(((Point2D)pt).getX() + (((Point2D)cpt).getX() - ((Point2D)pt).getX()) / 2.0, ((Point2D)pt).getY() + (((Point2D)cpt).getY() - ((Point2D)pt).getY()) / 2.0);
                } else {
                    prnt = null;
                }
            }
            this.scaleInfo = 1.0;
            Dimension nsz = new Dimension((int)Math.ceil(bbox.getWidth()), (int)Math.ceil(bbox.getHeight()));
            if (this.prevsz == null || this.prevsz.getWidth() != nsz.getWidth() || this.prevsz.getHeight() != nsz.getHeight()) {
                this.setSize(nsz);
                this.setPreferredSize(nsz);
                this.prevsz = new Dimension(nsz.width, nsz.height);
            }
            this.transform.translate(-bbox.getMinX(), -bbox.getMinY());
        }
        this.scaleChanged = false;
        if (this.scaleInfo < Grappa.nodeLabelsScaleCutoff) {
            this.nodeLabels = false;
        }
        if (this.scaleInfo < Grappa.edgeLabelsScaleCutoff) {
            this.edgeLabels = false;
        }
        if (this.scaleInfo < Grappa.subgLabelsScaleCutoff) {
            this.subgLabels = false;
        }
        try {
            this.inverseTransform = this.transform.createInverse();
        }
        catch (NoninvertibleTransformException nite) {
            this.inverseTransform = null;
            nite.printStackTrace();
        }
        if (cpt != null && (didRedraw = this.centerPanelAtPoint(cpt))) {
            return null;
        }
        g2d.transform(this.transform);
        Rectangle clip = g2d.getClipBounds();
        --clip.x;
        --clip.y;
        clip.width += 2;
        clip.height += 2;
        Graph graph = this.graph;
        synchronized (graph) {
            GrappaNexus grappaNexus = this.subgraph.grappaNexus;
            if (grappaNexus != null) {
                Color bkgdColor = null;
                bkgdColor = (Color)this.graph.getGrappaAttributeValue("grappaBackgroundColor");
                g2d.setPaint(bkgdColor);
                g2d.fill(clip);
                List<SimplePolygon> xdotShapes = this.XDOTShapes.get(this.graph);
                if (xdotShapes == null) {
                    xdotShapes = this.xdotExtractDrawAttrShapes(this.graph);
                    this.XDOTShapes.put(this.graph, xdotShapes);
                }
                if (xdotShapes.size() > 0) {
                    g2d.translate(bbox.getMinX() + x_margin, bbox.getMinY() + y_margin);
                    this.xdotPaintShapes(xdotShapes, g2d);
                    g2d.translate(-(bbox.getMinX() + x_margin), -(bbox.getMinY() + y_margin));
                }
                if (grappaNexus.style.filled || grappaNexus.image != null) {
                    if (grappaNexus.style.filled) {
                        if (grappaNexus.fillcolor != null) {
                            bkgdColor = grappaNexus.fillcolor;
                            g2d.setPaint(bkgdColor);
                            grappaNexus.fill(g2d);
                            if (grappaNexus.color != null) {
                                g2d.setPaint(grappaNexus.color);
                            } else {
                                g2d.setPaint(grappaNexus.style.line_color);
                            }
                        } else {
                            bkgdColor = grappaNexus.color;
                            g2d.setPaint(bkgdColor);
                            grappaNexus.fill(g2d);
                            g2d.setPaint(grappaNexus.style.line_color);
                        }
                    }
                    grappaNexus.drawImage(g2d);
                    if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                        g2d.setStroke(grappaNexus.style.stroke);
                        grappaNexus.draw(g2d);
                        g2d.setStroke(GrappaStyle.defaultStroke);
                    } else {
                        grappaNexus.draw(g2d);
                    }
                }
                if (this.backer != null && Grappa.backgroundDrawing) {
                    this.backer.drawBackground(g2d, this.graph, bbox, clip);
                }
                this.paintSubgraph(g2d, this.subgraph, clip, bkgdColor);
            }
        }
        this.subgraph.release();
        return cpt;
    }

    public boolean centerPanelAtPoint(Point2D cpt) {
        Container prnt;
        Container tprnt;
        for (tprnt = prnt = this.getParent(); tprnt != null && !(tprnt instanceof JViewport); tprnt = tprnt.getParent()) {
        }
        if (tprnt != null) {
            prnt = tprnt;
        }
        if (prnt instanceof JViewport) {
            JViewport viewport = (JViewport)prnt;
            this.transform.transform(cpt, cpt);
            Dimension viewsize = viewport.getExtentSize();
            viewport.setViewPosition(new Point((int)(cpt.getX() - (double)viewsize.width / 2.0), (int)(cpt.getY() - (double)viewsize.height / 2.0)));
            return true;
        }
        return false;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public AffineTransform getInverseTransform() {
        return this.inverseTransform;
    }

    @Override
    public void setToolTipText(String tip) {
        super.setToolTipText(tip);
    }

    @Override
    public String getToolTipText(MouseEvent mev) {
        if (this.inverseTransform == null || this.grappaListener == null) {
            return null;
        }
        Point2D pt = this.inverseTransform.transform(mev.getPoint(), null);
        return this.grappaListener.grappaTip(this.subgraph, this.findContainingElement(this.subgraph, pt), new GrappaPoint(pt.getX(), pt.getY()), mev.getModifiers(), this);
    }

    public void setScaleToFit(boolean setting) {
        this.prevsz = null;
        this.scaleToFit = setting;
    }

    public void setScaleToSize(Dimension2D scaleSize) {
        this.prevsz = null;
        this.scaleToSize = scaleSize == null ? null : new GrappaSize(scaleSize.getWidth(), scaleSize.getHeight());
    }

    public Subgraph getSubgraph() {
        return this.subgraph;
    }

    public void resetZoom() {
        this.scaleChanged = this.scaleFactor != 1.0;
        this.scaleFactor = 1.0;
        this.zoomBox = null;
    }

    public boolean hasOutline() {
        return this.savedOutline != null;
    }

    public void clearOutline() {
        this.savedOutline = null;
    }

    public GrappaBox zoomToOutline() {
        this.zoomBox = null;
        if (this.savedOutline != null) {
            this.scaleFactor = 1.0;
            this.zoomBox = new GrappaBox(this.savedOutline);
            this.savedOutline = null;
        }
        return this.zoomBox;
    }

    public GrappaBox zoomToOutline(GrappaBox outline) {
        this.zoomBox = null;
        if (outline != null) {
            this.scaleFactor = 1.0;
            this.zoomBox = new GrappaBox(outline);
        }
        return this.zoomBox;
    }

    public double multiplyScaleFactor(double multiplier) {
        double old = this.scaleFactor;
        this.zoomBox = null;
        this.scaleFactor *= multiplier;
        if (this.scaleFactor == 0.0) {
            this.scaleFactor = old;
        }
        this.scaleChanged = this.scaleFactor != old;
        return old;
    }

    public void setScaleFactor(double scaleFactor) {
        double old = this.scaleFactor;
        this.zoomBox = null;
        this.scaleFactor = scaleFactor;
        this.scaleChanged = scaleFactor != old;
    }

    private void paintSubgraph(Graphics2D g2d, Subgraph subg, Shape clipper, Color bkgdColor) {
        if (subg != this.subgraph && !subg.reserve()) {
            return;
        }
        Rectangle2D bbox = subg.getBoundingBox();
        GrappaNexus grappaNexus = subg.grappaNexus;
        if (bbox != null && grappaNexus != null && subg.visible && !grappaNexus.style.invis && clipper.intersects(bbox)) {
            boolean drawNodes;
            boolean drawSubgraphs;
            boolean drawEdges;
            int i;
            if (subg != this.subgraph) {
                g2d.setPaint(grappaNexus.color);
                if (grappaNexus.style.filled) {
                    if (grappaNexus.fillcolor != null) {
                        bkgdColor = grappaNexus.fillcolor;
                        grappaNexus.fill(g2d);
                        if (grappaNexus.color != null) {
                            g2d.setPaint(grappaNexus.color);
                        } else {
                            g2d.setPaint(grappaNexus.style.line_color);
                        }
                    } else {
                        bkgdColor = grappaNexus.color;
                        grappaNexus.fill(g2d);
                        g2d.setPaint(grappaNexus.style.line_color);
                    }
                } else if (grappaNexus.color == bkgdColor) {
                    g2d.setPaint(grappaNexus.style.line_color);
                }
                grappaNexus.drawImage(g2d);
                if (subg.isCluster() || Grappa.outlineSubgraphs) {
                    if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                        g2d.setStroke(grappaNexus.style.stroke);
                        grappaNexus.draw(g2d);
                        g2d.setStroke(GrappaStyle.defaultStroke);
                    } else {
                        grappaNexus.draw(g2d);
                    }
                }
            }
            if ((subg.highlight & 2) == 2) {
                g2d.setPaint(this.deletionStyle.line_color);
                if (GrappaStyle.defaultStroke != this.deletionStyle.stroke) {
                    g2d.setStroke(this.deletionStyle.stroke);
                    grappaNexus.draw(g2d);
                    g2d.setStroke(GrappaStyle.defaultStroke);
                } else {
                    grappaNexus.draw(g2d);
                }
            } else if ((subg.highlight & 1) == 1) {
                g2d.setPaint(this.selectionStyle.line_color);
                if (GrappaStyle.defaultStroke != this.selectionStyle.stroke) {
                    g2d.setStroke(this.selectionStyle.stroke);
                    grappaNexus.draw(g2d);
                    g2d.setStroke(GrappaStyle.defaultStroke);
                } else {
                    grappaNexus.draw(g2d);
                }
            }
            if (grappaNexus.lstr != null && this.subgLabels) {
                g2d.setFont(grappaNexus.font);
                g2d.setPaint(grappaNexus.font_color);
                for (i = 0; i < grappaNexus.lstr.length; ++i) {
                    if (grappaNexus.lstr[i] == null || grappaNexus.lstr[i].length() <= 0) continue;
                    if (grappaNexus.lstr[i].charAt(0) == '<' && grappaNexus.lstr[i].charAt(grappaNexus.lstr[i].length() - 1) == '>') {
                        String str = this.toHTML(grappaNexus.lstr[i].substring(1, grappaNexus.lstr[i].length() - 1));
                        this.surrogateLabel.setText(str);
                        this.surrogateLabel.setSize(this.surrogateLabel.getPreferredSize());
                        g2d.translate((int)grappaNexus.lpos[i].x, (int)grappaNexus.lpos[i].y);
                        this.surrogateLabel.paint(g2d);
                        g2d.translate(-((int)grappaNexus.lpos[i].x), -((int)grappaNexus.lpos[i].y));
                        continue;
                    }
                    g2d.drawString(grappaNexus.lstr[i], (int)grappaNexus.lpos[i].x, (int)grappaNexus.lpos[i].y);
                }
            }
            if (drawEdges = true) {
                Edge[] edges = subg.edgeElementsAsArray();
                Composite composite = g2d.getComposite();
                Stroke stroke = g2d.getStroke();
                if (this.edgeAlpha != 1.0f) {
                    AlphaComposite alpha = AlphaComposite.getInstance(3, this.edgeAlpha);
                    g2d.setComposite(alpha);
                }
                if (stroke instanceof BasicStroke) {
                    float f = ((BasicStroke)stroke).getLineWidth();
                    BasicStroke newStroke = new BasicStroke((float)((double)f * 1.0 / this.scaleFactor));
                    g2d.setStroke(newStroke);
                }
                ArrayList<Edge> deferredEdgeLabels = new ArrayList<Edge>(edges.length);
                for (Edge edge : edges) {
                    if (edge == null || !edge.reserve()) continue;
                    grappaNexus = edge.grappaNexus;
                    if (grappaNexus != null && edge.visible && !grappaNexus.style.invis && clipper.intersects(grappaNexus.rawBounds2D())) {
                        grappaNexus.drawImage(g2d);
                        if ((edge.highlight & 2) == 2) {
                            g2d.setPaint(this.deletionStyle.line_color);
                            grappaNexus.fill(g2d);
                            if (GrappaStyle.defaultStroke != this.deletionStyle.stroke) {
                                g2d.setStroke(this.deletionStyle.stroke);
                                grappaNexus.draw(g2d);
                                g2d.setStroke(GrappaStyle.defaultStroke);
                            } else {
                                grappaNexus.draw(g2d);
                            }
                        } else if ((edge.highlight & 1) == 1) {
                            g2d.setPaint(this.selectionStyle.line_color);
                            grappaNexus.fill(g2d);
                            if (GrappaStyle.defaultStroke != this.selectionStyle.stroke) {
                                g2d.setStroke(this.selectionStyle.stroke);
                                grappaNexus.draw(g2d);
                                g2d.setStroke(GrappaStyle.defaultStroke);
                            } else {
                                grappaNexus.draw(g2d);
                            }
                        } else {
                            g2d.setPaint(grappaNexus.color);
                            GrappaLine gl = null;
                            if (grappaNexus.shape instanceof GrappaLine) {
                                gl = (GrappaLine)grappaNexus.shape;
                                GrappaPoint[] pts = gl.getGrappaPoints();
                                if (pts.length == 2 && gl.getArrowType() == 0) {
                                    if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                                        g2d.setStroke(grappaNexus.style.stroke);
                                        g2d.drawLine((int)Math.round(pts[0].x), (int)Math.round(pts[0].y), (int)Math.round(pts[1].x), (int)Math.round(pts[1].y));
                                        g2d.setStroke(GrappaStyle.defaultStroke);
                                    } else {
                                        g2d.drawLine((int)Math.round(pts[0].x), (int)Math.round(pts[0].y), (int)Math.round(pts[1].x), (int)Math.round(pts[1].y));
                                    }
                                } else {
                                    grappaNexus.fill(g2d);
                                }
                            } else {
                                grappaNexus.fill(g2d);
                            }
                            if (gl == null || gl.getGrappaPoints().length != 2 || gl.getArrowType() != 0) {
                                if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                                    g2d.setStroke(grappaNexus.style.stroke);
                                    grappaNexus.draw(g2d);
                                    g2d.setStroke(GrappaStyle.defaultStroke);
                                } else {
                                    grappaNexus.draw(g2d);
                                }
                            }
                        }
                        if (grappaNexus.lstr != null && grappaNexus.lstr.length > 0 && this.edgeLabels) {
                            deferredEdgeLabels.add(edge);
                        }
                    }
                    edge.release();
                }
                if (this.edgeAlpha != 1.0f) {
                    g2d.setComposite(composite);
                }
                if (deferredEdgeLabels != null) {
                    for (Edge dEdge : deferredEdgeLabels) {
                        GrappaNexus gn = dEdge.grappaNexus;
                        if (!dEdge.reserve()) continue;
                        g2d.setFont(gn.font);
                        g2d.setPaint(gn.font_color);
                        for (i = 0; i < gn.lstr.length; ++i) {
                            if (gn.lstr[i].charAt(0) == '<' && gn.lstr[i].charAt(gn.lstr[i].length() - 1) == '>') {
                                String str = this.toHTML(gn.lstr[i].substring(1, gn.lstr[i].length() - 1));
                                this.surrogateLabel.setText(str);
                                this.surrogateLabel.setSize(this.surrogateLabel.getPreferredSize());
                                g2d.translate((int)gn.lpos[i].x, (int)gn.lpos[i].y);
                                this.surrogateLabel.paint(g2d);
                                g2d.translate(-((int)gn.lpos[i].x), -((int)gn.lpos[i].y));
                                continue;
                            }
                            g2d.drawString(gn.lstr[i], (int)gn.lpos[i].x, (int)gn.lpos[i].y);
                        }
                        dEdge.release();
                    }
                }
                g2d.setStroke(stroke);
            }
            if (drawSubgraphs = true) {
                Iterator<Subgraph> enm = subg.subgraphElements();
                Subgraph subsubg = null;
                while (enm.hasNext()) {
                    subsubg = enm.next();
                    if (subsubg == null) continue;
                    this.paintSubgraph(g2d, subsubg, clipper, bkgdColor);
                }
            }
            if (drawNodes = true) {
                Node[] nodes;
                for (Node node : nodes = subg.nodeElementsAsArray()) {
                    if (node == null || !node.reserve()) continue;
                    grappaNexus = node.grappaNexus;
                    if (grappaNexus != null && node.visible && !grappaNexus.style.invis && clipper.intersects(grappaNexus.rawBounds2D())) {
                        if (grappaNexus.style.filled) {
                            if (grappaNexus.fillcolor != null) {
                                g2d.setPaint(grappaNexus.fillcolor);
                                grappaNexus.fill(g2d);
                                if (grappaNexus.color != null) {
                                    g2d.setPaint(grappaNexus.color);
                                } else {
                                    g2d.setPaint(grappaNexus.style.line_color);
                                }
                            } else {
                                g2d.setPaint(grappaNexus.color);
                                grappaNexus.fill(g2d);
                                g2d.setPaint(grappaNexus.style.line_color);
                            }
                        } else {
                            g2d.setPaint(grappaNexus.color);
                        }
                        grappaNexus.drawImage(g2d);
                        if ((node.highlight & 2) == 2) {
                            g2d.setPaint(this.deletionStyle.line_color);
                            if (GrappaStyle.defaultStroke != this.deletionStyle.stroke) {
                                g2d.setStroke(this.deletionStyle.stroke);
                                grappaNexus.draw(g2d);
                                g2d.setStroke(GrappaStyle.defaultStroke);
                            } else {
                                grappaNexus.draw(g2d);
                            }
                        } else if ((node.highlight & 1) == 1) {
                            g2d.setPaint(this.selectionStyle.line_color);
                            if (GrappaStyle.defaultStroke != this.selectionStyle.stroke) {
                                g2d.setStroke(this.selectionStyle.stroke);
                                grappaNexus.draw(g2d);
                                g2d.setStroke(GrappaStyle.defaultStroke);
                            } else {
                                grappaNexus.draw(g2d);
                            }
                        } else if (GrappaStyle.defaultStroke != grappaNexus.style.stroke) {
                            g2d.setStroke(grappaNexus.style.stroke);
                            grappaNexus.draw(g2d);
                            g2d.setStroke(GrappaStyle.defaultStroke);
                        } else {
                            grappaNexus.draw(g2d);
                        }
                        if (grappaNexus.lstr != null && this.nodeLabels) {
                            g2d.setFont(grappaNexus.font);
                            g2d.setPaint(grappaNexus.font_color);
                            for (i = 0; i < grappaNexus.lstr.length; ++i) {
                                if (grappaNexus.lstr[i].charAt(0) == '<' && grappaNexus.lstr[i].charAt(grappaNexus.lstr[i].length() - 1) == '>') {
                                    String str = this.toHTML(grappaNexus.lstr[i].substring(1, grappaNexus.lstr[i].length() - 1));
                                    this.surrogateLabel.setText(str);
                                    this.surrogateLabel.setSize(this.surrogateLabel.getPreferredSize());
                                    g2d.translate((int)grappaNexus.lpos[i].x, (int)grappaNexus.lpos[i].y);
                                    this.surrogateLabel.paint(g2d);
                                    g2d.translate(-((int)grappaNexus.lpos[i].x), -((int)grappaNexus.lpos[i].y));
                                    continue;
                                }
                                g2d.drawString(grappaNexus.lstr[i], (int)grappaNexus.lpos[i].x, (int)grappaNexus.lpos[i].y);
                            }
                        }
                    }
                    node.release();
                }
            }
        }
        subg.release();
    }

    private String toHTML(String str) {
        StringBuilder newStr = new StringBuilder("<html>" + str + "</html>");
        newStr = this.munged(newStr);
        return newStr.toString();
    }

    private StringBuilder munged(StringBuilder str) {
        int idx = 0;
        int fromIdx = 0;
        while (idx >= 0) {
            idx = str.indexOf("<img", fromIdx);
            if (idx < 0) {
                idx = str.indexOf("<IMG", fromIdx);
            }
            if (idx < 0) continue;
            int eidx = str.indexOf(">", idx + 4);
            String imgTag = str.substring(idx, eidx);
            String newImgTag = this.fixImgTag(imgTag);
            str.replace(idx, eidx, newImgTag);
            fromIdx = eidx;
        }
        return str;
    }

    private String fixImgTag(String str) {
        int idx = str.indexOf("SRC=");
        if (idx < 0) {
            idx = str.indexOf("src=");
        }
        if (idx > 0) {
            int mark0;
            idx += 4;
            while (str.charAt(idx) != '\"') {
                ++idx;
            }
            idx = mark0 = idx + 1;
            while (str.charAt(idx) != '\"') {
                ++idx;
            }
            int mark1 = idx;
            String loc = str.substring(mark0, mark1);
            URL u = this.getClass().getClassLoader().getResource(loc);
            if (u != null) {
                str = str.substring(0, mark0) + u.toString() + str.substring(mark1);
            }
        }
        return str;
    }

    private Element findContainingElement(Subgraph subg, Point2D pt) {
        return this.findContainingElement(subg, pt, null);
    }

    private Element findContainingElement(Subgraph subg, Point2D pt, Element crnt) {
        Element[] stash = new Element[]{crnt, null};
        Element elem = this.reallyFindContainingElement(subg, pt, stash);
        if (elem == null) {
            elem = stash[1];
        }
        return elem;
    }

    private Element reallyFindContainingElement(Subgraph subg, Point2D pt, Element[] stash) {
        Rectangle2D bb = subg.getBoundingBox();
        GrappaNexus grappaNexus = null;
        if (bb.contains(pt)) {
            Iterator<Element> enm;
            if ((Grappa.elementSelection & 2) == 2) {
                enm = subg.edgeElements();
                while (enm.hasNext()) {
                    Edge edge = enm.next();
                    grappaNexus = edge.grappaNexus;
                    if (grappaNexus == null || !edge.selectable || !grappaNexus.rawBounds2D().contains(pt) || !grappaNexus.contains(pt.getX(), pt.getY())) continue;
                    if (stash[0] == null) {
                        return edge;
                    }
                    if (stash[1] == null) {
                        stash[1] = edge;
                    }
                    if (stash[0] != edge) continue;
                    stash[0] = null;
                }
            }
            if ((Grappa.elementSelection & 1) == 1) {
                enm = subg.nodeElements();
                while (enm.hasNext()) {
                    Node node = (Node)enm.next();
                    grappaNexus = node.grappaNexus;
                    if (grappaNexus == null || !node.selectable || !grappaNexus.rawBounds2D().contains(pt) || !grappaNexus.contains(pt)) continue;
                    if (stash[0] == null) {
                        return node;
                    }
                    if (stash[1] == null) {
                        stash[1] = node;
                    }
                    if (stash[0] != node) continue;
                    stash[0] = null;
                }
            }
            Element subelem = null;
            Iterator<Subgraph> enm2 = subg.subgraphElements();
            while (enm2.hasNext()) {
                subelem = this.reallyFindContainingElement(enm2.next(), pt, stash);
                if (subelem == null || !subelem.selectable) continue;
                if (stash[0] == null) {
                    return subelem;
                }
                if (stash[1] == null) {
                    stash[1] = subelem;
                }
                if (stash[0] != subelem) continue;
                stash[0] = null;
            }
            if ((Grappa.elementSelection & 4) == 4 && subg.selectable) {
                if (stash[0] == null) {
                    return subg;
                }
                if (stash[1] == null) {
                    stash[1] = subg;
                }
                if (stash[0] == subg) {
                    stash[0] = null;
                }
            }
        }
        return null;
    }

    @Override
    public void ancestorMoved(AncestorEvent aev) {
    }

    @Override
    public void ancestorAdded(AncestorEvent aev) {
        this.graph.addPanel(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent aev) {
        this.graph.removePanel(this);
    }

    @Override
    public void componentHidden(ComponentEvent cev) {
    }

    @Override
    public void componentMoved(ComponentEvent cev) {
    }

    @Override
    public void componentResized(ComponentEvent cev) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent cev) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pmev) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pmev) {
        this.inMenu = false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pmev) {
        this.inMenu = true;
    }

    @Override
    public void mouseClicked(MouseEvent mev) {
        if (this.panMode) {
            JViewport vport = this.getViewPort();
            this.panPoint = SwingUtilities.convertPoint(this, mev.getPoint(), vport);
        } else {
            if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
                return;
            }
            Point2D pt = this.inverseTransform.transform(mev.getPoint(), null);
            this.grappaListener.grappaClicked(this.subgraph, this.findContainingElement(this.subgraph, pt, this.subgraph.currentSelection != null && this.subgraph.currentSelection instanceof Element ? (Element)this.subgraph.currentSelection : null), new GrappaPoint(pt.getX(), pt.getY()), mev.getModifiers(), mev.getClickCount(), this);
        }
    }

    @Override
    public void mousePressed(MouseEvent mev) {
        if (this.panMode) {
            JViewport vport = this.getViewPort();
            this.panPoint = SwingUtilities.convertPoint(this, mev.getPoint(), vport);
        } else {
            if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
                return;
            }
            Point2D pt = this.inverseTransform.transform(mev.getPoint(), null);
            this.outline = null;
            this.pressedElement = this.findContainingElement(this.subgraph, pt);
            this.pressedPoint = new GrappaPoint(pt.getX(), pt.getY());
            this.pressedModifiers = mev.getModifiers();
            this.grappaListener.grappaPressed(this.subgraph, this.pressedElement, this.pressedPoint, this.pressedModifiers, this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mev) {
        if (!this.panMode) {
            if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
                return;
            }
            int modifiers = mev.getModifiers();
            Point2D pt = this.inverseTransform.transform(mev.getPoint(), null);
            GrappaPoint gpt = new GrappaPoint(pt.getX(), pt.getY());
            this.grappaListener.grappaReleased(this.subgraph, this.findContainingElement(this.subgraph, pt), gpt, modifiers, this.pressedElement, this.pressedPoint, this.pressedModifiers, this.outline, this);
            if ((modifiers & 0x10) != 0 && (modifiers & 0x10) == modifiers) {
                if (this.outline != null) {
                    this.savedOutline = GrappaSupport.boxFromCorners(this.outline, this.pressedPoint.x, this.pressedPoint.y, gpt.x, gpt.y);
                    this.outline = null;
                } else {
                    this.savedOutline = null;
                }
            }
        } else {
            JViewport vport = this.getViewPort();
            this.panPoint = SwingUtilities.convertPoint(this, mev.getPoint(), vport);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mev) {
    }

    @Override
    public void mouseExited(MouseEvent mev) {
    }

    private JViewport getViewPort() {
        Container tprnt;
        for (tprnt = this.getParent(); tprnt != null && !(tprnt instanceof JViewport); tprnt = tprnt.getParent()) {
        }
        return (JViewport)tprnt;
    }

    private void panView(int dx, int dy) {
        JViewport vport = this.getViewPort();
        Rectangle r = vport.getViewRect();
        r.translate(-dx, -dy);
        r = SwingUtilities.convertRectangle(vport.getView(), r, vport);
        vport.scrollRectToVisible(r);
    }

    @Override
    public void mouseDragged(MouseEvent mev) {
        if (this.panMode) {
            JViewport vport = this.getViewPort();
            Point panPoint2 = SwingUtilities.convertPoint(this, mev.getPoint(), vport);
            int dx = panPoint2.x - this.panPoint.x;
            int dy = panPoint2.y - this.panPoint.y;
            this.panView(dx, dy);
            this.panPoint = panPoint2;
        } else {
            if (this.inverseTransform == null || this.grappaListener == null || this.inMenu) {
                return;
            }
            int modifiers = mev.getModifiers();
            Point2D pt = this.inverseTransform.transform(mev.getPoint(), null);
            GrappaPoint gpt = new GrappaPoint(pt.getX(), pt.getY());
            this.grappaListener.grappaDragged(this.subgraph, gpt, modifiers, this.pressedElement, this.pressedPoint, this.pressedModifiers, this.outline, this);
            if ((modifiers & 0x10) != 0 && (modifiers & 0x10) == modifiers) {
                this.outline = GrappaSupport.boxFromCorners(this.outline, this.pressedPoint.x, this.pressedPoint.y, gpt.x, gpt.y);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        double dir = evt.getWheelRotation() < 0 ? -1.0 : 1.0;
        double z = dir * (Math.abs((double)evt.getWheelRotation() * this.mouseWheelFactor) / 100.0);
        this.multiplyScaleFactor(1.0 + z);
        this.repaint();
    }

    public void setMouseWheelFactor(double mouseWheelFactor) {
        this.mouseWheelFactor = mouseWheelFactor;
    }

    public double getMouseWheelFactor() {
        return this.mouseWheelFactor;
    }

    public void setEdgeAlpha(float edgeAlpha) {
        this.edgeAlpha = edgeAlpha;
    }

    public float getEdgeAlpha() {
        return this.edgeAlpha;
    }

    public void setPanMode(boolean panMode) {
        this.panMode = panMode;
        if (panMode) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean getPanMode() {
        return this.panMode;
    }

    @Override
    public void run() {
        Point2D cpt = this.getCPT();
        if (cpt != null) {
            this.centerPanelAtPoint(cpt);
        }
    }

    private List<SimplePolygon> xdotExtractDrawAttrShapes(Graph graph) {
        ArrayList<SimplePolygon> shapes = new ArrayList<SimplePolygon>();
        Attribute attr = graph.getAttribute("_draw_");
        if (attr != null) {
            String str = attr.getStringValue();
            StringTokenizer st = new StringTokenizer(str, " ");
            Color lineColor = null;
            Color fillColor = null;
            while (st.hasMoreTokens()) {
                String sSomeN;
                String token = st.nextToken();
                if ("c".equals(token)) {
                    sSomeN = st.nextToken();
                    String sColor = st.nextToken().substring(1);
                    if (sColor.startsWith("#")) {
                        lineColor = Color.decode(sColor);
                        continue;
                    }
                    lineColor = Color.getColor(sColor);
                    continue;
                }
                if ("C".equals(token)) {
                    sSomeN = st.nextToken();
                    String sColor = st.nextToken().substring(1);
                    if (sColor.startsWith("#")) {
                        fillColor = Color.decode(sColor);
                        continue;
                    }
                    fillColor = Color.getColor(sColor);
                    continue;
                }
                if (!"P".equals(token)) continue;
                String sNumberPoints = st.nextToken();
                int np = Integer.valueOf(sNumberPoints);
                SimplePolygon poly = new SimplePolygon();
                String xStr = st.nextToken();
                String yStr = st.nextToken();
                double x = Double.valueOf(xStr);
                double y = Double.valueOf(yStr);
                poly.moveTo(x, y);
                for (int i = 1; i < np; ++i) {
                    xStr = st.nextToken();
                    yStr = st.nextToken();
                    x = Double.valueOf(xStr);
                    y = Double.valueOf(yStr);
                    poly.lineTo(x, y);
                }
                poly.closePath();
                if (fillColor != null) {
                    poly.setFillColor(fillColor);
                }
                if (lineColor != null) {
                    poly.setLineColor(lineColor);
                }
                shapes.add(poly);
            }
        }
        return shapes;
    }

    private void xdotPaintShapes(List<SimplePolygon> polys, Graphics2D g2d) {
        Color oc = g2d.getColor();
        for (SimplePolygon poly : polys) {
            Color fc = poly.getFillColor();
            if (fc != null) {
                g2d.setColor(fc);
            } else {
                g2d.setColor(oc);
            }
            g2d.fill(poly);
            Color lc = poly.getLineColor();
            if (lc != null && !lc.equals(fc)) {
                g2d.setColor(lc);
                g2d.draw(poly);
            }
            g2d.setColor(oc);
        }
    }
}

