/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.GraphIterator;
import att.grappa.Grappa;
import att.grappa.GrappaBacker;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaListener;
import att.grappa.GrappaPanel;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSize;
import att.grappa.GrappaSupport;
import att.grappa.Node;
import att.grappa.Subgraph;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.visualisation.ActionButton;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.ContainerViewer;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DebuggingSupport;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.MouseViewletMenuUpPopper;
import com.parctechnologies.eclipse.visualisation.MultiViewletType;
import com.parctechnologies.eclipse.visualisation.SparseViewletStore;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.ViewerCommand;
import com.parctechnologies.eclipse.visualisation.ViewletArray;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletDataStoreListener;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletRangeCollection;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import com.parctechnologies.eclipse.visualisation.ZoomableViewer;
import com.parctechnologies.eclipse.visualisation.ZoomableViewerZoomToFitHeightCommand;
import com.parctechnologies.eclipse.visualisation.ZoomableViewerZoomToFitWidthCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class GraphViewer
extends ContainerViewer
implements ZoomableViewer,
Printable {
    public static final int DESKTOP_TYPE = 0;
    public static final int NETWORK_TYPE = 1;
    public static final double STEADY_GRAPH_SOFT_MARGIN = 100.0;
    protected static final String DIRECTED_TB = "directed (Top->Bottom)";
    protected static final String DIRECTED_LR = "directed (Left->Right)";
    protected static final String UNDIRECTED = "undirected";
    protected static final String RADIAL = "radial";
    protected static final String REROUTE_STRAIGHT = "re-route edges (straight)";
    protected static final String REROUTE_SPLINE = "re-route edges (splines)";
    protected int type;
    protected int imageCounter;
    protected GrappaPanel graphPanel;
    protected SteadyGraph graph;
    protected JScrollPane scrollPane;
    protected Map layoutActionMap;
    protected boolean trackExpansions = false;
    protected Map elementToViewletType;
    protected GraphViewBacker backer;
    protected boolean moveable;

    public GraphViewer(ViewletType viewletType, VisClientStateModel visClientStateModel, Viewable viewable, int n) {
        super(visClientStateModel, viewable, viewletType);
        this.type = n;
        this.elementToViewletType = new HashMap();
        this.imageCounter = 0;
        this.moveable = true;
        this.layoutActionMap = new HashMap();
        this.layoutActionMap.put(DIRECTED_TB, new LayoutAction(this, DIRECTED_TB, "dot -Geclipse -Grankdir=TB"));
        this.layoutActionMap.put(DIRECTED_LR, new LayoutAction(this, DIRECTED_LR, "dot -Geclipse -Grankdir=LR"));
        this.layoutActionMap.put(UNDIRECTED, new LayoutAction(this, UNDIRECTED, "neato -Geclipse"));
        this.layoutActionMap.put(RADIAL, new LayoutAction(this, RADIAL, "twopi -Geclipse"));
        this.layoutActionMap.put(REROUTE_STRAIGHT, new LayoutAction(this, REROUTE_STRAIGHT, "neato -Geclipse -s -n"));
        this.layoutActionMap.put(REROUTE_SPLINE, new LayoutAction(this, REROUTE_SPLINE, "neato -Geclipse -s -n -Gsplines"));
        this.initialiseMenu();
    }

    public ViewletData getViewletAt(List list) {
        return this.viewletDataStore.getViewletDataAt(list);
    }

    @Override
    public Collection getViewletDataAt(List list) {
        LinkedList<ViewletData> linkedList = new LinkedList<ViewletData>();
        linkedList.add(this.getViewletAt(list));
        return linkedList;
    }

    @Override
    protected int getMenuMnemonic(String string) {
        if ("Graph".equals(string)) {
            return 71;
        }
        if ("Insert".equals(string)) {
            return 73;
        }
        return super.getMenuMnemonic(string);
    }

    protected void initialiseMenu() {
        this.addMenuAndPopupMenuItem("View", null);
        this.addMenuAndPopupMenuItem("View", new GrappaAntiAliasToggleAction());
        this.addMenuAndPopupMenuItem("Graph", new SetBackgroundAction(this, false));
        this.addMenuAndPopupMenuItem("Graph", new SetBackgroundAction(this, true));
        this.addMenuAndPopupMenuItem("Graph", null);
        if (this.type == 1) {
            this.addMenuAndPopupMenuItem("Graph", (LayoutAction)this.layoutActionMap.get(DIRECTED_TB));
            this.addMenuAndPopupMenuItem("Graph", (LayoutAction)this.layoutActionMap.get(DIRECTED_LR));
            this.addMenuAndPopupMenuItem("Graph", (LayoutAction)this.layoutActionMap.get(UNDIRECTED));
        }
        this.addMenuAndPopupMenuItem("Graph", (LayoutAction)this.layoutActionMap.get(RADIAL));
        if (this.type == 1) {
            this.addMenuAndPopupMenuItem("Graph", null);
            this.addMenuAndPopupMenuItem("Graph", (LayoutAction)this.layoutActionMap.get(REROUTE_STRAIGHT));
            this.addMenuAndPopupMenuItem("Graph", (LayoutAction)this.layoutActionMap.get(REROUTE_SPLINE));
        }
        this.addMenuAndPopupMenuItem("Insert", new AddImageAction(this));
        this.addMenuAndPopupMenuItem("Insert", null);
        if (this.type == 0) {
            for (ViewletType viewletType : ((MultiViewletType)this.viewletType).getViewletTypeCollection()) {
                this.addMenuAndPopupMenuItem("Insert", new AddViewletAction(this, viewletType));
            }
        }
    }

    @Override
    protected Action getZoomToFitWidthAction() {
        return new ZoomToFitWidthAction(this);
    }

    @Override
    protected Action getZoomToFitHeightAction() {
        return new ZoomToFitHeightAction(this);
    }

    @Override
    public void prepareForEvent(VisEvent visEvent) {
        if (visEvent instanceof CreateEvent) {
            this.prepareForCreate((CreateEvent)visEvent);
        }
        if (visEvent instanceof ExpandEvent) {
            this.prepareForExpand((ExpandEvent)visEvent);
        }
        super.prepareForEvent(visEvent);
    }

    protected void prepareForCreate(CreateEvent createEvent) {
        switch (this.type) {
            case 1: {
                this.viewletDataStore = new ViewletArray(createEvent.getViewableSize(), ((ViewableType.ArrayType)createEvent.getViewableType()).getFixityList(), this.getViewable(), (ViewletFactory)((Object)this.viewletType));
                this.viewletDataStore.setSymRef(new SymRef(this.viewletDataStore, this.getSymRef(), "store"));
                break;
            }
            default: {
                this.viewletDataStore = new SparseViewletStore(createEvent.getViewableSize(), ((ViewableType.ArrayType)createEvent.getViewableType()).getFixityList(), this.getViewable());
                this.viewletDataStore.setSymRef(new SymRef(this.viewletDataStore, this.getSymRef(), "store"));
            }
        }
        this.viewletDataStore.addViewletDataStoreListener(new StoreListener());
    }

    protected void prepareForExpand(ExpandEvent expandEvent) {
        this.viewletDataStore.startExpandDimension(expandEvent.getExpandingDimension());
    }

    @Override
    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof UpdateEvent) {
            super.startEvent(visEvent, list);
            return;
        }
        if (visEvent instanceof CreateEvent) {
            super.startEvent(visEvent, list);
            this.initialiseGraph();
            this.initialiseComponent();
            return;
        }
        if (visEvent instanceof ExpandEvent) {
            super.startEvent(visEvent, list);
            return;
        }
        if (visEvent instanceof ContractEvent) {
            super.startEvent(visEvent, list);
            this.removeContractedElements(((ContractEvent)visEvent).getViewableSize());
            return;
        }
        super.startEvent(visEvent, list);
    }

    void removeContractedElements(List list) {
        GraphIterator graphIterator = this.graph.elements();
        while (graphIterator.hasNext()) {
            List list2;
            Element element = graphIterator.nextGraphElement();
            try {
                list2 = this.stringToIndexList(element.getName());
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                int n;
                int n2 = (Integer)list2.get(i);
                if (n2 <= (n = ((Integer)list.get(i)).intValue())) continue;
                bl = true;
            }
            if (!bl) continue;
            this.removeElement(list2);
        }
    }

    protected ViewletType elementToViewletType(List list) {
        return (ViewletType)this.elementToViewletType.get(list.toString());
    }

    void customizeViewlets() {
        for (List list : this.viewletDataStore.getEntireViewletRange()) {
            Element element = this.getElement(list);
            if (element == null) continue;
            ViewletData viewletData = this.viewletDataStore.getViewletDataAt(list);
            element.object = viewletData;
            this.elementToViewletType(list).customizeElement(this.viewletDataStore, list, element);
        }
    }

    void removeElement(List list) {
        Element element = this.getElement(list);
        if (element != null) {
            if (element.isNode()) {
                this.graph.removeNode(list.toString());
            } else if (element.isEdge()) {
                this.graph.removeEdge(list.toString());
            }
            this.elementToViewletType.remove(list.toString());
        }
    }

    Node insertNode(ViewletDataStore viewletDataStore, List list, ViewletData viewletData, ViewletType viewletType) {
        this.removeElement(list);
        Node node = new Node((Subgraph)this.graph, list.toString());
        node.object = viewletData;
        viewletType.customizeElement(viewletDataStore, list, (Element)node);
        this.elementToViewletType.put(list.toString(), viewletType);
        return node;
    }

    Edge insertEdge(ViewletDataStore viewletDataStore, List list, Node node, Node node2, ViewletData viewletData, ViewletType viewletType) {
        this.removeElement(list);
        Edge edge = new Edge((Subgraph)this.graph, node, node2, list.toString());
        edge.object = viewletData;
        viewletType.customizeElement(viewletDataStore, list, (Element)edge);
        this.elementToViewletType.put(list.toString(), viewletType);
        return edge;
    }

    void setAttributes(Element element, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, string.length() - 1), "= ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            element.setAttribute(string2, (Object)string3);
        }
    }

    protected void initialiseNetwork() {
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        int n = (Integer)this.viewletDataStore.getSize().get(0);
        int n2 = (Integer)this.viewletDataStore.getSize().get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(new Integer(1));
        arrayList.add(new Integer(1));
        for (int i = 1; i < n + 1; ++i) {
            Node node;
            Integer n3 = new Integer(i);
            arrayList.set(0, n3);
            arrayList.set(1, new Integer(1));
            ViewletData viewletData = this.viewletDataStore.getViewletDataAt(arrayList);
            String string = viewletData.toString();
            arrayList.set(1, new Integer(2));
            viewletData = this.viewletDataStore.getViewletDataAt(arrayList);
            String string2 = viewletData.toString();
            arrayList.set(1, new Integer(3));
            viewletData = this.viewletDataStore.getViewletDataAt(arrayList);
            String string3 = viewletData.toString();
            String string4 = null;
            if (n2 > 3) {
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                arrayList2.set(1, new Integer(4));
                string4 = this.viewletDataStore.getViewletDataAt(arrayList2).toString();
            }
            boolean bl = true;
            try {
                bl = Integer.parseInt(string) < 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (bl) {
                if ("-1".equals(string)) {
                    node = this.insertNode(this.viewletDataStore, arrayList, viewletData, this.viewletType);
                } else {
                    node = this.insertNode(this.viewletDataStore, arrayList, viewletData, this.viewletType);
                    node.setAttribute("shape", (Object)string);
                }
                if (string4 != null) {
                    this.setAttributes((Element)node, string4);
                }
                hashMap.put(string2, node);
                continue;
            }
            node = this.insertEdge(this.viewletDataStore, arrayList, (Node)hashMap.get(string), (Node)hashMap.get(string2), viewletData, this.viewletType);
        }
    }

    protected void initialiseGraph() {
        this.graph = new SteadyGraph(this.getViewable().getNameString(), true, false, 100.0);
        if (this.type == 1) {
            this.initialiseNetwork();
        }
    }

    void externalLayoutGraph(String string) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (Exception exception) {
            try {
                String string2 = this.getStateModel().getEclipseLibDir() + File.separator + string;
                process = Runtime.getRuntime().exec(string2);
            }
            catch (Exception exception2) {
                JOptionPane.showMessageDialog(null, new String[]{"Problem calling external layout program: " + exception2.getMessage(), "\nEnsure that the GraphViz tools are installed correctly and are\navailable on your default path.  These tools can be downloaded\nfrom http://www.research.att.com/sw/tools/graphviz/"});
                return;
            }
        }
        if (!GrappaSupport.filterGraph((Graph)this.graph, (Object)process)) {
            JOptionPane.showMessageDialog(null, new String[]{"Problem during execution of external layout program.", "\nEnsure that the GraphViz tools are installed correctly and are\navailable on your default path.  These tools can be downloaded\nfrom http://www.research.att.com/sw/tools/graphviz/"});
            return;
        }
        if (process instanceof Process) {
            try {
                int n = process.waitFor();
                if (n != 0) {
                    JOptionPane.showMessageDialog(null, new String[]{"External layout program exited with code " + n, "\nEnsure that the GraphViz tools are installed correctly and are\navailable on your default path.  These tools can be downloaded\nfrom http://www.research.att.com/sw/tools/graphviz/"});
                }
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(null, new String[]{"Problem whilst exiting external layout program.", "\nEnsure that the GraphViz tools are installed correctly and are\navailable on your default path.  These tools can be downloaded\nfrom http://www.research.att.com/sw/tools/graphviz/"});
                interruptedException.printStackTrace(System.err);
            }
        }
        process = null;
        this.graph.oldBounds = null;
        this.customizeViewlets();
        this.graph.repaint();
    }

    void layoutGraphAsMatrix() {
    }

    protected void initialiseComponent() {
        this.trackUpdatesMenuItem.setEnabled(false);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setBackingStoreEnabled(true);
        this.backer = new GraphViewBacker();
        this.graphPanel = new GrappaPanel((Subgraph)this.graph, (GrappaBacker)this.backer);
        Grappa.useAntiAliasing = false;
        Grappa.nodeLabelsScaleCutoff = 0.1;
        Grappa.edgeLabelsScaleCutoff = 0.1;
        Grappa.subgLabelsScaleCutoff = 0.1;
        this.graphPanel.addGrappaListener((GrappaListener)new GraphViewListener(this));
        this.graphPanel.setScaleToFit(false);
        Rectangle rectangle = this.graph.getBoundingBox().getBounds();
        MouseViewletMenuUpPopper mouseViewletMenuUpPopper = new MouseViewletMenuUpPopper(this, (Component)this.graphPanel);
        this.scrollPane.setViewportView((Component)this.graphPanel);
        this.scrollPane.setPreferredSize(new Dimension(430, 200));
    }

    public String getToolTip(List list) {
        return this.viewletDataStore.getViewletDataAt(list).toString();
    }

    @Override
    public Component getComponent() {
        return this.scrollPane;
    }

    public void setTrackExpansions(boolean bl) {
    }

    public void setTrackExpansionsPrivate(boolean bl) {
    }

    public boolean getTrackExpansions() {
        return false;
    }

    @Override
    public void zoomToLevel(float f) {
        this.graphPanel.setScaleToFit(false);
        this.graphPanel.setScaleToSize(null);
        this.graphPanel.resetZoom();
        this.graphPanel.multiplyScaleFactor((double)f);
    }

    @Override
    public void zoomInByRatio(float f) {
        this.graphPanel.setScaleToFit(false);
        this.graphPanel.setScaleToSize(null);
        this.graphPanel.multiplyScaleFactor((double)f);
    }

    protected void scrollToTrackExpansion(ExpandEvent expandEvent) {
    }

    @Override
    public void zoomToFitWidth() {
        double d;
        double d2 = this.graph.getBoundingBox().getWidth();
        GrappaSize grappaSize = (GrappaSize)this.graph.getAttributeValue("margin");
        if (grappaSize != null) {
            d = 72.0 * grappaSize.width;
            d2 += 2.0 * d;
        }
        d = this.scrollPane.getViewport().getExtentSize().getWidth();
        this.zoomToLevel((float)(d / d2));
    }

    @Override
    public void zoomToFitHeight() {
        double d;
        double d2 = this.graph.getBoundingBox().getHeight();
        GrappaSize grappaSize = (GrappaSize)this.graph.getAttributeValue("margin");
        if (grappaSize != null) {
            d = 72.0 * grappaSize.height;
            d2 += 2.0 * d;
        }
        d = this.scrollPane.getViewport().getExtentSize().getHeight();
        this.zoomToLevel((float)(d / d2));
    }

    protected void clearSelectionPrivate() {
        if (this.graph.currentSelection != null) {
            if (this.graph.currentSelection instanceof Element) {
                ((Element)this.graph.currentSelection).highlight &= 0xFFFFFFFC;
            } else {
                Vector vector = (Vector)this.graph.currentSelection;
                for (int i = 0; i < vector.size(); ++i) {
                    ((Element)vector.elementAt((int)i)).highlight &= 0xFFFFFFFC;
                }
            }
            this.graph.currentSelection = null;
            this.graph.repaint();
        }
    }

    @Override
    protected void setSelectionPrivate(ViewletRange viewletRange) {
        DebuggingSupport.logMessage(this, "setSelectionPrivate called with newSelection=" + String.valueOf(viewletRange));
        this.clearSelectionPrivate();
        if (!viewletRange.isEmpty()) {
            this.graph.currentSelection = new Vector();
            for (List list : viewletRange) {
                Element element = this.getElement(list);
                if (element == null) continue;
                element.highlight |= 1;
                ((Vector)this.graph.currentSelection).add(element);
            }
        }
    }

    protected Element getElement(List list) {
        Node node = this.graph.findNodeByName(list.toString());
        if (node == null) {
            node = this.graph.findEdgeByName(list.toString());
        }
        return node;
    }

    @Override
    public ViewletRange getSelection() {
        ViewletRangeCollection viewletRangeCollection = new ViewletRangeCollection();
        for (List list : this.viewletDataStore.getEntireViewletRange()) {
            Element element = this.getElement(list);
            if (element == null || (element.highlight & 1) != 1) continue;
            viewletRangeCollection.add(list);
        }
        return viewletRangeCollection;
    }

    public Collection getCompoundActions(ViewletRange viewletRange) {
        return this.viewletType.getActions(this.viewletDataStore, viewletRange);
    }

    @Override
    protected ViewletRange getAllViewletData() {
        return this.viewletDataStore.getEntireViewletRange();
    }

    @Override
    public Collection getViewerPopupMenuCollection() {
        Collection collection = super.getViewerPopupMenuCollection();
        collection.add(this.getPopupMenu("Graph"));
        collection.add(this.getPopupMenu("Insert"));
        collection.add(new PrintAction(this));
        return collection;
    }

    void insertNewViewletAt(ViewletType viewletType, List list, int n, int n2) {
        ViewletRangeCollection viewletRangeCollection;
        ViewletData viewletData = ((ViewletFactory)((Object)viewletType)).build();
        MultiViewletType.Data data = (MultiViewletType.Data)((ViewletFactory)((Object)this.viewletType)).build();
        data.setViewletType(viewletType);
        data.setViewletData(viewletData);
        try {
            List list2;
            this.viewletDataStore.setViewletDataAt(list, data);
            viewletRangeCollection = new ViewletRangeCollection();
            viewletRangeCollection.add(list);
            BatchGoal batchGoal = this.viewletType.collectPreBuildGoal(this, this.viewletDataStore, viewletRangeCollection);
            try {
                list2 = this.getStateModel().executeMultitaskBatchGoal(batchGoal);
            }
            catch (EclipseException eclipseException) {
                throw new RuntimeException("EclipseException " + String.valueOf((Object)eclipseException) + " thrown while running viewlet's pre-build goal");
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException " + String.valueOf(iOException) + " thrown while running viewlet's pre-build goal");
            }
            this.viewletType.startBuild(this, this.viewletDataStore, viewletRangeCollection, list2);
        }
        catch (RuntimeException runtimeException) {
            this.viewletDataStore.setViewletDataAt(list, null);
            throw runtimeException;
        }
        viewletRangeCollection = this.insertNode(this.viewletDataStore, list, data, this.viewletType);
        this.moveNodeToVirtualTable((Node)viewletRangeCollection, n, n2);
    }

    protected void moveNodeToVirtualTable(Node node, int n, int n2) {
        Rectangle2D rectangle2D = node.getGrappaNexus().getBounds2D();
        double d = rectangle2D.getWidth() * (double)n;
        double d2 = rectangle2D.getHeight() * (double)n2;
        node.setAttribute("pos", (Object)(d + "," + d2));
    }

    void insertNewViewlet(ViewletType viewletType, int[][] nArray) {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        int[] nArray2 = new int[nArray.length];
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        block6: for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n2] = nArray[n2].length - 1;
            if (nArray[n2].length <= 1) continue;
            switch (++n5) {
                case 1: {
                    n3 = n2;
                    continue block6;
                }
                case 2: {
                    n4 = n2;
                    continue block6;
                }
            }
        }
        n2 = nArray.length;
        int n6 = 0;
        Vector vector = new Vector();
        do {
            int n7;
            if (n2 > nArray.length - 1) {
                n7 = 0;
                int n8 = 0;
                arrayList.clear();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(new Integer(nArray[i][nArray2[i]]));
                    if (i == n3) {
                        n8 = nArray2[i];
                    }
                    if (i != n4) continue;
                    n7 = nArray2[i];
                }
                try {
                    this.insertNewViewletAt(viewletType, new ArrayList(arrayList), n8, n7);
                }
                catch (RuntimeException runtimeException) {
                    vector.add(new ArrayList(arrayList));
                }
                ++n6;
                --n2;
            }
            n = 0;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                n += nArray2[n7];
            }
            if (n == 0) break;
            int n9 = n2;
            nArray2[n9] = nArray2[n9] - 1;
            if (nArray2[n2] < 0) {
                nArray2[n2] = nArray[n2].length;
                --n2;
                continue;
            }
            ++n2;
        } while (n > 0);
        if (!vector.isEmpty()) {
            JList jList = new JList(vector);
            JOptionPane.showMessageDialog(null, new Object[]{"Viewlets could not be created for the following indices: ", new JScrollPane(jList)});
        }
    }

    protected void addImage(String string) {
        Node node = new Node((Subgraph)this.graph, "image-" + this.imageCounter++);
        node.setAttribute("shape", (Object)"box");
        node.setAttribute("label", (Object)"");
        node.setAttribute("image", (Object)string);
        this.graph.resetBoundingBox();
        this.graph.repaint();
    }

    void setBackground(File file) {
        this.backer.setFile(file);
        this.graph.repaint();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Component component;
        int n2 = this.graphPanel.print(graphics, pageFormat, n);
        JViewport jViewport = this.scrollPane.getColumnHeader();
        if (jViewport != null && (component = jViewport.getView()) != null && component instanceof Printable) {
            ((Printable)((Object)component)).print(graphics, pageFormat, n);
        }
        return n2;
    }

    void moveNode(Node node, double d, double d2) {
        Object object;
        StringTokenizer stringTokenizer;
        String string;
        GrappaLine grappaLine;
        Edge edge;
        GrappaPoint grappaPoint = (GrappaPoint)node.getAttributeValue("pos");
        GrappaPoint grappaPoint2 = new GrappaPoint(grappaPoint.x + d, grappaPoint.y + d2);
        node.setAttribute("pos", (Object)grappaPoint2);
        Node.Iterator iterator = node.inEdgeElements();
        while (iterator.hasNext()) {
            double d3;
            double d4;
            edge = (Edge)iterator.next();
            grappaLine = (GrappaLine)edge.getAttributeValue("pos");
            string = grappaLine.toAttributeString();
            stringTokenizer = new StringTokenizer(string, ", ");
            object = string.substring(string.indexOf(32));
            String string2 = stringTokenizer.nextToken();
            Object object2 = string;
            if ("e".equals(string2)) {
                d4 = Double.parseDouble(stringTokenizer.nextToken()) + d;
                d3 = Double.parseDouble(stringTokenizer.nextToken()) - d2;
                object2 = "e," + d4 + "," + d3 + (String)object;
            } else if ("s".equals(string2)) {
                d4 = Double.parseDouble(stringTokenizer.nextToken()) + d;
                d3 = Double.parseDouble(stringTokenizer.nextToken()) - d2;
                object2 = "s," + d4 + "," + d3 + (String)object;
            }
            edge.setAttribute("pos", object2);
        }
        iterator = node.outEdgeElements();
        while (iterator.hasNext()) {
            double d5;
            double d6;
            edge = (Edge)iterator.next();
            grappaLine = (GrappaLine)edge.getAttributeValue("pos");
            string = grappaLine.toAttributeString();
            stringTokenizer = new StringTokenizer(string, ", ");
            object = string;
            if (string == null || string.length() == 0) break;
            if (string.charAt(0) == 's') {
                int n = string.lastIndexOf(32);
                String string3 = string.substring(0, n);
                int n2 = string.lastIndexOf(44);
                d6 = Double.parseDouble(string.substring(n, n2)) + d;
                d5 = Double.parseDouble(string.substring(n2 + 1)) - d2;
                object = string3 + " " + d6 + "," + d5;
            } else if (string.charAt(0) == 'e') {
                String string4 = string.substring(0, string.indexOf(32));
                int n = string.indexOf(32, string4.length() + 1);
                String string5 = "";
                if (n >= 0) {
                    string5 = string.substring(n);
                }
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                d6 = Double.parseDouble(stringTokenizer.nextToken()) + d;
                d5 = Double.parseDouble(stringTokenizer.nextToken()) - d2;
                object = string4 + " " + d6 + "," + d5 + string5;
            }
            edge.setAttribute("pos", object);
        }
        this.graph.resetBoundingBox();
        this.graph.repaint();
    }

    List stringToIndexList(String string) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, string.length() - 1), ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            linkedList.add(Integer.valueOf(string2));
        }
        return linkedList;
    }

    protected static class GraphViewListener
    implements GrappaListener,
    GrappaConstants {
        protected GraphViewer viewer;
        protected GrappaPoint previousDragPoint;

        public GraphViewListener(GraphViewer graphViewer) {
            this.viewer = graphViewer;
            this.previousDragPoint = null;
        }

        public void grappaClicked(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, int n2, GrappaPanel grappaPanel) {
            if ((n & 0x10) == 16 && n2 == 1 && subgraph.getGraph().isSelectable()) {
                if (n == 16) {
                    if (element == null) {
                        if (subgraph.currentSelection != null) {
                            if (subgraph.currentSelection instanceof Element) {
                                ((Element)subgraph.currentSelection).highlight &= 0xFFFFFFFC;
                            } else {
                                Vector vector = (Vector)subgraph.currentSelection;
                                for (int i = 0; i < vector.size(); ++i) {
                                    ((Element)vector.elementAt((int)i)).highlight &= 0xFFFFFFFC;
                                }
                            }
                            subgraph.currentSelection = null;
                            subgraph.getGraph().repaint();
                        }
                    } else {
                        if (subgraph.currentSelection != null) {
                            if (subgraph.currentSelection == element) {
                                return;
                            }
                            if (subgraph.currentSelection instanceof Element) {
                                ((Element)subgraph.currentSelection).highlight &= 0xFFFFFFFC;
                            } else {
                                Vector vector = (Vector)subgraph.currentSelection;
                                for (int i = 0; i < vector.size(); ++i) {
                                    ((Element)vector.elementAt((int)i)).highlight &= 0xFFFFFFFC;
                                }
                            }
                            subgraph.currentSelection = null;
                        }
                        if (element != subgraph) {
                            element.highlight |= 1;
                            subgraph.currentSelection = element;
                        }
                        subgraph.getGraph().repaint();
                    }
                } else if (n == 18 && element != null) {
                    if ((element.highlight & 1) == 1) {
                        element.highlight &= 0xFFFFFFFE;
                        if (subgraph.currentSelection == null) {
                            throw new InternalError("currentSelection improperly maintained");
                        }
                        if (subgraph.currentSelection instanceof Element) {
                            if ((Element)subgraph.currentSelection != element) {
                                throw new InternalError("currentSelection improperly maintained");
                            }
                            subgraph.currentSelection = null;
                        } else {
                            Vector vector = (Vector)subgraph.currentSelection;
                            boolean bl = true;
                            for (int i = 0; i < vector.size(); ++i) {
                                if ((Element)vector.elementAt(i) != element) continue;
                                vector.removeElementAt(i);
                                bl = false;
                                break;
                            }
                            if (bl) {
                                throw new InternalError("currentSelection improperly maintained");
                            }
                        }
                    } else {
                        element.highlight |= 1;
                        if (subgraph.currentSelection == null) {
                            subgraph.currentSelection = element;
                        } else if (subgraph.currentSelection instanceof Element) {
                            Object object = subgraph.currentSelection;
                            subgraph.currentSelection = new Vector();
                            ((Vector)subgraph.currentSelection).add(object);
                            ((Vector)subgraph.currentSelection).add(element);
                        } else {
                            ((Vector)subgraph.currentSelection).add(element);
                        }
                    }
                    subgraph.getGraph().repaint();
                }
            }
        }

        public void grappaPressed(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, GrappaPanel grappaPanel) {
            if (n == 16 && subgraph.getGraph().isSelectable()) {
                this.previousDragPoint = null;
            }
        }

        public void grappaReleased(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, Element element2, GrappaPoint grappaPoint2, int n2, GrappaBox grappaBox, GrappaPanel grappaPanel) {
            if (n == 16 && subgraph.getGraph().isSelectable()) {
                if (grappaBox != null) {
                    List list;
                    boolean bl = false;
                    if (subgraph.currentSelection != null) {
                        if (subgraph.currentSelection instanceof Element) {
                            ((Element)subgraph.currentSelection).highlight = 0;
                        } else {
                            list = (Vector)subgraph.currentSelection;
                            for (int i = 0; i < ((Vector)list).size(); ++i) {
                                ((Element)((Vector)list).elementAt((int)i)).highlight = 0;
                            }
                        }
                        subgraph.currentSelection = null;
                    }
                    if ((list = GrappaSupport.findContainedElements((Subgraph)subgraph, (GrappaBox)grappaBox)) != null) {
                        this.drillDown(subgraph, list, 1, 4);
                        bl = false;
                    }
                    if (!bl) {
                        subgraph.getGraph().paintImmediately();
                    }
                    if (bl) {
                        Graphics2D graphics2D = (Graphics2D)grappaPanel.getGraphics();
                        AffineTransform affineTransform = graphics2D.getTransform();
                        graphics2D.setTransform(grappaPanel.getTransform());
                        graphics2D.setXORMode(Color.darkGray);
                        graphics2D.draw((Shape)grappaBox);
                        graphics2D.setPaintMode();
                        graphics2D.setTransform(affineTransform);
                    }
                }
            } else if (n == 18 && subgraph.getGraph().isSelectable()) {
                if (grappaBox != null) {
                    List list = GrappaSupport.findContainedElements((Subgraph)subgraph, (GrappaBox)grappaBox);
                    if (list != null) {
                        this.drillDown(subgraph, list, 1, 16);
                        subgraph.getGraph().repaint();
                    } else {
                        Graphics2D graphics2D = (Graphics2D)grappaPanel.getGraphics();
                        AffineTransform affineTransform = graphics2D.getTransform();
                        graphics2D.setTransform(grappaPanel.getTransform());
                        graphics2D.setXORMode(Color.darkGray);
                        graphics2D.draw((Shape)grappaBox);
                        graphics2D.setPaintMode();
                        graphics2D.setTransform(affineTransform);
                    }
                }
            } else if (n == 17 && subgraph.getGraph().isEditable() && element != null && element2 != null && n2 == n && grappaBox == null) {
                if (element2 == element && grappaPoint.distance((Point2D)grappaPoint2) < 5.0) {
                    Attribute[] attributeArray = null;
                    Attribute attribute = subgraph.getNodeAttribute("label");
                    attributeArray = attribute == null || attribute.getValue().equals("\\N") ? new Attribute[]{new Attribute(1, "pos", (Object)grappaPoint), new Attribute(1, "label", (Object)("Node" + subgraph.getGraph().getId(1)))} : new Attribute[]{new Attribute(1, "pos", (Object)grappaPoint)};
                    Element element3 = subgraph.createElement(1, null, attributeArray);
                    if (element3 != null) {
                        element3.buildShape();
                        subgraph.getGraph().repaint();
                    }
                    subgraph.getGraph().repaint();
                } else if (element2 != element && element2.isNode() && element.isNode()) {
                    Object[] objectArray = new Object[]{element, null, element2};
                    Attribute[] attributeArray = new Attribute[]{new Attribute(2, "pos", (Object)new GrappaLine(new GrappaPoint[]{((Node)element2).getCenterPoint(), ((Node)element).getCenterPoint()}, subgraph.getGraph().isDirected() ? 2 : 0))};
                    Element element4 = subgraph.createElement(2, objectArray, attributeArray);
                    if (element4 != null) {
                        element4.buildShape();
                        subgraph.getGraph().repaint();
                    }
                }
            }
        }

        public void grappaDragged(Subgraph subgraph, GrappaPoint grappaPoint, int n, Element element, GrappaPoint grappaPoint2, int n2, GrappaBox grappaBox, GrappaPanel grappaPanel) {
            if ((n & 0x10) == 16) {
                if (element != null && element != subgraph && (n & 2) == 0 && this.viewer.moveable) {
                    double d = 0.0;
                    double d2 = 0.0;
                    if (this.previousDragPoint != null) {
                        d = grappaPoint.x - this.previousDragPoint.x;
                        d2 = grappaPoint.y - this.previousDragPoint.y;
                    }
                    this.previousDragPoint = grappaPoint;
                    if (subgraph.currentSelection != null && !(subgraph.currentSelection instanceof Subgraph)) {
                        if (subgraph.currentSelection instanceof Element) {
                            Element element2 = (Element)subgraph.currentSelection;
                            if (element2 instanceof Node) {
                                new MoveNodeCommand(this.viewer, (Node)element2, d, d2).issue();
                            }
                        } else {
                            Vector vector = (Vector)subgraph.currentSelection;
                            for (int i = 0; i < vector.size(); ++i) {
                                Element element3 = (Element)vector.elementAt(i);
                                if (!(element3 instanceof Node)) continue;
                                new MoveNodeCommand(this.viewer, (Node)element3, d, d2).issue();
                            }
                        }
                    }
                } else if (n == 16 || n == 18) {
                    Graphics2D graphics2D = (Graphics2D)grappaPanel.getGraphics();
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.setTransform(grappaPanel.getTransform());
                    graphics2D.setXORMode(Color.darkGray);
                    if (grappaBox != null) {
                        graphics2D.draw((Shape)grappaBox);
                    }
                    GrappaBox grappaBox2 = GrappaSupport.boxFromCorners((double)grappaPoint2.x, (double)grappaPoint2.y, (double)grappaPoint.x, (double)grappaPoint.y);
                    graphics2D.draw((Shape)grappaBox2);
                    graphics2D.setPaintMode();
                    graphics2D.setTransform(affineTransform);
                }
            }
        }

        public String grappaTip(Subgraph subgraph, Element element, GrappaPoint grappaPoint, int n, GrappaPanel grappaPanel) {
            if (element == null) {
                return "";
            }
            String string = element.getName();
            List list = null;
            try {
                list = this.viewer.stringToIndexList(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            String string2 = this.viewer.getToolTip(list);
            if (string2 == null) {
                return "";
            }
            return string2.toString();
        }

        protected void drillDown(Subgraph subgraph, List list, int n, int n2) {
            for (Object e : list) {
                if (e instanceof Vector) {
                    this.drillDown(subgraph, (Vector)e, n, n2);
                    continue;
                }
                GrappaSupport.setHighlight((Element)((Element)e), (int)n, (int)n2);
                switch (n2) {
                    case 16: {
                        Object object;
                        if ((((Element)e).highlight & n) == n) {
                            if (subgraph.currentSelection == null) {
                                subgraph.currentSelection = e;
                                break;
                            }
                            if (subgraph.currentSelection instanceof Element) {
                                object = subgraph.currentSelection;
                                subgraph.currentSelection = new Vector();
                                ((Vector)subgraph.currentSelection).add(object);
                                ((Vector)subgraph.currentSelection).add(e);
                                break;
                            }
                            ((Vector)subgraph.currentSelection).add(e);
                            break;
                        }
                        if (subgraph.currentSelection == e) {
                            subgraph.currentSelection = null;
                            break;
                        }
                        if (!(subgraph.currentSelection instanceof Vector)) break;
                        ((Vector)subgraph.currentSelection).remove(e);
                        break;
                    }
                    case 4: {
                        Object object;
                        if (subgraph.currentSelection == null) {
                            subgraph.currentSelection = e;
                            break;
                        }
                        if (subgraph.currentSelection instanceof Element) {
                            object = subgraph.currentSelection;
                            subgraph.currentSelection = new Vector();
                            ((Vector)subgraph.currentSelection).add(object);
                            ((Vector)subgraph.currentSelection).add(e);
                            break;
                        }
                        ((Vector)subgraph.currentSelection).add(e);
                        break;
                    }
                    case 8: {
                        if (subgraph.currentSelection == null) break;
                        if (subgraph.currentSelection == e) {
                            subgraph.currentSelection = null;
                            break;
                        }
                        if (!(subgraph.currentSelection instanceof Vector)) break;
                        ((Vector)subgraph.currentSelection).remove(e);
                    }
                }
            }
        }
    }

    protected class PrintAction
    extends AbstractAction {
        private GraphViewer viewer;

        PrintAction(GraphViewer graphViewer2) {
            super("Print");
            this.viewer = graphViewer2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PageFormat pageFormat = new PageFormat();
            Rectangle2D rectangle2D = this.viewer.graph.getBoundingBox();
            if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                pageFormat.setOrientation(0);
            }
            try {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(this.viewer, pageFormat);
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            }
            catch (Exception exception) {
                Grappa.displayException((Exception)exception, (String)"Problem with print request");
            }
        }
    }

    protected class GraphViewBacker
    implements GrappaBacker,
    GrappaConstants {
        Image image = null;

        public void setFile(File file) {
            if (file == null) {
                this.image = null;
                return;
            }
            Image image = Toolkit.getDefaultToolkit().getImage(file.toString());
            MediaTracker mediaTracker = new MediaTracker((Component)GraphViewer.this.graphPanel);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(null, "Problem loading background image:" + String.valueOf(interruptedException));
                return;
            }
            if (mediaTracker.isErrorID(0)) {
                JOptionPane.showMessageDialog(null, "Unknown error occurred loading background image.");
                return;
            }
            this.image = image;
        }

        public void drawBackground(Graphics2D graphics2D, Graph graph, Rectangle2D rectangle2D, Shape shape) {
            if (this.image != null) {
                Shape shape2 = graphics2D.getClip();
                graphics2D.setClip(shape);
                graphics2D.drawImage(this.image, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), null);
                graphics2D.setClip(shape2);
            }
        }
    }

    public static class SetBackgroundCommand
    extends ViewerCommand {
        File file;

        public SetBackgroundCommand(GraphViewer graphViewer, File file) {
            super(graphViewer);
            this.file = file;
        }

        @Override
        public void postRecordIssue() {
            ((GraphViewer)this.getViewer()).setBackground(this.file);
        }
    }

    protected class SetBackgroundAction
    extends AbstractAction {
        protected GraphViewer viewer;
        protected File defaultImageDirectory;
        protected boolean load;

        public SetBackgroundAction(GraphViewer graphViewer2, boolean bl) {
            super(bl ? "Import background image" : "Clear background");
            this.viewer = graphViewer2;
            this.load = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (!this.load) {
                new SetBackgroundCommand(this.viewer, null).issue();
                return;
            }
            ImageFileChooser imageFileChooser = new ImageFileChooser();
            if (this.defaultImageDirectory != null) {
                imageFileChooser.setCurrentDirectory(this.defaultImageDirectory);
            }
            if ((n = imageFileChooser.showOpenDialog(GraphViewer.this.getComponent())) == 0) {
                if (imageFileChooser.getSelectedFile().exists()) {
                    new SetBackgroundCommand(this.viewer, imageFileChooser.getSelectedFile()).issue();
                } else {
                    JOptionPane.showMessageDialog(GraphViewer.this.getComponent(), "File \n" + imageFileChooser.getSelectedFile().toString() + "\ndoes not exist", "Error in Visualisation Client", 0);
                }
            }
            this.defaultImageDirectory = imageFileChooser.getCurrentDirectory();
        }
    }

    protected static class SteadyGraph
    extends Graph {
        double softMargin;
        Rectangle2D oldBounds;

        public SteadyGraph(String string, boolean bl, boolean bl2, double d) {
            super(string, bl, bl2);
            this.softMargin = d;
        }

        public Rectangle2D resetBoundingBox() {
            this.oldBounds = null;
            return super.resetBoundingBox();
        }

        public void repaint() {
            super.repaint();
        }

        public Rectangle2D getBoundingBox() {
            Rectangle2D rectangle2D = super.getBoundingBox();
            if (this.oldBounds == null) {
                this.oldBounds = rectangle2D;
            } else {
                double d = Math.abs(rectangle2D.getWidth() - this.oldBounds.getWidth());
                double d2 = Math.abs(rectangle2D.getHeight() - this.oldBounds.getHeight());
                if (d > this.softMargin || d2 > this.softMargin) {
                    this.oldBounds = rectangle2D;
                }
            }
            return this.oldBounds;
        }
    }

    protected class StoreListener
    implements ViewletDataStoreListener {
        @Override
        public void rangeUpdated(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            for (List list : viewletRange) {
                Element element = GraphViewer.this.getElement(list);
                ViewletType viewletType = GraphViewer.this.elementToViewletType(list);
                viewletType.customizeElement(viewletDataStore, list, element);
            }
            GraphViewer.this.graph.repaint();
        }
    }

    protected class ImageFileChooser
    extends JFileChooser
    implements PropertyChangeListener {
        ImageFileChooser() {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.setFileSelectionMode(0);
            this.setFileFilter(new ImageFileFilter());
            this.addPropertyChangeListener("directoryChanged", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setSelectedFile(null);
        }
    }

    protected class ImageFileFilter
    extends FileFilter {
        protected ImageFileFilter() {
        }

        @Override
        public String getDescription() {
            return "image file";
        }

        @Override
        public boolean accept(File file) {
            return file.toString().endsWith(".gif") || file.toString().endsWith(".GIF") || file.toString().endsWith(".png") || file.toString().endsWith(".PNG") || file.toString().endsWith(".jpg") || file.toString().endsWith(".JPG") || file.toString().endsWith(".jpeg") || file.toString().endsWith(".JPEG") || file.isDirectory();
        }
    }

    protected class AddImageAction
    extends AbstractAction {
        protected GraphViewer viewer;
        protected File defaultImageDirectory;

        public AddImageAction(GraphViewer graphViewer2) {
            super("Image");
            this.viewer = graphViewer2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            ImageFileChooser imageFileChooser = new ImageFileChooser();
            if (this.defaultImageDirectory != null) {
                imageFileChooser.setCurrentDirectory(this.defaultImageDirectory);
            }
            if ((n = imageFileChooser.showOpenDialog(GraphViewer.this.getComponent())) == 0) {
                if (imageFileChooser.getSelectedFile().exists()) {
                    new AddImageCommand(this.viewer, imageFileChooser.getSelectedFile().toString()).issue();
                } else {
                    JOptionPane.showMessageDialog(GraphViewer.this.getComponent(), "File \n" + imageFileChooser.getSelectedFile().toString() + "\ndoes not exist", "Error in Visualisation Client", 0);
                }
            }
            this.defaultImageDirectory = imageFileChooser.getCurrentDirectory();
        }
    }

    protected class AddImageCommand
    extends ViewerCommand {
        String filename;

        public AddImageCommand(GraphViewer graphViewer2, String string) {
            super(graphViewer2);
            this.filename = string;
        }

        @Override
        public void postRecordIssue() {
            ((GraphViewer)this.getViewer()).addImage(this.filename);
        }
    }

    protected class GrappaAntiAliasToggleAction
    extends AbstractAction {
        public GrappaAntiAliasToggleAction() {
            super("Toggle Hi-Quality");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            Grappa.useAntiAliasing = bl = !Grappa.useAntiAliasing;
            GraphViewer.this.graph.repaint();
        }
    }

    public static class InsertViewletCommand
    extends ViewerCommand {
        private SymRef viewletType;
        private int[][] index;

        public InsertViewletCommand(GraphViewer graphViewer, int[][] nArray, ViewletType viewletType) {
            super(graphViewer);
            this.viewletType = viewletType.getSymRef();
            this.index = nArray;
        }

        private ViewletType getViewletType() {
            return (ViewletType)SymRef.get(this.viewletType);
        }

        @Override
        public void postRecordIssue() {
            ((GraphViewer)this.getViewer()).insertNewViewlet(this.getViewletType(), this.index);
        }
    }

    protected class IndexChoosingDialog
    extends JDialog {
        private ViewletType viewletType;
        private GraphViewer viewer;
        private InsertAction insertAction;
        private JList[] locationSelection;

        public IndexChoosingDialog(Object object, List list, ViewletType viewletType, GraphViewer graphViewer2) {
            this.setModal(true);
            this.setTitle("New " + viewletType.getDescription().toLowerCase());
            this.viewletType = viewletType;
            this.viewer = graphViewer2;
            this.insertAction = new InsertAction();
            this.initialiseLocationSelectors(list);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.locationSelectorPanel(), gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            this.getContentPane().add((Component)new JLabel("Select viewable element location"), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            JPanel jPanel = new JPanel();
            jPanel.add(new ActionButton(this.insertAction));
            jPanel.add(new ActionButton(new CancelAction()));
            this.getContentPane().add((Component)jPanel, gridBagConstraints);
            this.pack();
        }

        private void addViewlets() {
            int[][] nArrayArray = new int[this.locationSelection.length][];
            for (int i = 0; i < this.locationSelection.length; ++i) {
                nArrayArray[i] = this.locationSelection[i].getSelectedIndices();
                int n = 0;
                while (n < nArrayArray[i].length) {
                    int[] nArray = nArrayArray[i];
                    int n2 = n++;
                    nArray[n2] = nArray[n2] + 1;
                }
            }
            new InsertViewletCommand(this.viewer, nArrayArray, this.viewletType).issue();
        }

        private void initialiseLocationSelectors(List list) {
            Iterator iterator = list.iterator();
            this.locationSelection = new JList[list.size()];
            int n = 0;
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                this.locationSelection[n] = new JList(new Vector(list2));
                this.locationSelection[n].setSelectionMode(2);
                this.locationSelection[n].setVisibleRowCount(6);
                this.locationSelection[n].addListSelectionListener(this.insertAction);
                if (list2.size() == 1) {
                    this.locationSelection[n].setSelectedIndex(0);
                    this.locationSelection[n].setEnabled(false);
                }
                ++n;
            }
        }

        private JPanel locationSelectorPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridx = 0;
            for (int i = 0; i < this.locationSelection.length; ++i) {
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridy = 0;
                jPanel.add((Component)new JLabel("Dimension " + (i + 1)), gridBagConstraints);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridy = 1;
                jPanel.add((Component)new JScrollPane(this.locationSelection[i]), gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
            return jPanel;
        }

        private class CancelAction
        extends AbstractAction {
            CancelAction() {
                super("Cancel");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndexChoosingDialog.this.dispose();
            }
        }

        private class InsertAction
        extends AbstractAction
        implements ListSelectionListener {
            InsertAction() {
                super("Insert");
                this.setEnabled(false);
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = true;
                for (int i = 0; i < IndexChoosingDialog.this.locationSelection.length; ++i) {
                    if (IndexChoosingDialog.this.locationSelection[i] != null && IndexChoosingDialog.this.locationSelection[i].getMinSelectionIndex() >= 0) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.setEnabled(true);
                }
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndexChoosingDialog.this.addViewlets();
                IndexChoosingDialog.this.dispose();
            }
        }
    }

    protected class AddViewletAction
    extends AbstractAction
    implements PropertyChangeListener {
        ViewletType viewletType;
        GraphViewer viewer;
        boolean destroyed;

        public AddViewletAction(GraphViewer graphViewer2, ViewletType viewletType) {
            super("Insert " + viewletType.getDescription().toLowerCase());
            this.destroyed = false;
            this.viewletType = viewletType;
            this.viewer = graphViewer2;
            this.setEnabled(!GraphViewer.this.getStateModel().getCanPerformRPC());
            GraphViewer.this.getStateModel().getPropertyChangeSupport().addPropertyChangeListener("canPerformRPC", this);
            GraphViewer.this.getPropertyChangeSupport().addPropertyChangeListener("destroyEventIssued", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("destroyEventIssued")) {
                this.destroyed = true;
            }
            if (this.destroyed || !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LinkedList<List> linkedList = new LinkedList<List>();
            for (int i = 1; i <= GraphViewer.this.getSize().size(); ++i) {
                linkedList.add(GraphViewer.this.getLocationNames(i));
            }
            IndexChoosingDialog indexChoosingDialog = new IndexChoosingDialog(GraphViewer.this.getViewable().getNameAtom(), linkedList, this.viewletType, this.viewer);
            indexChoosingDialog.show();
        }
    }

    public static class MoveNodeCommand
    extends ViewerCommand {
        String nodeName;
        double dx;
        double dy;

        public MoveNodeCommand(GraphViewer graphViewer, Node node, double d, double d2) {
            super(graphViewer);
            this.nodeName = node.getName();
            this.dx = d;
            this.dy = d2;
        }

        @Override
        public void postRecordIssue() {
            GraphViewer graphViewer = (GraphViewer)this.getViewer();
            graphViewer.moveNode(graphViewer.graph.findNodeByName(this.nodeName), this.dx, this.dy);
        }
    }

    public static class ExternalLayoutCommand
    extends ViewerCommand {
        String command;

        public ExternalLayoutCommand(GraphViewer graphViewer, String string) {
            super(graphViewer);
            this.command = string;
        }

        @Override
        public void postRecordIssue() {
            ((GraphViewer)this.getViewer()).externalLayoutGraph(this.command);
        }
    }

    protected class LayoutAction
    extends AbstractAction {
        private GraphViewer viewer;
        private String command;

        LayoutAction(GraphViewer graphViewer2, String string, String string2) {
            super("Layout graph:" + string);
            this.viewer = graphViewer2;
            this.command = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            this.command = string = (String)JOptionPane.showInputDialog(null, "The graph layout will be preformed by the following command", "Layout command", -1, null, null, this.command);
            new ExternalLayoutCommand(this.viewer, this.command).issue();
        }
    }

    protected class ZoomToFitHeightAction
    extends AbstractAction {
        private GraphViewer viewer;

        ZoomToFitHeightAction(GraphViewer graphViewer2) {
            super("Zoom to fit height");
            this.viewer = graphViewer2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ZoomableViewerZoomToFitHeightCommand(this.viewer).issue();
        }
    }

    protected class ZoomToFitWidthAction
    extends AbstractAction {
        private GraphViewer viewer;

        ZoomToFitWidthAction(GraphViewer graphViewer2) {
            super("Zoom to fit width");
            this.viewer = graphViewer2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ZoomableViewerZoomToFitWidthCommand(this.viewer).issue();
        }
    }
}

