/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.GraphViewer;
import com.parctechnologies.eclipse.visualisation.MultiViewletType;
import com.parctechnologies.eclipse.visualisation.NumericBounds;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerFactory;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.viewers.AbstractViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.FadeViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.GrappaTextViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.TextViewletType;
import java.util.LinkedList;

public class GraphViewerFactory
implements ViewerFactory {
    private VisClientStateModel stateModel;
    private int type;
    private boolean zeroOne;
    private boolean capacity;
    private Class elementTypeClass;

    public GraphViewerFactory(VisClientStateModel visClientStateModel, int n, boolean bl, boolean bl2, Class clazz) {
        this.stateModel = visClientStateModel;
        this.type = n;
        this.zeroOne = bl;
        this.capacity = bl2;
        this.elementTypeClass = clazz;
    }

    @Override
    public boolean canBuildFrom(ViewableType viewableType) {
        if (this.type == 0) {
            return true;
        }
        ViewableType.ArrayType arrayType = (ViewableType.ArrayType)viewableType;
        return arrayType.getNDimensions() == 2 && this.elementTypeClass.isInstance(arrayType.getElementType());
    }

    @Override
    public Viewer build(Viewable viewable) {
        Object object;
        LinkedList<AbstractViewletType> linkedList = new LinkedList<AbstractViewletType>();
        String string = null;
        ViewableType viewableType = viewable.getType();
        if (viewableType instanceof ViewableType.ArrayType) {
            object = ((ViewableType.ArrayType)viewableType).getElementType();
            string = ((ElementType)object).getChangeableSolver();
        }
        linkedList.add(new GrappaTextViewletType(string, this.zeroOne, this.capacity));
        linkedList.add(new TextViewletType(string));
        linkedList.add(new FadeViewletType(string));
        if (viewableType instanceof ViewableType.ArrayType && ((ViewableType.ArrayType)viewableType).getElementType() instanceof NumericBounds) {
            linkedList.add(new BoundsViewletType(string));
        }
        object = new MultiViewletType(linkedList);
        GraphViewer graphViewer = new GraphViewer((ViewletType)object, this.stateModel, viewable, this.type);
        graphViewer.setDescription("Graph viewer");
        return graphViewer;
    }
}

