/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Node;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.viewers.FadeColorSupport;
import com.parctechnologies.eclipse.visualisation.viewers.TextViewletType;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;

public class GrappaTextViewletType
extends TextViewletType {
    FadeColorSupport edgeFadeColorSupport = new FadeColorSupport(10, new Color(0, 255, 0), new Color(255, 0, 0), new Color(0, 0, 0));
    boolean capacityEdges;
    boolean zeroOneEdges;
    NumberFormat nf;

    public GrappaTextViewletType(String string, boolean bl, boolean bl2) {
        super(string);
        this.capacityEdges = bl2;
        this.zeroOneEdges = bl;
        this.nf = new DecimalFormat("0.000");
    }

    @Override
    public void customizeElement(ViewletDataStore viewletDataStore, List list, Element element) {
        Data data = (Data)viewletDataStore.getViewletDataAt(list);
        if (element instanceof Node) {
            Node node = (Node)element;
            node.setAttribute("shape", (Object)data.getShape());
            element.setAttribute("color", (Object)this.getColor(data, false));
            node.setAttribute("style", (Object)"filled");
            node.setAttribute("label", (Object)data.getText());
        } else if (element instanceof Edge) {
            Edge edge = (Edge)element;
            if (this.zeroOneEdges) {
                if (data.getHoldsOnUpdates()) {
                    edge.setAttribute("style", (Object)"dotted");
                } else {
                    edge.setAttribute("style", (Object)"solid");
                }
                if ("1".equals(data.getText())) {
                    element.setAttribute("color", (Object)this.getEdgeColor(data));
                } else if ("0".equals(data.getText())) {
                    element.setAttribute("color", (Object)Color.white);
                } else {
                    element.setAttribute("color", (Object)Color.gray);
                }
            } else if (this.capacityEdges) {
                double d = 0.0;
                double d2 = 0.2;
                try {
                    d = Double.parseDouble(data.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                edge.setAttribute("label", (Object)this.nf.format(d));
                if (d > 1.0 || d < 0.0) {
                    d2 = 25.0;
                    element.setAttribute("color", (Object)Color.red);
                } else {
                    d2 = d < 0.01 ? 0.2 : 20.0 * d;
                    element.setAttribute("color", (Object)Color.black);
                }
                if (data.getHoldsOnUpdates()) {
                    edge.setAttribute("style", (Object)("dotted,linewidth(" + d2 + ")"));
                } else {
                    edge.setAttribute("style", (Object)("solid,linewidth(" + d2 + ")"));
                }
            } else {
                if (data.getHoldsOnUpdates()) {
                    edge.setAttribute("style", (Object)"dotted");
                } else {
                    edge.setAttribute("style", (Object)"solid");
                }
                element.setAttribute("color", (Object)this.getEdgeColor(data));
                edge.setAttribute("label", (Object)data.getText());
            }
        }
    }

    protected Color getEdgeColor(Data data) {
        int n = data.getFadeCount();
        Color color = n > 0 ? this.edgeFadeColorSupport.forwardColor[n][0] : this.edgeFadeColorSupport.backwardColor[-n][0];
        return color;
    }

    @Override
    public ViewletData build() {
        return new Data();
    }

    @Override
    public String getDescription() {
        return "Shaped text viewlet";
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Collection collection = super.getActions(viewletDataStore, viewletRange);
        if (viewletRange != null & !viewletRange.isEmpty()) {
            // empty if block
        }
        return collection;
    }

    public static class Data
    extends TextViewletType.Data {
        private String shape = "ellipse";

        public String getShape() {
            return this.shape;
        }

        public void setShape(String string) {
            this.shape = string;
        }
    }

    private class ChangeShapeAction
    extends ViewletAction {
        String shape;
        ViewletRange range;
        ViewletDataStore store;

        ChangeShapeAction(ViewletDataStore viewletDataStore, ViewletRange viewletRange, String string) {
            super("Change shape:" + string);
            this.putValue("Name", "Change shape:" + string);
            this.putValue("LongDescription", "Change the shape which surrounds the text to be:" + string);
            this.putValue("ShortDescription", "Change shape to:" + string);
            this.shape = string;
            this.range = viewletRange;
            this.store = viewletDataStore;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (List list : this.range) {
                Data data = (Data)this.store.getViewletDataAt(list);
                data.setShape(this.shape);
                this.store.setViewletDataAt(list, data);
            }
            this.store.fireViewletRangeUpdated(this.range);
        }
    }
}

