/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.AsyncEclipseQueue;
import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseEngine;
import com.parctechnologies.eclipse.EclipseEngineOptions;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseMultitaskConnection;
import com.parctechnologies.eclipse.EclipseTerminatedException;
import com.parctechnologies.eclipse.FromEclipseQueue;
import com.parctechnologies.eclipse.MultitaskListener;
import com.parctechnologies.eclipse.Platform;
import com.parctechnologies.eclipse.QueueListener;
import com.parctechnologies.eclipse.RemoteEclipse;
import com.parctechnologies.eclipse.ToEclipseQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;

public class OutOfProcessEclipse
implements EclipseConnection,
EclipseEngine {
    private Process eclipseProcess;
    private RemoteEclipse eclipseConnection;
    private BufferedReader eclipseProcessStdout;
    private BufferedReader eclipseProcessStderr;
    private BufferedWriter eclipseProcessStdin;
    private boolean useQueues;
    private ToEclipseQueue stdin;
    private FromEclipseQueue stdout;
    private FromEclipseQueue stderr;

    @Override
    public synchronized boolean isUsingQueues() {
        return this.useQueues;
    }

    public OutOfProcessEclipse(EclipseEngineOptions eclipseEngineOptions) throws IOException, EclipseException {
        this.startLocalEclipse(eclipseEngineOptions);
        String string = this.eclipseProcessStdout.readLine();
        String string2 = this.eclipseProcessStdout.readLine();
        int n = Integer.parseInt(string);
        this.remoteConnect(InetAddress.getByName("localhost"), n, string2);
        this.useQueues = eclipseEngineOptions.isUsingQueues();
        this.connectStdStreams();
        if (!eclipseEngineOptions.isUsingQueues()) {
            this.stdStreamsAddListeners();
        }
    }

    private void connectStdStreams() throws EclipseException, IOException {
        this.stdout = this.eclipseConnection.getFromEclipseQueue("joop_stdout");
        this.stderr = this.eclipseConnection.getFromEclipseQueue("joop_stderr");
        this.stdin = this.eclipseConnection.getToEclipseQueue("joop_stdin");
        this.eclipseConnection.rpc("set_stream_property(joop_stdout,flush,end_of_line)");
        this.eclipseConnection.rpc("set_stream_property(joop_stderr,flush,end_of_line)");
        this.eclipseConnection.rpc("set_stream(user_input, joop_stdin)");
        this.eclipseConnection.rpc("set_stream(stdin, joop_stdin)");
        this.eclipseConnection.rpc("set_stream(user_output, joop_stdout)");
        this.eclipseConnection.rpc("set_stream(stdout, joop_stdout)");
        this.eclipseConnection.rpc("set_stream(user_error, joop_stderr)");
        this.eclipseConnection.rpc("set_stream(stderr, joop_stderr)");
        this.eclipseConnection.rpc("set_stream(output, joop_stdout)");
        this.eclipseConnection.rpc("set_stream(warning_output, joop_stdout)");
        this.eclipseConnection.rpc("set_stream(log_output, joop_stdout)");
        this.eclipseConnection.rpc("set_stream(error, joop_stderr)");
        this.eclipseConnection.rpc("set_stream(input, joop_stdin)");
    }

    private void stdStreamsAddListeners() {
        try {
            this.stdin.setListener(new StdInListener());
        }
        catch (IOException iOException) {
            System.err.println("Error: setting of listener threw an IOException.");
        }
        try {
            this.stdout.setListener(new StdOutListener("output"));
        }
        catch (IOException iOException) {
            System.err.println("Error: setting of listener threw an IOException.");
        }
        try {
            this.stderr.setListener(new StdOutListener("error"));
        }
        catch (IOException iOException) {
            System.err.println("Error: setting of listener threw an IOException.");
        }
    }

    private void remoteConnect(InetAddress inetAddress, int n, String string) throws IOException, EclipseException {
        try {
            this.eclipseConnection = new RemoteEclipse(inetAddress, n, string);
            this.eclipseProcessStdin.write("accept. \n");
            this.eclipseProcessStdin.flush();
            this.eclipseConnection.resume();
        }
        catch (IOException iOException) {
            try {
                this.eclipseProcessStdin.write("reject. \n");
                this.eclipseProcessStdin.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private void startLocalEclipse(EclipseEngineOptions eclipseEngineOptions) throws EclipseException, IOException {
        File file;
        if (!Platform.getInstance().supportsOutOfProcessEclipse()) {
            throw new UnsupportedOperationException("The creation of an OutOfProcessEclipse is not supported on platform " + System.getProperty("os.name") + "/" + System.getProperty("os.arch") + ".");
        }
        String[] stringArray = new String[100];
        int n = 0;
        if (eclipseEngineOptions.getEclipseDir() == null) {
            throw new EclipseException("The location of the ECLiPSe installation was not set in the EclipseEngineOptions object supplied.");
        }
        File file2 = new File(eclipseEngineOptions.getEclipseDir());
        File file3 = Platform.getInstance().getExecutableSubdirectory(file2);
        if (!file3.equals(file = Platform.getInstance().getLibrarySubdirectory(file2)) && file3.exists()) {
            stringArray[n++] = new File(file3, "eclipse").toString();
        } else {
            stringArray[n++] = new File(file, "eclipse.exe").toString();
            stringArray[n++] = "-D";
            stringArray[n++] = file2.toString();
        }
        if (eclipseEngineOptions.getLocalSize() != 0) {
            stringArray[n++] = "-l";
            stringArray[n++] = new Integer(eclipseEngineOptions.getLocalSize()).toString() + "M";
        }
        if (eclipseEngineOptions.getGlobalSize() != 0) {
            stringArray[n++] = "-g";
            stringArray[n++] = new Integer(eclipseEngineOptions.getGlobalSize()).toString() + "M";
        }
        stringArray[n++] = "-e";
        stringArray[n++] = eclipseEngineOptions.getDefaultModule() != null ? "set_flag(toplevel_module, " + eclipseEngineOptions.getDefaultModule() + "), joop_boot:jb_go" : "joop_boot:jb_go";
        stringArray[n++] = "-b";
        stringArray[n++] = new File(new File(file2, "lib"), "joop_boot.eco").toString();
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        this.eclipseProcess = Runtime.getRuntime().exec(stringArray2);
        this.eclipseProcessStdout = new BufferedReader(new InputStreamReader(this.eclipseProcess.getInputStream()));
        this.eclipseProcessStderr = new BufferedReader(new InputStreamReader(this.eclipseProcess.getErrorStream()));
        this.eclipseProcessStdin = new BufferedWriter(new OutputStreamWriter(this.eclipseProcess.getOutputStream()));
        this.eclipseProcessStdin.write(eclipseEngineOptions.getPeerName() + ". \n");
        this.eclipseProcessStdin.flush();
    }

    protected void finalize() throws IOException, EclipseException {
        this.destroy();
    }

    @Override
    public synchronized ToEclipseQueue getEclipseStdin() throws EclipseTerminatedException {
        this.eclipseConnection.testTerminated();
        if (this.useQueues) {
            return this.stdin;
        }
        return null;
    }

    @Override
    public synchronized FromEclipseQueue getEclipseStdout() throws EclipseTerminatedException {
        this.eclipseConnection.testTerminated();
        if (this.useQueues) {
            return this.stdout;
        }
        return null;
    }

    @Override
    public synchronized FromEclipseQueue getEclipseStderr() throws EclipseTerminatedException {
        this.eclipseConnection.testTerminated();
        if (this.useQueues) {
            return this.stderr;
        }
        return null;
    }

    public void destroy() throws IOException {
        this.eclipseConnection.testTerminated();
        try {
            this.eclipseConnection.disconnect();
        }
        catch (Exception exception) {
            try {
                this.eclipseConnection.unilateralDisconnect();
            }
            catch (EclipseTerminatedException eclipseTerminatedException) {
                // empty catch block
            }
        }
    }

    @Override
    public CompoundTerm rpc(String string) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(string);
    }

    @Override
    public CompoundTerm rpc(CompoundTerm compoundTerm) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(compoundTerm);
    }

    @Override
    public FromEclipseQueue getFromEclipseQueue(String string) throws EclipseException, IOException {
        return this.eclipseConnection.getFromEclipseQueue(string);
    }

    @Override
    public ToEclipseQueue getToEclipseQueue(String string) throws EclipseException, IOException {
        return this.eclipseConnection.getToEclipseQueue(string);
    }

    @Override
    public AsyncEclipseQueue getAsyncEclipseQueue(String string) throws EclipseException, IOException {
        return this.eclipseConnection.getAsyncEclipseQueue(string);
    }

    @Override
    public void compile(File file) throws EclipseException, IOException {
        this.eclipseConnection.compile(file);
    }

    @Override
    public String getPath(File file) throws EclipseException, IOException {
        return this.eclipseConnection.getPath(file);
    }

    @Override
    public CompoundTerm rpc(String string, Object object) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(string, object);
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(string, object, object2);
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2, Object object3) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(string, object, object2, object3);
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2, Object object3, Object object4) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(string, object, object2, object3, object4);
    }

    @Override
    public CompoundTerm rpc(String string, Object object, Object object2, Object object3, Object object4, Object object5) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(string, object, object2, object3, object4, object5);
    }

    @Override
    public CompoundTerm rpc(String string, Object[] objectArray) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(string, objectArray);
    }

    @Override
    public CompoundTerm rpc(Object[] objectArray) throws EclipseException, IOException {
        return this.eclipseConnection.rpc(objectArray);
    }

    @Override
    public Atom getPeerName() {
        return this.eclipseConnection.getPeerName();
    }

    @Override
    public EclipseMultitaskConnection registerMultitask(MultitaskListener multitaskListener) throws EclipseException, IOException {
        return this.eclipseConnection.registerMultitask(multitaskListener);
    }

    private class StdOutListener
    implements QueueListener {
        private String destination;

        public StdOutListener(String string) {
            this.destination = string;
        }

        @Override
        public void dataAvailable(Object object) {
            byte[] byArray;
            FromEclipseQueue fromEclipseQueue = (FromEclipseQueue)object;
            try {
                int n = fromEclipseQueue.available();
                byArray = new byte[n];
                fromEclipseQueue.read(byArray);
            }
            catch (IOException iOException) {
                System.err.println("Attempt to use ECLiPSe's output queue produced exception:\n" + String.valueOf(iOException));
                System.err.flush();
                return;
            }
            if (this.destination.equals("output")) {
                System.out.print(new String(byArray));
                return;
            }
            if (this.destination.equals("error")) {
                System.err.print(new String(byArray));
                return;
            }
        }

        @Override
        public void dataRequest(Object object) {
        }
    }

    private class StdInListener
    implements QueueListener {
        private static final int READ_CHUNK_SIZE = 512;

        private StdInListener() {
        }

        @Override
        public void dataAvailable(Object object) {
        }

        @Override
        public void dataRequest(Object object) {
            ToEclipseQueue toEclipseQueue = (ToEclipseQueue)object;
            byte[] byArray = new byte[512];
            try {
                int n = System.in.read(byArray);
                if (n != -1) {
                    toEclipseQueue.write(byArray, 0, n);
                    toEclipseQueue.flush();
                }
            }
            catch (IOException iOException) {
                System.err.println("Attempt to read from JVM's stdin produced exception:\n" + String.valueOf(iOException));
                System.err.flush();
            }
        }
    }
}

