/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaListener;
import att.grappa.GrappaPanel;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSupport;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class GrappaAdapter
implements GrappaConstants,
GrappaListener,
ActionListener {
    public void grappaClicked(Subgraph subg, Element elem, GrappaPoint pt, int modifiers, int clickCount, GrappaPanel panel) {
        if ((modifiers & 0x10) == 16 && clickCount == 1 && subg.getGraph().isSelectable()) {
            if (modifiers == 16) {
                if (elem == null) {
                    if (subg.currentSelection != null) {
                        if (subg.currentSelection instanceof Element) {
                            ((Element)subg.currentSelection).highlight &= 0xFFFFFFFC;
                        } else {
                            Vector vec = (Vector)subg.currentSelection;
                            for (int i = 0; i < vec.size(); ++i) {
                                ((Element)vec.elementAt((int)i)).highlight &= 0xFFFFFFFC;
                            }
                        }
                        subg.currentSelection = null;
                        subg.getGraph().repaint();
                    }
                } else {
                    if (subg.currentSelection != null) {
                        if (subg.currentSelection == elem) {
                            return;
                        }
                        if (subg.currentSelection instanceof Element) {
                            ((Element)subg.currentSelection).highlight &= 0xFFFFFFFC;
                        } else {
                            Vector vec = (Vector)subg.currentSelection;
                            for (int i = 0; i < vec.size(); ++i) {
                                ((Element)vec.elementAt((int)i)).highlight &= 0xFFFFFFFC;
                            }
                        }
                        subg.currentSelection = null;
                    }
                    elem.highlight |= 1;
                    subg.currentSelection = elem;
                    subg.getGraph().repaint();
                }
            } else if (modifiers == 18 && elem != null) {
                if ((elem.highlight & 1) == 1) {
                    elem.highlight &= 0xFFFFFFFE;
                    if (subg.currentSelection == null) {
                        throw new InternalError("currentSelection improperly maintained");
                    }
                    if (subg.currentSelection instanceof Element) {
                        if ((Element)subg.currentSelection != elem) {
                            throw new InternalError("currentSelection improperly maintained");
                        }
                        subg.currentSelection = null;
                    } else {
                        Vector vec = (Vector)subg.currentSelection;
                        boolean problem = true;
                        for (int i = 0; i < vec.size(); ++i) {
                            if ((Element)vec.elementAt(i) != elem) continue;
                            vec.removeElementAt(i);
                            problem = false;
                            break;
                        }
                        if (problem) {
                            throw new InternalError("currentSelection improperly maintained");
                        }
                    }
                } else {
                    elem.highlight |= 1;
                    if (subg.currentSelection == null) {
                        subg.currentSelection = elem;
                    } else if (subg.currentSelection instanceof Element) {
                        Object obj = subg.currentSelection;
                        subg.currentSelection = new Vector();
                        ((Vector)subg.currentSelection).add(obj);
                        ((Vector)subg.currentSelection).add(elem);
                    } else {
                        ((Vector)subg.currentSelection).add(elem);
                    }
                }
                subg.getGraph().repaint();
            }
        }
    }

    public void grappaPressed(Subgraph subg, Element elem, GrappaPoint pt, int modifiers, GrappaPanel panel) {
        if ((modifiers & 0xC) != 0 && (modifiers & 0xC) == modifiers) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item = null;
            if (panel.getToolTipText() == null) {
                item = new JMenuItem("ToolTips On");
                popup.add(item);
            } else {
                item = new JMenuItem("ToolTips Off");
                popup.add(item);
            }
            item.addActionListener(this);
            popup.addSeparator();
            item = new JMenuItem("Print");
            popup.add(item);
            item.addActionListener(this);
            popup.addSeparator();
            if (subg.currentSelection != null) {
                item = new JMenuItem("Clear Selection");
                popup.add(item);
                item.addActionListener(this);
                popup.addSeparator();
                if (subg.currentSelection instanceof Element) {
                    item = new JMenuItem("Select Siblings in Subgraph");
                    popup.add(item);
                    item.addActionListener(this);
                    popup.addSeparator();
                }
                item = new JMenuItem("Enclose Selected Items in a new Subgraph");
                popup.add(item);
                item.addActionListener(this);
                popup.addSeparator();
                item = new JMenuItem("Preview Deletion");
                popup.add(item);
                item.addActionListener(this);
                item = new JMenuItem("Cancel Preview");
                popup.add(item);
                item.addActionListener(this);
                item = new JMenuItem("Perform Deletion");
                popup.add(item);
                item.addActionListener(this);
                popup.addSeparator();
            }
            if (panel.hasOutline()) {
                item = new JMenuItem("Zoom to Sweep");
                popup.add(item);
                item.addActionListener(this);
            }
            item = new JMenuItem("Zoom In");
            popup.add(item);
            item.addActionListener(this);
            item = new JMenuItem("Zoom Out");
            popup.add(item);
            item.addActionListener(this);
            item = new JMenuItem("Reset Zoom");
            popup.add(item);
            item.addActionListener(this);
            item = new JMenuItem("Scale to Fit");
            popup.add(item);
            item.addActionListener(this);
            if (subg.hasEmptySubgraphs()) {
                popup.addSeparator();
                item = new JMenuItem("Remove Empty Subgraphs");
                popup.add(item);
                item.addActionListener(this);
            }
            Point2D mpt = panel.getTransform().transform(pt, null);
            popup.show(panel, (int)mpt.getX(), (int)mpt.getY());
        }
    }

    public void grappaReleased(Subgraph subg, Element elem, GrappaPoint pt, int modifiers, Element pressedElem, GrappaPoint pressedPt, int pressedModifiers, GrappaBox outline, GrappaPanel panel) {
        if (modifiers == 16 && subg.getGraph().isSelectable()) {
            if (outline != null) {
                List elems;
                boolean xorOutline = false;
                if (subg.currentSelection != null) {
                    if (subg.currentSelection instanceof Element) {
                        ((Element)subg.currentSelection).highlight = 0;
                    } else {
                        Vector vec = (Vector)subg.currentSelection;
                        for (int i = 0; i < vec.size(); ++i) {
                            ((Element)vec.elementAt((int)i)).highlight = 0;
                        }
                    }
                    subg.currentSelection = null;
                }
                if ((elems = GrappaSupport.findContainedElements(subg, outline)) != null) {
                    this.drillDown(subg, elems, 1, 4);
                    xorOutline = false;
                }
                if (!xorOutline) {
                    subg.getGraph().paintImmediately();
                }
                if (xorOutline) {
                    Graphics2D g2d = (Graphics2D)panel.getGraphics();
                    AffineTransform orig = g2d.getTransform();
                    g2d.setTransform(panel.getTransform());
                    g2d.setXORMode(Color.darkGray);
                    g2d.draw(outline);
                    g2d.setPaintMode();
                    g2d.setTransform(orig);
                }
            }
        } else if (modifiers == 18 && subg.getGraph().isSelectable()) {
            if (outline != null) {
                List elems = GrappaSupport.findContainedElements(subg, outline);
                if (elems != null) {
                    this.drillDown(subg, elems, 1, 16);
                    subg.getGraph().repaint();
                } else {
                    Graphics2D g2d = (Graphics2D)panel.getGraphics();
                    AffineTransform orig = g2d.getTransform();
                    g2d.setTransform(panel.getTransform());
                    g2d.setXORMode(Color.darkGray);
                    g2d.draw(outline);
                    g2d.setPaintMode();
                    g2d.setTransform(orig);
                }
            }
        } else if (modifiers == 17 && subg.getGraph().isEditable() && elem != null && pressedElem != null && pressedModifiers == modifiers && outline == null) {
            if (pressedElem == elem && pt.distance(pressedPt) < 5.0) {
                Attribute[] attrs = null;
                Attribute attr = subg.getNodeAttribute("label");
                attrs = attr == null || attr.getValue().equals("\\N") ? new Attribute[]{new Attribute(1, "pos", pt), new Attribute(1, "label", "Node" + subg.getGraph().getId(1))} : new Attribute[]{new Attribute(1, "pos", pt)};
                Element el = subg.createElement(1, null, attrs);
                if (el != null) {
                    el.buildShape();
                    subg.getGraph().repaint();
                }
                subg.getGraph().repaint();
            } else if (pressedElem != elem && pressedElem.isNode() && elem.isNode()) {
                Object[] info = new Object[]{elem, null, pressedElem};
                Attribute[] attrs = new Attribute[]{new Attribute(2, "pos", new GrappaLine(new GrappaPoint[]{((Node)pressedElem).getCenterPoint(), ((Node)elem).getCenterPoint()}, subg.getGraph().isDirected() ? 2 : 0))};
                Element el = subg.createElement(2, info, attrs);
                if (el != null) {
                    el.buildShape();
                    subg.getGraph().repaint();
                }
            }
        }
    }

    public void grappaDragged(Subgraph subg, GrappaPoint currentPt, int currentModifiers, Element pressedElem, GrappaPoint pressedPt, int pressedModifiers, GrappaBox outline, GrappaPanel panel) {
        if ((currentModifiers & 0x10) == 16 && (currentModifiers == 16 || currentModifiers == 18)) {
            Graphics2D g2d = (Graphics2D)panel.getGraphics();
            AffineTransform orig = g2d.getTransform();
            g2d.setTransform(panel.getTransform());
            g2d.setXORMode(Color.darkGray);
            if (outline != null) {
                g2d.draw(outline);
            }
            GrappaBox box = GrappaSupport.boxFromCorners(pressedPt.x, pressedPt.y, currentPt.x, currentPt.y);
            g2d.draw(box);
            g2d.setPaintMode();
            g2d.setTransform(orig);
        }
    }

    public String grappaTip(Subgraph subg, Element elem, GrappaPoint pt, int modifiers, GrappaPanel panel) {
        String tip = null;
        if (elem == null) {
            tip = panel.getToolTipText();
            if (tip == null && (tip = subg.getGraph().getToolTipText()) == null) {
                tip = Grappa.getToolTipText();
            }
        } else {
            switch (elem.getType()) {
                case 4: {
                    Subgraph sg = (Subgraph)elem;
                    tip = (String)sg.getAttributeValue("tip");
                    if (tip != null) break;
                    if (subg.getShowSubgraphLabels()) {
                        tip = sg.getName();
                    } else {
                        tip = (String)sg.getAttributeValue("label");
                        if (tip == null) {
                            tip = sg.getName();
                        }
                    }
                    tip = "Subgraph: " + tip;
                    break;
                }
                case 2: {
                    Edge edge = (Edge)elem;
                    tip = (String)edge.getAttributeValue("tip");
                    if (tip != null) break;
                    if (subg.getShowEdgeLabels()) {
                        tip = edge.toString();
                    } else {
                        tip = (String)edge.getAttributeValue("label");
                        if (tip == null) {
                            tip = edge.toString();
                        }
                    }
                    tip = "Edge: " + tip;
                    break;
                }
                case 1: {
                    Node node = (Node)elem;
                    tip = (String)node.getAttributeValue("tip");
                    if (tip != null) break;
                    if (subg.getShowNodeLabels()) {
                        tip = node.getName();
                    } else {
                        tip = (String)node.getAttributeValue("label");
                        if (tip == null || tip.equals("\\N")) {
                            tip = node.getName();
                        }
                    }
                    tip = "Node: " + tip;
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected type (" + elem.getType() + ")");
                }
            }
        }
        return tip;
    }

    public void actionPerformed(ActionEvent aev) {
        Component invoker;
        Container parent;
        Object src = aev.getSource();
        if (src instanceof JMenuItem && (parent = ((JMenuItem)src).getParent()) instanceof JPopupMenu && (invoker = ((JPopupMenu)((JMenuItem)src).getParent()).getInvoker()) instanceof GrappaPanel) {
            GrappaPanel gp = (GrappaPanel)invoker;
            Subgraph subg = gp.getSubgraph();
            String text = ((JMenuItem)src).getText();
            if (text.startsWith("Cancel")) {
                if (subg.currentSelection == null) {
                    return;
                }
                if (subg.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subg.currentSelection, 2, 8);
                } else {
                    Vector vec = (Vector)subg.currentSelection;
                    for (int i = 0; i < vec.size(); ++i) {
                        GrappaSupport.setHighlight((Element)vec.elementAt(i), 2, 8);
                    }
                }
                subg.getGraph().repaint();
            } else if (text.startsWith("Clear")) {
                if (subg.currentSelection == null) {
                    return;
                }
                if (subg.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subg.currentSelection, 0, 8);
                } else {
                    Vector vec = (Vector)subg.currentSelection;
                    for (int i = 0; i < vec.size(); ++i) {
                        GrappaSupport.setHighlight((Element)vec.elementAt(i), 0, 8);
                    }
                }
                subg.currentSelection = null;
                subg.getGraph().repaint();
            } else if (text.startsWith("Select")) {
                if (subg.currentSelection == null) {
                    return;
                }
                if (!(subg.currentSelection instanceof Element)) {
                    return;
                }
                Subgraph elem = ((Element)subg.currentSelection).getSubgraph();
                if (elem == null || subg.currentSelection == elem || !(elem instanceof Subgraph)) {
                    return;
                }
                ((Element)subg.currentSelection).highlight &= 0xFFFFFFFC;
                Vector<Element> elems = new Vector<Element>();
                Iterator<Element> enm = elem.nodeElements();
                while (enm.hasNext()) {
                    elems.add(enm.next());
                }
                enm = elem.edgeElements();
                while (enm.hasNext()) {
                    elems.add(enm.next());
                }
                subg.currentSelection = null;
                if (elems != null && elems.size() > 0) {
                    this.drillDown(subg, elems, 1, 4);
                }
                subg.getGraph().repaint();
            } else if (text.startsWith("Enclose")) {
                if (subg.currentSelection == null || subg.currentSelection == subg) {
                    return;
                }
                Subgraph newsubg = new Subgraph(subg);
                if (subg.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subg.currentSelection, 0, 8);
                    ((Element)subg.currentSelection).setSubgraph(newsubg);
                } else {
                    Vector vec = (Vector)subg.currentSelection;
                    for (int i = 0; i < vec.size(); ++i) {
                        GrappaSupport.setHighlight((Element)vec.elementAt(i), 0, 8);
                        if ((Element)vec.elementAt(i) == subg) continue;
                        ((Element)vec.elementAt(i)).setSubgraph(newsubg);
                    }
                }
                subg.currentSelection = null;
                subg.getGraph().repaint();
            } else if (text.startsWith("Preview")) {
                if (subg.currentSelection == null) {
                    return;
                }
                if (subg.currentSelection instanceof Element) {
                    GrappaSupport.setHighlight((Element)subg.currentSelection, 2, 4);
                } else {
                    Vector vec = (Vector)subg.currentSelection;
                    for (int i = 0; i < vec.size(); ++i) {
                        GrappaSupport.setHighlight((Element)vec.elementAt(i), 2, 4);
                    }
                }
                subg.getGraph().repaint();
            } else if (text.startsWith("Perform")) {
                if (subg.currentSelection == null) {
                    return;
                }
                if (subg.currentSelection instanceof Element) {
                    ((Element)subg.currentSelection).delete();
                } else {
                    Vector vec = (Vector)subg.currentSelection;
                    for (int i = 0; i < vec.size(); ++i) {
                        ((Element)vec.elementAt(i)).delete();
                    }
                }
                subg.currentSelection = null;
                subg.getGraph().repaint();
            } else if (text.startsWith("Remove")) {
                subg.removeEmptySubgraphs();
            } else if (text.startsWith("Reset")) {
                gp.setScaleToFit(false);
                gp.setScaleToSize(null);
                gp.resetZoom();
                gp.clearOutline();
                gp.repaint();
            } else if (text.startsWith("Scale")) {
                gp.setScaleToFit(true);
                gp.repaint();
            } else if (text.startsWith("Print")) {
                PageFormat pf = new PageFormat();
                Rectangle2D bb = subg.getBoundingBox();
                if (bb.getWidth() > bb.getHeight()) {
                    pf.setOrientation(0);
                }
                try {
                    PrinterJob printJob = PrinterJob.getPrinterJob();
                    printJob.setPrintable(gp, pf);
                    if (printJob.printDialog()) {
                        printJob.print();
                    }
                }
                catch (Exception ex) {
                    Grappa.displayException(ex, "Problem with print request");
                }
            } else if (text.startsWith("ToolTips")) {
                if (text.indexOf("Off") > 0) {
                    gp.setToolTipText(null);
                } else {
                    String tip = subg.getGraph().getToolTipText();
                    if (tip == null) {
                        tip = Grappa.getToolTipText();
                    }
                    gp.setToolTipText(tip);
                }
            } else if (text.startsWith("Zoom In")) {
                gp.setScaleToFit(false);
                gp.setScaleToSize(null);
                gp.multiplyScaleFactor(1.25);
                gp.clearOutline();
                gp.repaint();
            } else if (text.startsWith("Zoom Out")) {
                gp.setScaleToFit(false);
                gp.setScaleToSize(null);
                gp.multiplyScaleFactor(0.8);
                gp.clearOutline();
                gp.repaint();
            } else if (text.startsWith("Zoom to")) {
                gp.setScaleToFit(false);
                gp.setScaleToSize(null);
                gp.zoomToOutline();
                gp.clearOutline();
                gp.repaint();
            }
        }
    }

    protected void drillDown(Subgraph subg, List elems, int mode, int setting) {
        Object obj = null;
        block5: for (int i = 0; i < elems.size(); ++i) {
            obj = elems.get(i);
            if (obj instanceof List) {
                this.drillDown(subg, (List)obj, mode, setting);
                continue;
            }
            GrappaSupport.setHighlight((Element)obj, mode, setting);
            switch (setting) {
                case 16: {
                    Object crnt;
                    if ((((Element)obj).highlight & mode) == mode) {
                        if (subg.currentSelection == null) {
                            subg.currentSelection = obj;
                            continue block5;
                        }
                        if (subg.currentSelection instanceof Element) {
                            crnt = subg.currentSelection;
                            subg.currentSelection = new Vector();
                            ((Vector)subg.currentSelection).add(crnt);
                            ((Vector)subg.currentSelection).add(obj);
                            continue block5;
                        }
                        ((Vector)subg.currentSelection).add(obj);
                        continue block5;
                    }
                    if (subg.currentSelection == obj) {
                        subg.currentSelection = null;
                        continue block5;
                    }
                    if (!(subg.currentSelection instanceof Vector)) continue block5;
                    ((Vector)subg.currentSelection).remove(obj);
                    continue block5;
                }
                case 4: {
                    Object crnt;
                    if (subg.currentSelection == null) {
                        subg.currentSelection = obj;
                        continue block5;
                    }
                    if (subg.currentSelection instanceof Element) {
                        crnt = subg.currentSelection;
                        subg.currentSelection = new Vector();
                        ((Vector)subg.currentSelection).add(crnt);
                        ((Vector)subg.currentSelection).add(obj);
                        continue block5;
                    }
                    ((Vector)subg.currentSelection).add(obj);
                    continue block5;
                }
                case 8: {
                    if (subg.currentSelection == null) continue block5;
                    if (subg.currentSelection == obj) {
                        subg.currentSelection = null;
                        continue block5;
                    }
                    if (!(subg.currentSelection instanceof Vector)) continue block5;
                    ((Vector)subg.currentSelection).remove(obj);
                }
            }
        }
    }
}

