/* BEGIN LICENSE BLOCK
 * Version: CMPL 1.1
 *
 * The contents of this file are subject to the Cisco-style Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file except
 * in compliance with the License.  You may obtain a copy of the License
 * at www.eclipseclp.org/license.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
 * the License for the specific language governing rights and limitations
 * under the License. 
 * 
 * The Original Code is  The ECLiPSe/HiGHS Interface
 * The Initial Developer of the Original Code is Joachim Schimpf
 * Portions created by the Initial Developer are
 * Copyright (C) 2024 Joachim Schimpf
 * 
 * Contributor(s): Joachim Schimpf, Coninfer Ltd
 * 
 * END LICENSE BLOCK */

/*
 * ECLiPSe/HiGHS interface (for inclusion in eplex.c)
 */

#include "HConfig.h"                    /* for HIGHS_VERSION_XXX */
#include "interfaces/highs_c_api.h"

#define CPXENVptr		void*   /* dummy problem for holding defaults */
#define CPXLPptr		void*

typedef char* param_id_t;
typedef int sostype_t;


#include "eplex.h"	                /* needs declarations above! */


/*
 * Capabilities
 */
#undef HAS_LIMITED_MIP_RESULTS
#define SOLVER_HAS_LOCAL_PARAMETERS
#define SOLVER_HAS_STR_PARAMS
#define SOLVER_HAS_BOOL_PARAMS
/*TODO*/
#undef HAS_QUADRATIC
#undef HAS_MIQP
#undef HAS_CONCURRENT
#undef HAS_INDICATOR_CONSTRAINTS


/*
 * Constants
 */
#define SOLVER_SHORT_NAME	HIGHS
#define SOLVER_ATOMIC_NAME	"highs"
#define SOLVER_VERSION_INT	(100*HIGHS_VERSION_MAJOR+HIGHS_VERSION_MINOR)

#define CPXPUBLIC

#define CPX_INFBOUND		HUGE_VAL
#undef INTS_NEED_INT_BOUNDS    /* integer variables must have integral bounds */

#define SOLVER_SENSE_EQ		0
#define SOLVER_SENSE_LE		1
#define SOLVER_SENSE_GE		2
	
#define SOLVER_SOS_TYPE1	1
#define SOLVER_SOS_TYPE2	2

#define CPX_COL_AT_LOWER	kHighsBasisStatusLower
#define CPX_COL_AT_UPPER	kHighsBasisStatusUpper
#define CPX_COL_BASIC		kHighsBasisStatusBasic
#define CPX_COL_FREE_SUPER	kHighsBasisStatusNonbasic


#define STRBUFFERSIZE		kHighsMaximumStringLength


#define Update_Model(LP)
#define SetPreSolve(state)

