/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.VisException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ViewableType
implements Serializable {
    static List atomListToStringList(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (Atom atom : collection) {
            arrayList.add(atom.functor());
        }
        return arrayList;
    }

    static ViewableType parseFromCompoundTerm(CompoundTerm compoundTerm) throws VisException {
        if (compoundTerm.functor().equals("array") && compoundTerm.arity() == 2) {
            List list = ViewableType.atomListToStringList((Collection)compoundTerm.arg(1));
            CompoundTerm compoundTerm2 = (CompoundTerm)compoundTerm.arg(2);
            return new ArrayType(new LinkedList(list), ElementType.parseFromCompoundTerm(compoundTerm2));
        }
        if ("multi_array".equals(compoundTerm.functor()) && compoundTerm.arity() == 3) {
            Collection collection = (Collection)compoundTerm.arg(1);
            Collection collection2 = (Collection)compoundTerm.arg(2);
            Collection collection3 = (Collection)compoundTerm.arg(3);
            Iterator iterator = collection.iterator();
            Iterator iterator2 = collection2.iterator();
            ArrayList<ArrayType> arrayList = new ArrayList<ArrayType>(collection.size());
            while (iterator.hasNext()) {
                List list = ViewableType.atomListToStringList((Collection)iterator.next());
                CompoundTerm compoundTerm3 = (CompoundTerm)iterator2.next();
                ArrayType arrayType = new ArrayType(new LinkedList(list), ElementType.parseFromCompoundTerm(compoundTerm3));
                arrayList.add(arrayType);
            }
            return new MultiArrayType(arrayList, ViewableType.atomListToStringList(collection3));
        }
        throw new VisException("Could not parse viewable type from term " + String.valueOf(compoundTerm));
    }

    public static class MultiArrayType
    extends ViewableType {
        List subTypes;
        List subNames;

        MultiArrayType(List list, List list2) {
            this.subTypes = list;
            this.subNames = list2;
        }

        public ArrayType getSubType(int n) {
            return (ArrayType)this.subTypes.get(n);
        }

        public String getSubTypeName(int n) {
            return (String)this.subNames.get(n);
        }
    }

    public static class ArrayType
    extends ViewableType {
        private ElementType elementType;
        private List fixityList;

        ArrayType(List list, ElementType elementType) {
            this.setElementType(elementType);
            this.setFixityList(list);
        }

        protected void setElementType(ElementType elementType) {
            this.elementType = elementType;
        }

        protected void setFixityList(List list) {
            this.fixityList = list;
        }

        public int getNDimensions() {
            return this.fixityList.size();
        }

        public List getFixityList() {
            return this.fixityList;
        }

        public ElementType getElementType() {
            return this.elementType;
        }
    }
}

