/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.jdotview;

import att.grappa.Graph;
import att.grappa.Grappa;
import att.grappa.GrappaAdapter;
import att.grappa.GrappaListener;
import att.grappa.GrappaPanel;
import att.grappa.Parser;
import att.grappa.Subgraph;
import com.parctechnologies.eclipse.jdotview.FileWatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class GraphVizPanel
extends JPanel
implements ActionListener {
    MyGrappaPanel gp;
    Graph graph = null;
    String filename;
    FileWatcher fw = null;
    JButton printer = null;
    JButton alias = null;
    JButton draw = null;
    JButton quit = null;
    JPanel panel = null;
    JScrollPane jsp = null;

    public GraphVizPanel(String string, long l) {
        this.filename = string;
        this.fw = new FileWatcher(string, l);
        this.fw.addActionListener(this);
        this.fw.start();
        this.jsp = new JScrollPane();
        this.jsp.getViewport().setBackingStoreEnabled(true);
        Grappa.nodeLabelsScaleCutoff = 0.1;
        Grappa.edgeLabelsScaleCutoff = 0.1;
        Grappa.subgLabelsScaleCutoff = 0.1;
        Grappa.useAntiAliasing = false;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.panel = new JPanel();
        this.panel.setLayout(gridBagLayout);
        this.draw = new JButton("Draw");
        gridBagLayout.setConstraints(this.draw, gridBagConstraints);
        this.panel.add(this.draw);
        this.draw.addActionListener(this);
        this.alias = new JButton("Antialias");
        gridBagLayout.setConstraints(this.alias, gridBagConstraints);
        this.panel.add(this.alias);
        this.alias.addActionListener(this);
        this.printer = new JButton("Print");
        gridBagLayout.setConstraints(this.printer, gridBagConstraints);
        this.panel.add(this.printer);
        this.printer.addActionListener(this);
        this.quit = new JButton("Quit");
        gridBagLayout.setConstraints(this.quit, gridBagConstraints);
        this.panel.add(this.quit);
        this.quit.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.jsp);
        this.add("West", this.panel);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.draw && this.graph != null) {
                this.graph.repaint();
            } else if (jButton == this.quit) {
                this.cleanupAndExit();
            } else if (jButton == this.alias && this.graph != null) {
                Grappa.useAntiAliasing = !Grappa.useAntiAliasing;
                this.graph.repaint();
            } else if (jButton == this.printer && this.graph != null) {
                PageFormat pageFormat = new PageFormat();
                Rectangle2D rectangle2D = this.graph.getBoundingBox();
                if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                    pageFormat.setOrientation(0);
                }
                try {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable((Printable)((Object)this.gp), pageFormat);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
                catch (Exception exception) {
                    Grappa.displayException((Exception)exception, (String)"Problem with print request");
                }
            }
        } else if (actionEvent.getSource() instanceof FileWatcher) {
            String string = actionEvent.paramString();
            try {
                this.setGraph(this.loadGraph(this.filename));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.toString());
                System.exit(1);
            }
        }
    }

    public Graph loadGraph(String string) throws FileNotFoundException {
        InputStream inputStream = System.in;
        inputStream = new FileInputStream(string);
        Parser parser = new Parser(inputStream, (OutputStream)System.err);
        try {
            parser.parse();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(1);
        }
        return parser.getGraph();
    }

    public void setGraph(Graph graph) {
        boolean bl = true;
        Dimension2D dimension2D = null;
        double d = 1.0;
        this.graph = graph;
        if (this.gp != null) {
            bl = this.gp.getScaleToFit();
            dimension2D = this.gp.getScaleToSize();
            d = this.gp.getScaleFactor();
        }
        this.gp = new MyGrappaPanel(this.graph);
        this.gp.addGrappaListener((GrappaListener)new MyGrappaAdapter());
        this.gp.setScaleToFit(bl);
        this.gp.setScaleToSize(dimension2D);
        this.gp.multiplyScaleFactor(d);
        Rectangle rectangle = this.graph.getBoundingBox().getBounds();
        Point point = this.jsp.getViewport().getViewPosition();
        this.jsp.getViewport().setView((Component)((Object)this.gp));
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jsp.getViewport().setViewPosition(point);
    }

    public void cleanupAndExit() {
        if (0 == JOptionPane.showConfirmDialog(null, "Delete temporary file \"" + this.filename + "\"")) {
            new File(this.filename).delete();
        }
        System.exit(0);
    }

    class MyGrappaPanel
    extends GrappaPanel {
        boolean myScaleToFit;
        Dimension2D myScaleToSize;
        double mult;

        public MyGrappaPanel(Graph graph) {
            super((Subgraph)graph);
        }

        public void setScaleToFit(boolean bl) {
            super.setScaleToFit(bl);
            this.myScaleToFit = bl;
        }

        public boolean getScaleToFit() {
            return this.myScaleToFit;
        }

        public void setScaleToSize(Dimension2D dimension2D) {
            super.setScaleToSize(dimension2D);
            this.myScaleToSize = dimension2D;
        }

        public Dimension2D getScaleToSize() {
            return this.myScaleToSize;
        }

        public double multiplyScaleFactor(double d) {
            double d2 = super.multiplyScaleFactor(d);
            this.mult = d2 * d;
            if (this.mult == 0.0) {
                this.mult = d2;
            }
            return d2;
        }

        public double getScaleFactor() {
            return this.mult;
        }
    }

    class MyGrappaAdapter
    extends GrappaAdapter {
        MyGrappaAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            RepaintManager.currentManager((JComponent)((Object)GraphVizPanel.this.gp)).markCompletelyDirty((JComponent)((Object)GraphVizPanel.this.gp));
        }
    }
}

