/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.AnyElementType;
import com.parctechnologies.eclipse.visualisation.GraphData;
import com.parctechnologies.eclipse.visualisation.NumericBounds;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerBuildingPolicy;
import com.parctechnologies.eclipse.visualisation.ViewerFactory;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.viewers.BoundsViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.Chart2DViewerFactory;
import com.parctechnologies.eclipse.visualisation.viewers.FadeViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.GanttViewerFactory;
import com.parctechnologies.eclipse.visualisation.viewers.GraphViewerFactory;
import com.parctechnologies.eclipse.visualisation.viewers.TableViewerFactory;
import com.parctechnologies.eclipse.visualisation.viewers.TextViewletType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class DefaultViewerBuildingPolicy
implements ViewerBuildingPolicy {
    private Map factories;
    private Map enabled;
    private VisClientStateModel stateModel;

    DefaultViewerBuildingPolicy(VisClientStateModel visClientStateModel) {
        this.stateModel = visClientStateModel;
        this.factories = new HashMap();
        this.enabled = new HashMap();
        this.factories.put("TextTable", new TableViewerFactory(visClientStateModel, TextViewletType.class, AnyElementType.class));
        this.enabled.put("TextTable", new Boolean(true));
        this.factories.put("FadeTable", new TableViewerFactory(visClientStateModel, FadeViewletType.class, AnyElementType.class));
        this.enabled.put("FadeTable", new Boolean(true));
        this.factories.put("BoundsTable", new TableViewerFactory(visClientStateModel, BoundsViewletType.class, NumericBounds.class));
        this.enabled.put("BoundsTable", new Boolean(true));
        this.factories.put("Network", new GraphViewerFactory(visClientStateModel, 1, false, false, GraphData.class));
        this.enabled.put("Network", new Boolean(true));
        this.factories.put("Network (0/1)", new GraphViewerFactory(visClientStateModel, 1, true, false, GraphData.class));
        this.enabled.put("Network (0/1)", new Boolean(true));
        this.factories.put("Network (capacity)", new GraphViewerFactory(visClientStateModel, 1, false, true, GraphData.class));
        this.enabled.put("Network (capacity)", new Boolean(true));
        this.factories.put("Desktop", new GraphViewerFactory(visClientStateModel, 0, false, false, AnyElementType.class));
        this.enabled.put("Desktop", new Boolean(true));
        this.factories.put("Gantt Chart", new GanttViewerFactory(visClientStateModel, 0, NumericBounds.class));
        this.enabled.put("Gantt Chart", new Boolean(true));
        this.factories.put("2D Chart", new Chart2DViewerFactory(visClientStateModel, 0, NumericBounds.class));
        this.enabled.put("2D Chart", new Boolean(true));
    }

    public Set availableViewerFactories(ViewableType viewableType) {
        TreeSet treeSet = new TreeSet();
        for (Object k : this.factories.keySet()) {
            ViewerFactory viewerFactory = (ViewerFactory)this.factories.get(k);
            if (!viewerFactory.canBuildFrom(viewableType)) continue;
            treeSet.add(k);
        }
        return treeSet;
    }

    public void enableViewers(List list) {
        for (Object k : this.factories.keySet()) {
            if (list.contains(k)) {
                this.enabled.put(k, new Boolean(true));
                continue;
            }
            this.enabled.put(k, new Boolean(false));
        }
        this.stateModel.setViewerBuildingPolicySelected(true);
    }

    @Override
    public List buildViewers(Viewable viewable) {
        LinkedList<Viewer> linkedList = new LinkedList<Viewer>();
        for (Object e : this.availableViewerFactories(viewable.getType())) {
            ViewerFactory viewerFactory = (ViewerFactory)this.factories.get(e);
            if (!((Boolean)this.enabled.get(e)).booleanValue() || !viewerFactory.canBuildFrom(viewable.getType())) continue;
            linkedList.add(viewerFactory.build(viewable));
        }
        return linkedList;
    }
}

